/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * BatchDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class BatchDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_TOTAL_JOBS = "totalJobs";
  @SerializedName(SERIALIZED_NAME_TOTAL_JOBS)
  private Integer totalJobs;

  public static final String SERIALIZED_NAME_JOBS_CREATED = "jobsCreated";
  @SerializedName(SERIALIZED_NAME_JOBS_CREATED)
  private Integer jobsCreated;

  public static final String SERIALIZED_NAME_BATCH_JOBS_PER_SEED = "batchJobsPerSeed";
  @SerializedName(SERIALIZED_NAME_BATCH_JOBS_PER_SEED)
  private Integer batchJobsPerSeed;

  public static final String SERIALIZED_NAME_INVOCATIONS_PER_BATCH_JOB = "invocationsPerBatchJob";
  @SerializedName(SERIALIZED_NAME_INVOCATIONS_PER_BATCH_JOB)
  private Integer invocationsPerBatchJob;

  public static final String SERIALIZED_NAME_SEED_JOB_DEFINITION_ID = "seedJobDefinitionId";
  @SerializedName(SERIALIZED_NAME_SEED_JOB_DEFINITION_ID)
  private String seedJobDefinitionId;

  public static final String SERIALIZED_NAME_MONITOR_JOB_DEFINITION_ID = "monitorJobDefinitionId";
  @SerializedName(SERIALIZED_NAME_MONITOR_JOB_DEFINITION_ID)
  private String monitorJobDefinitionId;

  public static final String SERIALIZED_NAME_BATCH_JOB_DEFINITION_ID = "batchJobDefinitionId";
  @SerializedName(SERIALIZED_NAME_BATCH_JOB_DEFINITION_ID)
  private String batchJobDefinitionId;

  public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
  @SerializedName(SERIALIZED_NAME_SUSPENDED)
  private Boolean suspended;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_CREATE_USER_ID = "createUserId";
  @SerializedName(SERIALIZED_NAME_CREATE_USER_ID)
  private String createUserId;


  public BatchDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the batch.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the batch.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public BatchDto type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public BatchDto totalJobs(Integer totalJobs) {
    
    this.totalJobs = totalJobs;
    return this;
  }

   /**
   * The total jobs of a batch is the number of batch execution jobs required to complete the batch.
   * @return totalJobs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total jobs of a batch is the number of batch execution jobs required to complete the batch.")

  public Integer getTotalJobs() {
    return totalJobs;
  }


  public void setTotalJobs(Integer totalJobs) {
    this.totalJobs = totalJobs;
  }


  public BatchDto jobsCreated(Integer jobsCreated) {
    
    this.jobsCreated = jobsCreated;
    return this;
  }

   /**
   * The number of batch execution jobs already created by the seed job.
   * @return jobsCreated
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The number of batch execution jobs already created by the seed job.")

  public Integer getJobsCreated() {
    return jobsCreated;
  }


  public void setJobsCreated(Integer jobsCreated) {
    this.jobsCreated = jobsCreated;
  }


  public BatchDto batchJobsPerSeed(Integer batchJobsPerSeed) {
    
    this.batchJobsPerSeed = batchJobsPerSeed;
    return this;
  }

   /**
   * The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see &#x60;totalJobs&#x60; property).
   * @return batchJobsPerSeed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see `totalJobs` property).")

  public Integer getBatchJobsPerSeed() {
    return batchJobsPerSeed;
  }


  public void setBatchJobsPerSeed(Integer batchJobsPerSeed) {
    this.batchJobsPerSeed = batchJobsPerSeed;
  }


  public BatchDto invocationsPerBatchJob(Integer invocationsPerBatchJob) {
    
    this.invocationsPerBatchJob = invocationsPerBatchJob;
    return this;
  }

   /**
   * Every batch execution job invokes the command executed by the batch &#x60;invocationsPerBatchJob&#x60; times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job.
   * @return invocationsPerBatchJob
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Every batch execution job invokes the command executed by the batch `invocationsPerBatchJob` times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job.")

  public Integer getInvocationsPerBatchJob() {
    return invocationsPerBatchJob;
  }


  public void setInvocationsPerBatchJob(Integer invocationsPerBatchJob) {
    this.invocationsPerBatchJob = invocationsPerBatchJob;
  }


  public BatchDto seedJobDefinitionId(String seedJobDefinitionId) {
    
    this.seedJobDefinitionId = seedJobDefinitionId;
    return this;
  }

   /**
   * The job definition id for the seed jobs of this batch.
   * @return seedJobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition id for the seed jobs of this batch.")

  public String getSeedJobDefinitionId() {
    return seedJobDefinitionId;
  }


  public void setSeedJobDefinitionId(String seedJobDefinitionId) {
    this.seedJobDefinitionId = seedJobDefinitionId;
  }


  public BatchDto monitorJobDefinitionId(String monitorJobDefinitionId) {
    
    this.monitorJobDefinitionId = monitorJobDefinitionId;
    return this;
  }

   /**
   * The job definition id for the monitor jobs of this batch.
   * @return monitorJobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition id for the monitor jobs of this batch.")

  public String getMonitorJobDefinitionId() {
    return monitorJobDefinitionId;
  }


  public void setMonitorJobDefinitionId(String monitorJobDefinitionId) {
    this.monitorJobDefinitionId = monitorJobDefinitionId;
  }


  public BatchDto batchJobDefinitionId(String batchJobDefinitionId) {
    
    this.batchJobDefinitionId = batchJobDefinitionId;
    return this;
  }

   /**
   * The job definition id for the batch execution jobs of this batch.
   * @return batchJobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition id for the batch execution jobs of this batch.")

  public String getBatchJobDefinitionId() {
    return batchJobDefinitionId;
  }


  public void setBatchJobDefinitionId(String batchJobDefinitionId) {
    this.batchJobDefinitionId = batchJobDefinitionId;
  }


  public BatchDto suspended(Boolean suspended) {
    
    this.suspended = suspended;
    return this;
  }

   /**
   * Indicates whether this batch is suspended or not.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Indicates whether this batch is suspended or not.")

  public Boolean getSuspended() {
    return suspended;
  }


  public void setSuspended(Boolean suspended) {
    this.suspended = suspended;
  }


  public BatchDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The tenant id of the batch.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The tenant id of the batch.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public BatchDto createUserId(String createUserId) {
    
    this.createUserId = createUserId;
    return this;
  }

   /**
   * The id of the user that created the batch.
   * @return createUserId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the user that created the batch.")

  public String getCreateUserId() {
    return createUserId;
  }


  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchDto batchDto = (BatchDto) o;
    return Objects.equals(this.id, batchDto.id) &&
        Objects.equals(this.type, batchDto.type) &&
        Objects.equals(this.totalJobs, batchDto.totalJobs) &&
        Objects.equals(this.jobsCreated, batchDto.jobsCreated) &&
        Objects.equals(this.batchJobsPerSeed, batchDto.batchJobsPerSeed) &&
        Objects.equals(this.invocationsPerBatchJob, batchDto.invocationsPerBatchJob) &&
        Objects.equals(this.seedJobDefinitionId, batchDto.seedJobDefinitionId) &&
        Objects.equals(this.monitorJobDefinitionId, batchDto.monitorJobDefinitionId) &&
        Objects.equals(this.batchJobDefinitionId, batchDto.batchJobDefinitionId) &&
        Objects.equals(this.suspended, batchDto.suspended) &&
        Objects.equals(this.tenantId, batchDto.tenantId) &&
        Objects.equals(this.createUserId, batchDto.createUserId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, totalJobs, jobsCreated, batchJobsPerSeed, invocationsPerBatchJob, seedJobDefinitionId, monitorJobDefinitionId, batchJobDefinitionId, suspended, tenantId, createUserId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    totalJobs: ").append(toIndentedString(totalJobs)).append("\n");
    sb.append("    jobsCreated: ").append(toIndentedString(jobsCreated)).append("\n");
    sb.append("    batchJobsPerSeed: ").append(toIndentedString(batchJobsPerSeed)).append("\n");
    sb.append("    invocationsPerBatchJob: ").append(toIndentedString(invocationsPerBatchJob)).append("\n");
    sb.append("    seedJobDefinitionId: ").append(toIndentedString(seedJobDefinitionId)).append("\n");
    sb.append("    monitorJobDefinitionId: ").append(toIndentedString(monitorJobDefinitionId)).append("\n");
    sb.append("    batchJobDefinitionId: ").append(toIndentedString(batchJobDefinitionId)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

