/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.ActivityStatisticsResultDto;
import org.camunda.community.rest.client.dto.AuthorizationExceptionDto;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CalledProcessDefinitionDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.FormDto;
import org.camunda.community.rest.client.dto.HistoryTimeToLiveDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDiagramDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionStatisticsResultDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionSuspensionStateDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.ProcessInstanceWithVariablesDto;
import org.camunda.community.rest.client.dto.RestartProcessInstanceDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceFormDto;
import org.camunda.community.rest.client.dto.VariableValueDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessDefinitionApi {
    private ApiClient localVarApiClient;

    public ProcessDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProcessDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteProcessDefinition
     * @param id The id of the process definition to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessDefinitionCall(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cascade != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cascade", cascade));
        }

        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }

        if (skipIoMappings != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteProcessDefinitionValidateBeforeCall(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProcessDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = deleteProcessDefinitionCall(id, cascade, skipCustomListeners, skipIoMappings, _callback);
        return localVarCall;

    }

    /**
     * Delete
     * Deletes a running process instance by id.
     * @param id The id of the process definition to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteProcessDefinition(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        deleteProcessDefinitionWithHttpInfo(id, cascade, skipCustomListeners, skipIoMappings);
    }

    /**
     * Delete
     * Deletes a running process instance by id.
     * @param id The id of the process definition to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteProcessDefinitionWithHttpInfo(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        okhttp3.Call localVarCall = deleteProcessDefinitionValidateBeforeCall(id, cascade, skipCustomListeners, skipIoMappings, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete (asynchronously)
     * Deletes a running process instance by id.
     * @param id The id of the process definition to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessDefinitionAsync(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteProcessDefinitionValidateBeforeCall(id, cascade, skipCustomListeners, skipIoMappings, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteProcessDefinitionsByKey
     * @param key The key of the process definitions to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessDefinitionsByKeyCall(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cascade != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cascade", cascade));
        }

        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }

        if (skipIoMappings != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteProcessDefinitionsByKeyValidateBeforeCall(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling deleteProcessDefinitionsByKey(Async)");
        }
        

        okhttp3.Call localVarCall = deleteProcessDefinitionsByKeyCall(key, cascade, skipCustomListeners, skipIoMappings, _callback);
        return localVarCall;

    }

    /**
     * Delete By Key
     * Deletes process definitions by a given key which belong to no tenant id.
     * @param key The key of the process definitions to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteProcessDefinitionsByKey(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        deleteProcessDefinitionsByKeyWithHttpInfo(key, cascade, skipCustomListeners, skipIoMappings);
    }

    /**
     * Delete By Key
     * Deletes process definitions by a given key which belong to no tenant id.
     * @param key The key of the process definitions to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteProcessDefinitionsByKeyWithHttpInfo(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        okhttp3.Call localVarCall = deleteProcessDefinitionsByKeyValidateBeforeCall(key, cascade, skipCustomListeners, skipIoMappings, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete By Key (asynchronously)
     * Deletes process definitions by a given key which belong to no tenant id.
     * @param key The key of the process definitions to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessDefinitionsByKeyAsync(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteProcessDefinitionsByKeyValidateBeforeCall(key, cascade, skipCustomListeners, skipIoMappings, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteProcessDefinitionsByKeyAndTenantId
     * @param key The key of the process definitions to be deleted. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessDefinitionsByKeyAndTenantIdCall(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cascade != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cascade", cascade));
        }

        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }

        if (skipIoMappings != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteProcessDefinitionsByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling deleteProcessDefinitionsByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling deleteProcessDefinitionsByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = deleteProcessDefinitionsByKeyAndTenantIdCall(key, tenantId, cascade, skipCustomListeners, skipIoMappings, _callback);
        return localVarCall;

    }

    /**
     * Delete By Key
     * Deletes process definitions by a given key and which belong to a tenant id.
     * @param key The key of the process definitions to be deleted. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteProcessDefinitionsByKeyAndTenantId(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        deleteProcessDefinitionsByKeyAndTenantIdWithHttpInfo(key, tenantId, cascade, skipCustomListeners, skipIoMappings);
    }

    /**
     * Delete By Key
     * Deletes process definitions by a given key and which belong to a tenant id.
     * @param key The key of the process definitions to be deleted. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteProcessDefinitionsByKeyAndTenantIdWithHttpInfo(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        okhttp3.Call localVarCall = deleteProcessDefinitionsByKeyAndTenantIdValidateBeforeCall(key, tenantId, cascade, skipCustomListeners, skipIoMappings, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete By Key (asynchronously)
     * Deletes process definitions by a given key and which belong to a tenant id.
     * @param key The key of the process definitions to be deleted. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @param cascade &#x60;true&#x60;, if all process instances, historic process instances and jobs for this process definition should be deleted. (optional)
     * @param skipCustomListeners &#x60;true&#x60;, if only the built-in ExecutionListeners should be notified with the end event. (optional, default to false)
     * @param skipIoMappings A boolean value to control whether input/output mappings should be executed during deletion. &#x60;true&#x60;, if input/output mappings should not be invoked. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden The process definitions with the given &#x60;key&#x60; cannot be deleted due to missing permissions. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessDefinitionsByKeyAndTenantIdAsync(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteProcessDefinitionsByKeyAndTenantIdValidateBeforeCall(key, tenantId, cascade, skipCustomListeners, skipIoMappings, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getActivityStatistics
     * @param id The id of the process definition. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityStatisticsCall(String id, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/statistics"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (failedJobs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }

        if (incidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidents", incidents));
        }

        if (incidentsForType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getActivityStatisticsValidateBeforeCall(String id, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getActivityStatistics(Async)");
        }
        

        okhttp3.Call localVarCall = getActivityStatisticsCall(id, failedJobs, incidents, incidentsForType, _callback);
        return localVarCall;

    }

    /**
     * Get Activity Instance Statistics
     * Retrieves runtime statistics of a given process definition, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param id The id of the process definition. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @return List&lt;ActivityStatisticsResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<ActivityStatisticsResultDto> getActivityStatistics(String id, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        ApiResponse<List<ActivityStatisticsResultDto>> localVarResp = getActivityStatisticsWithHttpInfo(id, failedJobs, incidents, incidentsForType);
        return localVarResp.getData();
    }

    /**
     * Get Activity Instance Statistics
     * Retrieves runtime statistics of a given process definition, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param id The id of the process definition. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @return ApiResponse&lt;List&lt;ActivityStatisticsResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ActivityStatisticsResultDto>> getActivityStatisticsWithHttpInfo(String id, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        okhttp3.Call localVarCall = getActivityStatisticsValidateBeforeCall(id, failedJobs, incidents, incidentsForType, null);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Activity Instance Statistics (asynchronously)
     * Retrieves runtime statistics of a given process definition, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param id The id of the process definition. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityStatisticsAsync(String id, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback<List<ActivityStatisticsResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getActivityStatisticsValidateBeforeCall(id, failedJobs, incidents, incidentsForType, _callback);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getActivityStatisticsByProcessDefinitionKey
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityStatisticsByProcessDefinitionKeyCall(String key, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/statistics"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (failedJobs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }

        if (incidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidents", incidents));
        }

        if (incidentsForType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getActivityStatisticsByProcessDefinitionKeyValidateBeforeCall(String key, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getActivityStatisticsByProcessDefinitionKey(Async)");
        }
        

        okhttp3.Call localVarCall = getActivityStatisticsByProcessDefinitionKeyCall(key, failedJobs, incidents, incidentsForType, _callback);
        return localVarCall;

    }

    /**
     * Get Activity Instance Statistics
     * Retrieves runtime statistics of the latest version of the given process definition which belongs to no tenant, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @return List&lt;ActivityStatisticsResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKey(String key, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        ApiResponse<List<ActivityStatisticsResultDto>> localVarResp = getActivityStatisticsByProcessDefinitionKeyWithHttpInfo(key, failedJobs, incidents, incidentsForType);
        return localVarResp.getData();
    }

    /**
     * Get Activity Instance Statistics
     * Retrieves runtime statistics of the latest version of the given process definition which belongs to no tenant, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @return ApiResponse&lt;List&lt;ActivityStatisticsResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ActivityStatisticsResultDto>> getActivityStatisticsByProcessDefinitionKeyWithHttpInfo(String key, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        okhttp3.Call localVarCall = getActivityStatisticsByProcessDefinitionKeyValidateBeforeCall(key, failedJobs, incidents, incidentsForType, null);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Activity Instance Statistics (asynchronously)
     * Retrieves runtime statistics of the latest version of the given process definition which belongs to no tenant, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityStatisticsByProcessDefinitionKeyAsync(String key, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback<List<ActivityStatisticsResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getActivityStatisticsByProcessDefinitionKeyValidateBeforeCall(key, failedJobs, incidents, incidentsForType, _callback);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getActivityStatisticsByProcessDefinitionKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityStatisticsByProcessDefinitionKeyAndTenantIdCall(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/statistics"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (failedJobs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }

        if (incidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidents", incidents));
        }

        if (incidentsForType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getActivityStatisticsByProcessDefinitionKeyAndTenantIdValidateBeforeCall(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getActivityStatisticsByProcessDefinitionKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getActivityStatisticsByProcessDefinitionKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getActivityStatisticsByProcessDefinitionKeyAndTenantIdCall(key, tenantId, failedJobs, incidents, incidentsForType, _callback);
        return localVarCall;

    }

    /**
     * Get Activity Instance Statistics
     * Retrieves runtime statistics of the latest version of the given process definition for a tenant, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @return List&lt;ActivityStatisticsResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKeyAndTenantId(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        ApiResponse<List<ActivityStatisticsResultDto>> localVarResp = getActivityStatisticsByProcessDefinitionKeyAndTenantIdWithHttpInfo(key, tenantId, failedJobs, incidents, incidentsForType);
        return localVarResp.getData();
    }

    /**
     * Get Activity Instance Statistics
     * Retrieves runtime statistics of the latest version of the given process definition for a tenant, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @return ApiResponse&lt;List&lt;ActivityStatisticsResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ActivityStatisticsResultDto>> getActivityStatisticsByProcessDefinitionKeyAndTenantIdWithHttpInfo(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        okhttp3.Call localVarCall = getActivityStatisticsByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, failedJobs, incidents, incidentsForType, null);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Activity Instance Statistics (asynchronously)
     * Retrieves runtime statistics of the latest version of the given process definition for a tenant, grouped by activities. These statistics include the number of running activity instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityStatisticsByProcessDefinitionKeyAndTenantIdAsync(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType, final ApiCallback<List<ActivityStatisticsResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getActivityStatisticsByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, failedJobs, incidents, incidentsForType, _callback);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDeployedStartForm
     * @param id The id of the process definition to get the deployed start form for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDeployedStartFormCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/deployed-start-form"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/xhtml+xml", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDeployedStartFormValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDeployedStartForm(Async)");
        }
        

        okhttp3.Call localVarCall = getDeployedStartFormCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Deployed Start Form
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param id The id of the process definition to get the deployed start form for. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDeployedStartForm(String id) throws ApiException {
        ApiResponse<File> localVarResp = getDeployedStartFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Deployed Start Form
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param id The id of the process definition to get the deployed start form for. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDeployedStartFormWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getDeployedStartFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Deployed Start Form (asynchronously)
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param id The id of the process definition to get the deployed start form for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDeployedStartFormAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDeployedStartFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDeployedStartFormByKey
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDeployedStartFormByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/deployed-start-form"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/xhtml+xml", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDeployedStartFormByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDeployedStartFormByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getDeployedStartFormByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Deployed Start Form
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDeployedStartFormByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = getDeployedStartFormByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Deployed Start Form
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDeployedStartFormByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getDeployedStartFormByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Deployed Start Form (asynchronously)
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDeployedStartFormByKeyAsync(String key, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDeployedStartFormByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDeployedStartFormByKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDeployedStartFormByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/deployed-start-form"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/xhtml+xml", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDeployedStartFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDeployedStartFormByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDeployedStartFormByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getDeployedStartFormByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Deployed Start Form
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDeployedStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = getDeployedStartFormByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Deployed Start Form
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDeployedStartFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getDeployedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Deployed Start Form (asynchronously)
     * Retrieves the deployed form that can be referenced from a start event. For further information please refer to [User Guide](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#embedded-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definitions belong to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The form key has wrong format.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The deployed start form cannot be retrieved due to missing permissions on process definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No deployed start form for a given process definition exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDeployedStartFormByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDeployedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getLatestProcessDefinitionByTenantId
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestProcessDefinitionByTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLatestProcessDefinitionByTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getLatestProcessDefinitionByTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getLatestProcessDefinitionByTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getLatestProcessDefinitionByTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get
     * Retrieves the latest version of the process definition for tenant according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return ProcessDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessDefinitionDto getLatestProcessDefinitionByTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<ProcessDefinitionDto> localVarResp = getLatestProcessDefinitionByTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get
     * Retrieves the latest version of the process definition for tenant according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return ApiResponse&lt;ProcessDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessDefinitionDto> getLatestProcessDefinitionByTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getLatestProcessDefinitionByTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get (asynchronously)
     * Retrieves the latest version of the process definition for tenant according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestProcessDefinitionByTenantIdAsync(String key, String tenantId, final ApiCallback<ProcessDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getLatestProcessDefinitionByTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinition
     * @param id The id of the process definition to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;id&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get
     * Retrieves a process definition according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param id The id of the process definition to be retrieved. (required)
     * @return ProcessDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;id&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessDefinitionDto getProcessDefinition(String id) throws ApiException {
        ApiResponse<ProcessDefinitionDto> localVarResp = getProcessDefinitionWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get
     * Retrieves a process definition according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param id The id of the process definition to be retrieved. (required)
     * @return ApiResponse&lt;ProcessDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;id&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessDefinitionDto> getProcessDefinitionWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get (asynchronously)
     * Retrieves a process definition according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param id The id of the process definition to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;id&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionAsync(String id, final ApiCallback<ProcessDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionBpmn20Xml
     * @param id The id of the process definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionBpmn20XmlCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/xml"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionBpmn20XmlValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessDefinitionBpmn20Xml(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get XML
     * Retrieves the BPMN 2.0 XML of a process definition.
     * @param id The id of the process definition. (required)
     * @return ProcessDefinitionDiagramDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml(String id) throws ApiException {
        ApiResponse<ProcessDefinitionDiagramDto> localVarResp = getProcessDefinitionBpmn20XmlWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get XML
     * Retrieves the BPMN 2.0 XML of a process definition.
     * @param id The id of the process definition. (required)
     * @return ApiResponse&lt;ProcessDefinitionDiagramDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessDefinitionDiagramDto> getProcessDefinitionBpmn20XmlWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get XML (asynchronously)
     * Retrieves the BPMN 2.0 XML of a process definition.
     * @param id The id of the process definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionBpmn20XmlAsync(String id, final ApiCallback<ProcessDefinitionDiagramDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionBpmn20XmlByKey
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionBpmn20XmlByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/xml"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionBpmn20XmlByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionBpmn20XmlByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get XML
     * Retrieves latest version the BPMN 2.0 XML of a process definition.
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @return ProcessDefinitionDiagramDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKey(String key) throws ApiException {
        ApiResponse<ProcessDefinitionDiagramDto> localVarResp = getProcessDefinitionBpmn20XmlByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get XML
     * Retrieves latest version the BPMN 2.0 XML of a process definition.
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @return ApiResponse&lt;ProcessDefinitionDiagramDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessDefinitionDiagramDto> getProcessDefinitionBpmn20XmlByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get XML (asynchronously)
     * Retrieves latest version the BPMN 2.0 XML of a process definition.
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionBpmn20XmlByKeyAsync(String key, final ApiCallback<ProcessDefinitionDiagramDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionBpmn20XmlByKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionBpmn20XmlByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/xml"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionBpmn20XmlByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionBpmn20XmlByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getProcessDefinitionBpmn20XmlByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get XML
     * Retrieves latest version the BPMN 2.0 XML of a process definition. Returns the XML for the latest version of the process definition for tenant.
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return ProcessDefinitionDiagramDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<ProcessDefinitionDiagramDto> localVarResp = getProcessDefinitionBpmn20XmlByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get XML
     * Retrieves latest version the BPMN 2.0 XML of a process definition. Returns the XML for the latest version of the process definition for tenant.
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return ApiResponse&lt;ProcessDefinitionDiagramDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessDefinitionDiagramDto> getProcessDefinitionBpmn20XmlByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get XML (asynchronously)
     * Retrieves latest version the BPMN 2.0 XML of a process definition. Returns the XML for the latest version of the process definition for tenant.
     * @param key The key of the process definition (the latest version thereof) whose XML should be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The Process Definition xml cannot be retrieved due to missing permissions on the Process Definition resource. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionBpmn20XmlByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<ProcessDefinitionDiagramDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionBpmn20XmlByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionByKey
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get
     * Retrieves the latest version of the process definition which belongs to no tenant according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @return ProcessDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessDefinitionDto getProcessDefinitionByKey(String key) throws ApiException {
        ApiResponse<ProcessDefinitionDto> localVarResp = getProcessDefinitionByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get
     * Retrieves the latest version of the process definition which belongs to no tenant according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;ProcessDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessDefinitionDto> getProcessDefinitionByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get (asynchronously)
     * Retrieves the latest version of the process definition which belongs to no tenant according to the &#x60;ProcessDefinition&#x60; interface in the engine.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition with given &#x60;key&#x60; does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionByKeyAsync(String key, final ApiCallback<ProcessDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionDiagram
     * @param id The id of the process definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionDiagramCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/diagram"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionDiagramValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessDefinitionDiagram(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionDiagramCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Diagram
     * Retrieves the diagram of a process definition.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param id The id of the process definition. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getProcessDefinitionDiagram(String id) throws ApiException {
        ApiResponse<File> localVarResp = getProcessDefinitionDiagramWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Diagram
     * Retrieves the diagram of a process definition.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param id The id of the process definition. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getProcessDefinitionDiagramWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionDiagramValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Diagram (asynchronously)
     * Retrieves the diagram of a process definition.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param id The id of the process definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionDiagramAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionDiagramValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionDiagramByKey
     * @param key The key of the process definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionDiagramByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/diagram"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionDiagramByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionDiagramByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionDiagramByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Diagram
     * Retrieves the diagram for the latest version of the process definition which belongs to no tenant.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param key The key of the process definition. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getProcessDefinitionDiagramByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = getProcessDefinitionDiagramByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Diagram
     * Retrieves the diagram for the latest version of the process definition which belongs to no tenant.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param key The key of the process definition. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getProcessDefinitionDiagramByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionDiagramByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Diagram (asynchronously)
     * Retrieves the diagram for the latest version of the process definition which belongs to no tenant.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param key The key of the process definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionDiagramByKeyAsync(String key, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionDiagramByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionDiagramByKeyAndTenantId
     * @param key The key of the process definition. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionDiagramByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/diagram"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionDiagramByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getProcessDefinitionDiagramByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessDefinitionDiagramByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Diagram
     * Retrieves the diagram for the latest version of the process definition for tenant.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param key The key of the process definition. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getProcessDefinitionDiagramByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = getProcessDefinitionDiagramByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Diagram
     * Retrieves the diagram for the latest version of the process definition for tenant.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param key The key of the process definition. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getProcessDefinitionDiagramByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Diagram (asynchronously)
     * Retrieves the diagram for the latest version of the process definition for tenant.  If the process definition&#39;s deployment contains an image resource with the same file name as the process definition, the deployed image will be returned by the Get Diagram endpoint. Example: &#x60;someProcess.bpmn&#x60; and &#x60;someProcess.png&#x60;. Supported file extentions for the image are: &#x60;svg&#x60;, &#x60;png&#x60;, &#x60;jpg&#x60;, and &#x60;gif&#x60;.
     * @param key The key of the process definition. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The process definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionDiagramByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionStatistics
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param rootIncidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of root incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60; or &#x60;incidents&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionStatisticsCall(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/statistics";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (failedJobs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }

        if (incidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidents", incidents));
        }

        if (incidentsForType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }

        if (rootIncidents != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootIncidents", rootIncidents));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionStatisticsValidateBeforeCall(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getProcessDefinitionStatisticsCall(failedJobs, incidents, incidentsForType, rootIncidents, _callback);
        return localVarCall;

    }

    /**
     * Get Process Instance Statistics
     * Retrieves runtime statistics of the process engine, grouped by process definitions. These statistics include the number of running process instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param rootIncidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of root incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60; or &#x60;incidents&#x60;. (optional)
     * @return List&lt;ProcessDefinitionStatisticsResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<ProcessDefinitionStatisticsResultDto> getProcessDefinitionStatistics(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents) throws ApiException {
        ApiResponse<List<ProcessDefinitionStatisticsResultDto>> localVarResp = getProcessDefinitionStatisticsWithHttpInfo(failedJobs, incidents, incidentsForType, rootIncidents);
        return localVarResp.getData();
    }

    /**
     * Get Process Instance Statistics
     * Retrieves runtime statistics of the process engine, grouped by process definitions. These statistics include the number of running process instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param rootIncidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of root incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60; or &#x60;incidents&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;ProcessDefinitionStatisticsResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ProcessDefinitionStatisticsResultDto>> getProcessDefinitionStatisticsWithHttpInfo(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionStatisticsValidateBeforeCall(failedJobs, incidents, incidentsForType, rootIncidents, null);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionStatisticsResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Process Instance Statistics (asynchronously)
     * Retrieves runtime statistics of the process engine, grouped by process definitions. These statistics include the number of running process instances, optionally the number of failed jobs and also optionally the number of incidents either grouped by incident types or for a specific incident type. **Note**: This does not include historic data.
     * @param failedJobs Whether to include the number of failed jobs in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. (optional)
     * @param incidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60;. (optional)
     * @param incidentsForType If this property has been set with any incident type (i.e., a string value) the result will only include the number of incidents for the assigned incident type. Cannot be used in combination with &#x60;incidents&#x60;. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param rootIncidents Valid values for this property are &#x60;true&#x60; or &#x60;false&#x60;. If this property has been set to &#x60;true&#x60; the result will include the corresponding number of root incidents for each occurred incident type. If it is set to &#x60;false&#x60;, the incidents will not be included in the result. Cannot be used in combination with &#x60;incidentsForType&#x60; or &#x60;incidents&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionStatisticsAsync(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents, final ApiCallback<List<ProcessDefinitionStatisticsResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionStatisticsValidateBeforeCall(failedJobs, incidents, incidentsForType, rootIncidents, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionStatisticsResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitions
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionsCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (deployedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }

        if (deployedAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (keysIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keysIn", keysIn));
        }

        if (keyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keyLike", keyLike));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (latestVersion != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }

        if (resourceName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceName", resourceName));
        }

        if (resourceNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }

        if (startableBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startableBy", startableBy));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeProcessDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeProcessDefinitionsWithoutTenantId", includeProcessDefinitionsWithoutTenantId));
        }

        if (versionTag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTag", versionTag));
        }

        if (versionTagLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }

        if (withoutVersionTag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutVersionTag", withoutVersionTag));
        }

        if (startableInTasklist != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startableInTasklist", startableInTasklist));
        }

        if (notStartableInTasklist != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("notStartableInTasklist", notStartableInTasklist));
        }

        if (startablePermissionCheck != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startablePermissionCheck", startablePermissionCheck));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionsValidateBeforeCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getProcessDefinitionsCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get List
     * Queries for process definitions that fulfill given parameters. Parameters may be the properties of  process definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Definition Count](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/get-query-count/) method.
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;ProcessDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<ProcessDefinitionDto> getProcessDefinitions(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<ProcessDefinitionDto>> localVarResp = getProcessDefinitionsWithHttpInfo(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get List
     * Queries for process definitions that fulfill given parameters. Parameters may be the properties of  process definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Definition Count](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/get-query-count/) method.
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;ProcessDefinitionDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ProcessDefinitionDto>> getProcessDefinitionsWithHttpInfo(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionsValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (asynchronously)
     * Queries for process definitions that fulfill given parameters. Parameters may be the properties of  process definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Definition Count](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/get-query-count/) method.
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionsAsync(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<ProcessDefinitionDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionsValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessDefinitionsCount
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionsCountCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (deployedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }

        if (deployedAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (keysIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keysIn", keysIn));
        }

        if (keyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keyLike", keyLike));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (latestVersion != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }

        if (resourceName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceName", resourceName));
        }

        if (resourceNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }

        if (startableBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startableBy", startableBy));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeProcessDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeProcessDefinitionsWithoutTenantId", includeProcessDefinitionsWithoutTenantId));
        }

        if (versionTag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTag", versionTag));
        }

        if (versionTagLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }

        if (withoutVersionTag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutVersionTag", withoutVersionTag));
        }

        if (startableInTasklist != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startableInTasklist", startableInTasklist));
        }

        if (notStartableInTasklist != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("notStartableInTasklist", notStartableInTasklist));
        }

        if (startablePermissionCheck != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startablePermissionCheck", startablePermissionCheck));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessDefinitionsCountValidateBeforeCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getProcessDefinitionsCountCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, _callback);
        return localVarCall;

    }

    /**
     * Get List Count
     * Requests the number of process definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Definitions](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/get-query/) method.
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getProcessDefinitionsCount(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getProcessDefinitionsCountWithHttpInfo(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck);
        return localVarResp.getData();
    }

    /**
     * Get List Count
     * Requests the number of process definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Definitions](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/get-query/) method.
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getProcessDefinitionsCountWithHttpInfo(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck) throws ApiException {
        okhttp3.Call localVarCall = getProcessDefinitionsCountValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (asynchronously)
     * Requests the number of process definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Definitions](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/get-query/) method.
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionIdIn Filter by a comma-separated list of process definition ids. (optional)
     * @param name Filter by process definition name. (optional)
     * @param nameLike Filter by process definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed after (exclusive) a specific time. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the process definition belongs to. Only selects process definitions that have been deployed at a specific time (exact match). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;. (optional)
     * @param key Filter by process definition key, i.e., the id in the BPMN 2.0 XML. Exact match. (optional)
     * @param keysIn Filter by a comma-separated list of process definition keys. (optional)
     * @param keyLike Filter by process definition keys that the parameter is a substring of. (optional)
     * @param category Filter by process definition category. Exact match. (optional)
     * @param categoryLike Filter by process definition categories that the parameter is a substring of. (optional)
     * @param version Filter by process definition version. (optional)
     * @param latestVersion Only include those process definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the process definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those process definition resources that the parameter is a substring of. (optional)
     * @param startableBy Filter by a user name who is allowed to start the process. (optional)
     * @param active Only include active process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended process definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be true, as false is the default behavior. (optional)
     * @param includeProcessDefinitionsWithoutTenantId Include process definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tag that the parameter is a substring of. (optional)
     * @param withoutVersionTag Only include process definitions without a &#x60;versionTag&#x60;. (optional)
     * @param startableInTasklist Filter by process definitions which are startable in Tasklist.. (optional)
     * @param notStartableInTasklist Filter by process definitions which are not startable in Tasklist. (optional)
     * @param startablePermissionCheck Filter by process definitions which the user is allowed to start in Tasklist. If the user doesn&#39;t have these permissions the result will be empty list. The permissions are: * &#x60;CREATE&#x60; permission for all Process instances * &#x60;CREATE_INSTANCE&#x60; and &#x60;READ&#x60; permission on Process definition level (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessDefinitionsCountAsync(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessDefinitionsCountValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRenderedStartForm
     * @param id The id of the process definition to get the rendered start form for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRenderedStartFormCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/rendered-form"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/xhtml+xml", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRenderedStartFormValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getRenderedStartForm(Async)");
        }
        

        okhttp3.Call localVarCall = getRenderedStartFormCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Rendered Start Form
     * Retrieves the rendered form for a process definition. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param id The id of the process definition to get the rendered start form for. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getRenderedStartForm(String id) throws ApiException {
        ApiResponse<File> localVarResp = getRenderedStartFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Rendered Start Form
     * Retrieves the rendered form for a process definition. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param id The id of the process definition to get the rendered start form for. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getRenderedStartFormWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getRenderedStartFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Rendered Start Form (asynchronously)
     * Retrieves the rendered form for a process definition. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param id The id of the process definition to get the rendered start form for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRenderedStartFormAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRenderedStartFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRenderedStartFormByKey
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRenderedStartFormByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/rendered-form"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/xhtml+xml", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRenderedStartFormByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getRenderedStartFormByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getRenderedStartFormByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Rendered Start Form
     * Retrieves  the rendered form for the latest version of the process definition which belongs to no tenant. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getRenderedStartFormByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = getRenderedStartFormByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Rendered Start Form
     * Retrieves  the rendered form for the latest version of the process definition which belongs to no tenant. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getRenderedStartFormByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getRenderedStartFormByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Rendered Start Form (asynchronously)
     * Retrieves  the rendered form for the latest version of the process definition which belongs to no tenant. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRenderedStartFormByKeyAsync(String key, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRenderedStartFormByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRenderedStartFormByKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRenderedStartFormByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/rendered-form"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/xhtml+xml", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRenderedStartFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getRenderedStartFormByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getRenderedStartFormByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getRenderedStartFormByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Rendered Start Form
     * Retrieves  the rendered form for the latest version of the process definition for a tenant. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getRenderedStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = getRenderedStartFormByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Rendered Start Form
     * Retrieves  the rendered form for the latest version of the process definition for a tenant. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getRenderedStartFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getRenderedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Rendered Start Form (asynchronously)
     * Retrieves  the rendered form for the latest version of the process definition for a tenant. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no form field metadata defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRenderedStartFormByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRenderedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStartForm
     * @param id The id of the process definition to get the start form key for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/startForm"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStartFormValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStartForm(Async)");
        }
        

        okhttp3.Call localVarCall = getStartFormCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Start Form Key
     * Retrieves the key of the start form for a process definition. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param id The id of the process definition to get the start form key for. (required)
     * @return FormDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public FormDto getStartForm(String id) throws ApiException {
        ApiResponse<FormDto> localVarResp = getStartFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Start Form Key
     * Retrieves the key of the start form for a process definition. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param id The id of the process definition to get the start form key for. (required)
     * @return ApiResponse&lt;FormDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FormDto> getStartFormWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getStartFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Start Form Key (asynchronously)
     * Retrieves the key of the start form for a process definition. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param id The id of the process definition to get the start form key for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormAsync(String id, final ApiCallback<FormDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStartFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStartFormByKey
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/startForm"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStartFormByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getStartFormByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Start Form Key
     * Retrieves the key of the start form for the latest version of the process definition which belongs to no tenant. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @return FormDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public FormDto getStartFormByKey(String key) throws ApiException {
        ApiResponse<FormDto> localVarResp = getStartFormByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Start Form Key
     * Retrieves the key of the start form for the latest version of the process definition which belongs to no tenant. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @return ApiResponse&lt;FormDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FormDto> getStartFormByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getStartFormByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Start Form Key (asynchronously)
     * Retrieves the key of the start form for the latest version of the process definition which belongs to no tenant. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormByKeyAsync(String key, final ApiCallback<FormDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStartFormByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStartFormByKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/startForm"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStartFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getStartFormByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getStartFormByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Start Form Key
     * Retrieves the key of the start form for the latest version of the process definition for a tenant. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return FormDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public FormDto getStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<FormDto> localVarResp = getStartFormByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Start Form Key
     * Retrieves the key of the start form for the latest version of the process definition for a tenant. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @return ApiResponse&lt;FormDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FormDto> getStartFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Start Form Key (asynchronously)
     * Retrieves the key of the start form for the latest version of the process definition for a tenant. The form key corresponds to the &#x60;FormData#formKey&#x60; property in the engine.
     * @param key The key of the process definition (the latest version thereof) for which the form key is to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Process definition has no start form defined. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<FormDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStartFormVariables
     * @param id The id of the process definition to retrieve the variables for. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The id is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormVariablesCall(String id, String variableNames, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/form-variables"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (variableNames != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNames", variableNames));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStartFormVariablesValidateBeforeCall(String id, String variableNames, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStartFormVariables(Async)");
        }
        

        okhttp3.Call localVarCall = getStartFormVariablesCall(id, variableNames, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Start Form Variables
     * Retrieves the start form variables for a process definition (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param id The id of the process definition to retrieve the variables for. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return Map&lt;String, VariableValueDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The id is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, VariableValueDto> getStartFormVariables(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = getStartFormVariablesWithHttpInfo(id, variableNames, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Start Form Variables
     * Retrieves the start form variables for a process definition (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param id The id of the process definition to retrieve the variables for. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return ApiResponse&lt;Map&lt;String, VariableValueDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The id is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, VariableValueDto>> getStartFormVariablesWithHttpInfo(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getStartFormVariablesValidateBeforeCall(id, variableNames, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Start Form Variables (asynchronously)
     * Retrieves the start form variables for a process definition (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param id The id of the process definition to retrieve the variables for. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The id is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormVariablesAsync(String id, String variableNames, Boolean deserializeValues, final ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStartFormVariablesValidateBeforeCall(id, variableNames, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStartFormVariablesByKey
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormVariablesByKeyCall(String key, String variableNames, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/form-variables"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (variableNames != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNames", variableNames));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStartFormVariablesByKeyValidateBeforeCall(String key, String variableNames, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormVariablesByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getStartFormVariablesByKeyCall(key, variableNames, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Start Form Variables
     * Retrieves the start form variables for the latest process definition which belongs to no tenant (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return Map&lt;String, VariableValueDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, VariableValueDto> getStartFormVariablesByKey(String key, String variableNames, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = getStartFormVariablesByKeyWithHttpInfo(key, variableNames, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Start Form Variables
     * Retrieves the start form variables for the latest process definition which belongs to no tenant (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return ApiResponse&lt;Map&lt;String, VariableValueDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, VariableValueDto>> getStartFormVariablesByKeyWithHttpInfo(String key, String variableNames, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getStartFormVariablesByKeyValidateBeforeCall(key, variableNames, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Start Form Variables (asynchronously)
     * Retrieves the start form variables for the latest process definition which belongs to no tenant (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormVariablesByKeyAsync(String key, String variableNames, Boolean deserializeValues, final ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStartFormVariablesByKeyValidateBeforeCall(key, variableNames, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStartFormVariablesByKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormVariablesByKeyAndTenantIdCall(String key, String tenantId, String variableNames, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/form-variables"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (variableNames != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNames", variableNames));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStartFormVariablesByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, String variableNames, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormVariablesByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getStartFormVariablesByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getStartFormVariablesByKeyAndTenantIdCall(key, tenantId, variableNames, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Start Form Variables
     * Retrieves the start form variables for the latest process definition for a tenant (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return Map&lt;String, VariableValueDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, VariableValueDto> getStartFormVariablesByKeyAndTenantId(String key, String tenantId, String variableNames, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = getStartFormVariablesByKeyAndTenantIdWithHttpInfo(key, tenantId, variableNames, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Start Form Variables
     * Retrieves the start form variables for the latest process definition for a tenant (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return ApiResponse&lt;Map&lt;String, VariableValueDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, VariableValueDto>> getStartFormVariablesByKeyAndTenantIdWithHttpInfo(String key, String tenantId, String variableNames, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getStartFormVariablesByKeyAndTenantIdValidateBeforeCall(key, tenantId, variableNames, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Start Form Variables (asynchronously)
     * Retrieves the start form variables for the latest process definition for a tenant (only if they are defined via the  [Generated Task Form](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms) approach). The start form variables take form data specified on the start event into account. If form fields are defined, the variable types and default values of the form fields are taken into account.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param variableNames A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note**: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object containing a property for each variable returned. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The key is null or does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStartFormVariablesByKeyAndTenantIdAsync(String key, String tenantId, String variableNames, Boolean deserializeValues, final ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStartFormVariablesByKeyAndTenantIdValidateBeforeCall(key, tenantId, variableNames, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStaticCalledProcessDefinitions
     * @param id The id of the process definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStaticCalledProcessDefinitionsCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/static-called-process-definitions"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStaticCalledProcessDefinitionsValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStaticCalledProcessDefinitions(Async)");
        }
        

        okhttp3.Call localVarCall = getStaticCalledProcessDefinitionsCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Static Called Process Definitions
     * For the given process, returns a list of called process definitions corresponding to the &#x60;CalledProcessDefinition&#x60; interface in the engine. The list contains all process definitions that are referenced statically by call activities in the given process. This endpoint does not resolve process definitions that are referenced with expressions. Each called process definition contains a list of call activity ids, which specifies the call activities that are calling that process. This endpoint does not resolve references to case definitions.
     * @param id The id of the process definition. (required)
     * @return List&lt;CalledProcessDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<CalledProcessDefinitionDto> getStaticCalledProcessDefinitions(String id) throws ApiException {
        ApiResponse<List<CalledProcessDefinitionDto>> localVarResp = getStaticCalledProcessDefinitionsWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Static Called Process Definitions
     * For the given process, returns a list of called process definitions corresponding to the &#x60;CalledProcessDefinition&#x60; interface in the engine. The list contains all process definitions that are referenced statically by call activities in the given process. This endpoint does not resolve process definitions that are referenced with expressions. Each called process definition contains a list of call activity ids, which specifies the call activities that are calling that process. This endpoint does not resolve references to case definitions.
     * @param id The id of the process definition. (required)
     * @return ApiResponse&lt;List&lt;CalledProcessDefinitionDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CalledProcessDefinitionDto>> getStaticCalledProcessDefinitionsWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getStaticCalledProcessDefinitionsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<List<CalledProcessDefinitionDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Static Called Process Definitions (asynchronously)
     * For the given process, returns a list of called process definitions corresponding to the &#x60;CalledProcessDefinition&#x60; interface in the engine. The list contains all process definitions that are referenced statically by call activities in the given process. This endpoint does not resolve process definitions that are referenced with expressions. Each called process definition contains a list of call activity ids, which specifies the call activities that are calling that process. This endpoint does not resolve references to case definitions.
     * @param id The id of the process definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStaticCalledProcessDefinitionsAsync(String id, final ApiCallback<List<CalledProcessDefinitionDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStaticCalledProcessDefinitionsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<List<CalledProcessDefinitionDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for restartProcessInstance
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call restartProcessInstanceCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = restartProcessInstanceDto;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/restart"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call restartProcessInstanceValidateBeforeCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling restartProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = restartProcessInstanceCall(id, restartProcessInstanceDto, _callback);
        return localVarCall;

    }

    /**
     * Restart Process Instance
     * Restarts process instances that were canceled or terminated synchronously. Can also restart completed process instances. It will create a new instance using the original instance information. To execute the restart asynchronously, use the [Restart Process Instance Async](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/post-restart-process-instance-async/) method.  For more information about the difference between synchronous and asynchronous execution, please refer to the related section of the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-instance-restart/#execution).
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void restartProcessInstance(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        restartProcessInstanceWithHttpInfo(id, restartProcessInstanceDto);
    }

    /**
     * Restart Process Instance
     * Restarts process instances that were canceled or terminated synchronously. Can also restart completed process instances. It will create a new instance using the original instance information. To execute the restart asynchronously, use the [Restart Process Instance Async](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/post-restart-process-instance-async/) method.  For more information about the difference between synchronous and asynchronous execution, please refer to the related section of the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-instance-restart/#execution).
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> restartProcessInstanceWithHttpInfo(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        okhttp3.Call localVarCall = restartProcessInstanceValidateBeforeCall(id, restartProcessInstanceDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Restart Process Instance (asynchronously)
     * Restarts process instances that were canceled or terminated synchronously. Can also restart completed process instances. It will create a new instance using the original instance information. To execute the restart asynchronously, use the [Restart Process Instance Async](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/post-restart-process-instance-async/) method.  For more information about the difference between synchronous and asynchronous execution, please refer to the related section of the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-instance-restart/#execution).
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call restartProcessInstanceAsync(String id, RestartProcessInstanceDto restartProcessInstanceDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = restartProcessInstanceValidateBeforeCall(id, restartProcessInstanceDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for restartProcessInstanceAsyncOperation
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call restartProcessInstanceAsyncOperationCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = restartProcessInstanceDto;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/restart-async"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call restartProcessInstanceAsyncOperationValidateBeforeCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling restartProcessInstanceAsyncOperation(Async)");
        }
        

        okhttp3.Call localVarCall = restartProcessInstanceAsyncOperationCall(id, restartProcessInstanceDto, _callback);
        return localVarCall;

    }

    /**
     * Restart Process Instance Async
     * Restarts process instances that were canceled or terminated asynchronously. Can also restart completed process instances. It will create a new instance using the original instance information. To execute the restart asynchronously, use the [Restart Process Instance](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/post-restart-process-instance-sync/) method.  For more information about the difference between synchronous and asynchronous execution, please refer to the related section of the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-instance-restart/#execution).
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto restartProcessInstanceAsyncOperation(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = restartProcessInstanceAsyncOperationWithHttpInfo(id, restartProcessInstanceDto);
        return localVarResp.getData();
    }

    /**
     * Restart Process Instance Async
     * Restarts process instances that were canceled or terminated asynchronously. Can also restart completed process instances. It will create a new instance using the original instance information. To execute the restart asynchronously, use the [Restart Process Instance](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/post-restart-process-instance-sync/) method.  For more information about the difference between synchronous and asynchronous execution, please refer to the related section of the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-instance-restart/#execution).
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> restartProcessInstanceAsyncOperationWithHttpInfo(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        okhttp3.Call localVarCall = restartProcessInstanceAsyncOperationValidateBeforeCall(id, restartProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Restart Process Instance Async (asynchronously)
     * Restarts process instances that were canceled or terminated asynchronously. Can also restart completed process instances. It will create a new instance using the original instance information. To execute the restart asynchronously, use the [Restart Process Instance](https://docs.camunda.org/manual/7.17/reference/rest/process-definition/post-restart-process-instance-sync/) method.  For more information about the difference between synchronous and asynchronous execution, please refer to the related section of the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-instance-restart/#execution).
     * @param id The id of the process definition of the process instances to restart. (required)
     * @param restartProcessInstanceDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case following parameters are missing: &#x60;instructions&#x60;, &#x60;activityId&#x60; or &#x60;transitionId&#x60;, &#x60;processInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60;, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call restartProcessInstanceAsyncOperationAsync(String id, RestartProcessInstanceDto restartProcessInstanceDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = restartProcessInstanceAsyncOperationValidateBeforeCall(id, restartProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for startProcessInstance
     * @param id The id of the process definition to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startProcessInstanceCall(String id, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = startProcessInstanceDto;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/start"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call startProcessInstanceValidateBeforeCall(String id, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling startProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = startProcessInstanceCall(id, startProcessInstanceDto, _callback);
        return localVarCall;

    }

    /**
     * Start Instance
     * Instantiates a given process definition. Process variables and business key may be supplied in the request body.
     * @param id The id of the process definition to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @return ProcessInstanceWithVariablesDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessInstanceWithVariablesDto startProcessInstance(String id, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        ApiResponse<ProcessInstanceWithVariablesDto> localVarResp = startProcessInstanceWithHttpInfo(id, startProcessInstanceDto);
        return localVarResp.getData();
    }

    /**
     * Start Instance
     * Instantiates a given process definition. Process variables and business key may be supplied in the request body.
     * @param id The id of the process definition to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @return ApiResponse&lt;ProcessInstanceWithVariablesDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessInstanceWithVariablesDto> startProcessInstanceWithHttpInfo(String id, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        okhttp3.Call localVarCall = startProcessInstanceValidateBeforeCall(id, startProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Start Instance (asynchronously)
     * Instantiates a given process definition. Process variables and business key may be supplied in the request body.
     * @param id The id of the process definition to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startProcessInstanceAsync(String id, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback<ProcessInstanceWithVariablesDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = startProcessInstanceValidateBeforeCall(id, startProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for startProcessInstanceByKey
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startProcessInstanceByKeyCall(String key, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = startProcessInstanceDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/start"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call startProcessInstanceByKeyValidateBeforeCall(String key, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling startProcessInstanceByKey(Async)");
        }
        

        okhttp3.Call localVarCall = startProcessInstanceByKeyCall(key, startProcessInstanceDto, _callback);
        return localVarCall;

    }

    /**
     * Start Instance
     * Instantiates a given process definition, starts the latest version of the process definition which belongs to no tenant. Process variables and business key may be supplied in the request body.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @return ProcessInstanceWithVariablesDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessInstanceWithVariablesDto startProcessInstanceByKey(String key, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        ApiResponse<ProcessInstanceWithVariablesDto> localVarResp = startProcessInstanceByKeyWithHttpInfo(key, startProcessInstanceDto);
        return localVarResp.getData();
    }

    /**
     * Start Instance
     * Instantiates a given process definition, starts the latest version of the process definition which belongs to no tenant. Process variables and business key may be supplied in the request body.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @return ApiResponse&lt;ProcessInstanceWithVariablesDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessInstanceWithVariablesDto> startProcessInstanceByKeyWithHttpInfo(String key, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        okhttp3.Call localVarCall = startProcessInstanceByKeyValidateBeforeCall(key, startProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Start Instance (asynchronously)
     * Instantiates a given process definition, starts the latest version of the process definition which belongs to no tenant. Process variables and business key may be supplied in the request body.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param startProcessInstanceDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startProcessInstanceByKeyAsync(String key, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback<ProcessInstanceWithVariablesDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = startProcessInstanceByKeyValidateBeforeCall(key, startProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for startProcessInstanceByKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startProcessInstanceByKeyAndTenantIdCall(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = startProcessInstanceDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/start"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call startProcessInstanceByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling startProcessInstanceByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling startProcessInstanceByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = startProcessInstanceByKeyAndTenantIdCall(key, tenantId, startProcessInstanceDto, _callback);
        return localVarCall;

    }

    /**
     * Start Instance
     * Instantiates a given process definition, starts the latest version of the process definition for tenant. Process variables and business key may be supplied in the request body.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceDto  (optional)
     * @return ProcessInstanceWithVariablesDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessInstanceWithVariablesDto startProcessInstanceByKeyAndTenantId(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        ApiResponse<ProcessInstanceWithVariablesDto> localVarResp = startProcessInstanceByKeyAndTenantIdWithHttpInfo(key, tenantId, startProcessInstanceDto);
        return localVarResp.getData();
    }

    /**
     * Start Instance
     * Instantiates a given process definition, starts the latest version of the process definition for tenant. Process variables and business key may be supplied in the request body.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceDto  (optional)
     * @return ApiResponse&lt;ProcessInstanceWithVariablesDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessInstanceWithVariablesDto> startProcessInstanceByKeyAndTenantIdWithHttpInfo(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        okhttp3.Call localVarCall = startProcessInstanceByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Start Instance (asynchronously)
     * Instantiates a given process definition, starts the latest version of the process definition for tenant. Process variables and business key may be supplied in the request body.
     * @param key The key of the process definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startProcessInstanceByKeyAndTenantIdAsync(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto, final ApiCallback<ProcessInstanceWithVariablesDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = startProcessInstanceByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitForm
     * @param id The id of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitFormCall(String id, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = startProcessInstanceFormDto;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/submit-form"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitFormValidateBeforeCall(String id, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling submitForm(Async)");
        }
        

        okhttp3.Call localVarCall = submitFormCall(id, startProcessInstanceFormDto, _callback);
        return localVarCall;

    }

    /**
     * Submit Start Form
     * Starts a process instance using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param id The id of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @return ProcessInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessInstanceDto submitForm(String id, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = submitFormWithHttpInfo(id, startProcessInstanceFormDto);
        return localVarResp.getData();
    }

    /**
     * Submit Start Form
     * Starts a process instance using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param id The id of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @return ApiResponse&lt;ProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessInstanceDto> submitFormWithHttpInfo(String id, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        okhttp3.Call localVarCall = submitFormValidateBeforeCall(id, startProcessInstanceFormDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Submit Start Form (asynchronously)
     * Starts a process instance using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param id The id of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitFormAsync(String id, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback<ProcessInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitFormValidateBeforeCall(id, startProcessInstanceFormDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitFormByKey
     * @param key The key of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitFormByKeyCall(String key, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = startProcessInstanceFormDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/submit-form"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitFormByKeyValidateBeforeCall(String key, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling submitFormByKey(Async)");
        }
        

        okhttp3.Call localVarCall = submitFormByKeyCall(key, startProcessInstanceFormDto, _callback);
        return localVarCall;

    }

    /**
     * Submit Start Form
     * Starts the latest version of the process definition which belongs to no tenant using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @return ProcessInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessInstanceDto submitFormByKey(String key, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = submitFormByKeyWithHttpInfo(key, startProcessInstanceFormDto);
        return localVarResp.getData();
    }

    /**
     * Submit Start Form
     * Starts the latest version of the process definition which belongs to no tenant using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @return ApiResponse&lt;ProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessInstanceDto> submitFormByKeyWithHttpInfo(String key, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        okhttp3.Call localVarCall = submitFormByKeyValidateBeforeCall(key, startProcessInstanceFormDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Submit Start Form (asynchronously)
     * Starts the latest version of the process definition which belongs to no tenant using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition to submit the form for. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitFormByKeyAsync(String key, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback<ProcessInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitFormByKeyValidateBeforeCall(key, startProcessInstanceFormDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitFormByKeyAndTenantId
     * @param key The key of the process definition to submit the form for. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitFormByKeyAndTenantIdCall(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = startProcessInstanceFormDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/submit-form"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling submitFormByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling submitFormByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = submitFormByKeyAndTenantIdCall(key, tenantId, startProcessInstanceFormDto, _callback);
        return localVarCall;

    }

    /**
     * Submit Start Form
     * Starts the latest version of the process definition for a tenant using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition to submit the form for. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @return ProcessInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ProcessInstanceDto submitFormByKeyAndTenantId(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = submitFormByKeyAndTenantIdWithHttpInfo(key, tenantId, startProcessInstanceFormDto);
        return localVarResp.getData();
    }

    /**
     * Submit Start Form
     * Starts the latest version of the process definition for a tenant using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition to submit the form for. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @return ApiResponse&lt;ProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessInstanceDto> submitFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        okhttp3.Call localVarCall = submitFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceFormDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Submit Start Form (asynchronously)
     * Starts the latest version of the process definition for a tenant using a set of process variables and the business key. If the start event has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See [Documentation on Generated Task Forms](https://docs.camunda.org/manual/7.17/user-guide/task-forms/#generated-task-forms).
     * @param key The key of the process definition to submit the form for. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param startProcessInstanceFormDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The instance could not be created due to an invalid variable value, for example if the value could not be parsed to an &#x60;Integer&#x60; value or the passed variable type is not supported. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The instance could not be created successfully. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitFormByKeyAndTenantIdAsync(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto, final ApiCallback<ProcessInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceFormDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateHistoryTimeToLiveByProcessDefinitionId
     * @param id The id of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionIdCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historyTimeToLiveDto;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/history-time-to-live"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionIdValidateBeforeCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateHistoryTimeToLiveByProcessDefinitionId(Async)");
        }
        

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionIdCall(id, historyTimeToLiveDto, _callback);
        return localVarCall;

    }

    /**
     * Update History Time to Live
     * Updates history time to live for process definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param id The id of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateHistoryTimeToLiveByProcessDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        updateHistoryTimeToLiveByProcessDefinitionIdWithHttpInfo(id, historyTimeToLiveDto);
    }

    /**
     * Update History Time to Live
     * Updates history time to live for process definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param id The id of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateHistoryTimeToLiveByProcessDefinitionIdWithHttpInfo(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update History Time to Live (asynchronously)
     * Updates history time to live for process definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param id The id of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionIdAsync(String id, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateHistoryTimeToLiveByProcessDefinitionKey
     * @param key The key of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionKeyCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historyTimeToLiveDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/history-time-to-live"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionKeyValidateBeforeCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByProcessDefinitionKey(Async)");
        }
        

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionKeyCall(key, historyTimeToLiveDto, _callback);
        return localVarCall;

    }

    /**
     * Update History Time to Live
     * Updates history time to live for the latest version of the process definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateHistoryTimeToLiveByProcessDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        updateHistoryTimeToLiveByProcessDefinitionKeyWithHttpInfo(key, historyTimeToLiveDto);
    }

    /**
     * Update History Time to Live
     * Updates history time to live for the latest version of the process definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateHistoryTimeToLiveByProcessDefinitionKeyWithHttpInfo(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update History Time to Live (asynchronously)
     * Updates history time to live for the latest version of the process definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the process definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionKeyAsync(String key, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId
     * @param key The key of the process definition to change history time to live. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historyTimeToLiveDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdValidateBeforeCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdCall(key, tenantId, historyTimeToLiveDto, _callback);
        return localVarCall;

    }

    /**
     * Update History Time to Live
     * Updates history time to live for the latest version of the process definition for a tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the process definition to change history time to live. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdWithHttpInfo(key, tenantId, historyTimeToLiveDto);
    }

    /**
     * Update History Time to Live
     * Updates history time to live for the latest version of the process definition for a tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the process definition to change history time to live. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdWithHttpInfo(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, historyTimeToLiveDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update History Time to Live (asynchronously)
     * Updates history time to live for the latest version of the process definition for a tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the process definition to change history time to live. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdAsync(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, historyTimeToLiveDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateProcessDefinitionSuspensionState
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed property is &#x60;processDefinitionId&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateCall(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processDefinitionSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/process-definition/suspended";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateProcessDefinitionSuspensionStateValidateBeforeCall(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateCall(processDefinitionSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend By Key
     * Activates or suspends process definitions with the given process definition key.
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed property is &#x60;processDefinitionId&#x60;. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateProcessDefinitionSuspensionState(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        updateProcessDefinitionSuspensionStateWithHttpInfo(processDefinitionSuspensionStateDto);
    }

    /**
     * Activate/Suspend By Key
     * Activates or suspends process definitions with the given process definition key.
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed property is &#x60;processDefinitionId&#x60;. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateProcessDefinitionSuspensionStateWithHttpInfo(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateValidateBeforeCall(processDefinitionSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend By Key (asynchronously)
     * Activates or suspends process definitions with the given process definition key.
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed property is &#x60;processDefinitionId&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateAsync(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateValidateBeforeCall(processDefinitionSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateProcessDefinitionSuspensionStateById
     * @param id The id of the process definition to activate or suspend. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateByIdCall(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processDefinitionSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/process-definition/{id}/suspended"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateProcessDefinitionSuspensionStateByIdValidateBeforeCall(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateProcessDefinitionSuspensionStateById(Async)");
        }
        

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByIdCall(id, processDefinitionSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend By Id
     * Activates or suspends a given process definition by id.
     * @param id The id of the process definition to activate or suspend. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateProcessDefinitionSuspensionStateById(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        updateProcessDefinitionSuspensionStateByIdWithHttpInfo(id, processDefinitionSuspensionStateDto);
    }

    /**
     * Activate/Suspend By Id
     * Activates or suspends a given process definition by id.
     * @param id The id of the process definition to activate or suspend. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateProcessDefinitionSuspensionStateByIdWithHttpInfo(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByIdValidateBeforeCall(id, processDefinitionSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend By Id (asynchronously)
     * Activates or suspends a given process definition by id.
     * @param id The id of the process definition to activate or suspend. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateByIdAsync(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByIdValidateBeforeCall(id, processDefinitionSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateProcessDefinitionSuspensionStateByKey
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateByKeyCall(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processDefinitionSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/suspended"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateProcessDefinitionSuspensionStateByKeyValidateBeforeCall(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateProcessDefinitionSuspensionStateByKey(Async)");
        }
        

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByKeyCall(key, processDefinitionSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend by Id
     * Activates or suspends a given process definition by latest version of process definition key which belongs to no tenant.
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateProcessDefinitionSuspensionStateByKey(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        updateProcessDefinitionSuspensionStateByKeyWithHttpInfo(key, processDefinitionSuspensionStateDto);
    }

    /**
     * Activate/Suspend by Id
     * Activates or suspends a given process definition by latest version of process definition key which belongs to no tenant.
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateProcessDefinitionSuspensionStateByKeyWithHttpInfo(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByKeyValidateBeforeCall(key, processDefinitionSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend by Id (asynchronously)
     * Activates or suspends a given process definition by latest version of process definition key which belongs to no tenant.
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateByKeyAsync(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByKeyValidateBeforeCall(key, processDefinitionSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateProcessDefinitionSuspensionStateByKeyAndTenantId
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateByKeyAndTenantIdCall(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processDefinitionSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/suspended"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateProcessDefinitionSuspensionStateByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateProcessDefinitionSuspensionStateByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling updateProcessDefinitionSuspensionStateByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByKeyAndTenantIdCall(key, tenantId, processDefinitionSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend by Id
     * Activates or suspends a given process definition by the latest version of the process definition for tenant.
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateProcessDefinitionSuspensionStateByKeyAndTenantId(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        updateProcessDefinitionSuspensionStateByKeyAndTenantIdWithHttpInfo(key, tenantId, processDefinitionSuspensionStateDto);
    }

    /**
     * Activate/Suspend by Id
     * Activates or suspends a given process definition by the latest version of the process definition for tenant.
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateProcessDefinitionSuspensionStateByKeyAndTenantIdWithHttpInfo(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByKeyAndTenantIdValidateBeforeCall(key, tenantId, processDefinitionSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend by Id (asynchronously)
     * Activates or suspends a given process definition by the latest version of the process definition for tenant.
     * @param key The key of the process definition (the latest version thereof) to be activated/suspended. (required)
     * @param tenantId The id of the tenant the process definition belongs to. (required)
     * @param processDefinitionSuspensionStateDto **Note**: Unallowed properties are &#x60;processDefinitionId&#x60; and &#x60;processDefinitionKey&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format or if the &#x60;processDefinitionKey&#x60; parameter is &#x60;null&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProcessDefinitionSuspensionStateByKeyAndTenantIdAsync(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateProcessDefinitionSuspensionStateByKeyAndTenantIdValidateBeforeCall(key, tenantId, processDefinitionSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
