/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CleanableHistoricDecisionInstanceReportResultDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricDecisionDefinitionApi {
    private ApiClient localVarApiClient;

    public HistoricDecisionDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricDecisionDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getCleanableHistoricDecisionInstanceReport
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricDecisionInstanceReportCall(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/decision-definition/cleanable-decision-instance-report";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }

        if (decisionDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionKeyIn", decisionDefinitionKeyIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (compact != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compact", compact));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCleanableHistoricDecisionInstanceReportValidateBeforeCall(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getCleanableHistoricDecisionInstanceReportCall(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Cleanable Decision Instance Report
     * Retrieves a report about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup)),  so that you can tune the history time to live. These reports include the count of the finished historic decision instances, cleanable decision instances and basic decision definition data - id, key, name and version. The size of the result set can be retrieved by using the  [Get Cleanable Decision Instance Report Count](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-definition/get-cleanable-decision-instance-report-count/) method.
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;CleanableHistoricDecisionInstanceReportResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<CleanableHistoricDecisionInstanceReportResultDto> getCleanableHistoricDecisionInstanceReport(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<CleanableHistoricDecisionInstanceReportResultDto>> localVarResp = getCleanableHistoricDecisionInstanceReportWithHttpInfo(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Cleanable Decision Instance Report
     * Retrieves a report about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup)),  so that you can tune the history time to live. These reports include the count of the finished historic decision instances, cleanable decision instances and basic decision definition data - id, key, name and version. The size of the result set can be retrieved by using the  [Get Cleanable Decision Instance Report Count](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-definition/get-cleanable-decision-instance-report-count/) method.
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;CleanableHistoricDecisionInstanceReportResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CleanableHistoricDecisionInstanceReportResultDto>> getCleanableHistoricDecisionInstanceReportWithHttpInfo(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getCleanableHistoricDecisionInstanceReportValidateBeforeCall(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<CleanableHistoricDecisionInstanceReportResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Cleanable Decision Instance Report (asynchronously)
     * Retrieves a report about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup)),  so that you can tune the history time to live. These reports include the count of the finished historic decision instances, cleanable decision instances and basic decision definition data - id, key, name and version. The size of the result set can be retrieved by using the  [Get Cleanable Decision Instance Report Count](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-definition/get-cleanable-decision-instance-report-count/) method.
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricDecisionInstanceReportAsync(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<CleanableHistoricDecisionInstanceReportResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCleanableHistoricDecisionInstanceReportValidateBeforeCall(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<CleanableHistoricDecisionInstanceReportResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCleanableHistoricDecisionInstanceReportCount
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricDecisionInstanceReportCountCall(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/decision-definition/cleanable-decision-instance-report/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }

        if (decisionDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionKeyIn", decisionDefinitionKeyIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (compact != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compact", compact));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCleanableHistoricDecisionInstanceReportCountValidateBeforeCall(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getCleanableHistoricDecisionInstanceReportCountCall(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, _callback);
        return localVarCall;

    }

    /**
     * Get Cleanable Decision Instance Report Count
     * Queries for the number of report results about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Decision Instance Report](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-definition/get-cleanable-decision-instance-report/)  method.
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getCleanableHistoricDecisionInstanceReportCount(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getCleanableHistoricDecisionInstanceReportCountWithHttpInfo(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact);
        return localVarResp.getData();
    }

    /**
     * Get Cleanable Decision Instance Report Count
     * Queries for the number of report results about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Decision Instance Report](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-definition/get-cleanable-decision-instance-report/)  method.
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getCleanableHistoricDecisionInstanceReportCountWithHttpInfo(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact) throws ApiException {
        okhttp3.Call localVarCall = getCleanableHistoricDecisionInstanceReportCountValidateBeforeCall(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Cleanable Decision Instance Report Count (asynchronously)
     * Queries for the number of report results about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.17/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Decision Instance Report](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-definition/get-cleanable-decision-instance-report/)  method.
     * @param decisionDefinitionIdIn Filter by decision definition ids. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKeyIn Filter by decision definition keys. Must be a comma-separated list of decision definition keys. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60;  is the default behavior. (optional)
     * @param compact Only include decision instances which have more than zero finished instances. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricDecisionInstanceReportCountAsync(String decisionDefinitionIdIn, String decisionDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCleanableHistoricDecisionInstanceReportCountValidateBeforeCall(decisionDefinitionIdIn, decisionDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
