/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.generic.SourceLocation;

public class ParsedConfiguration
implements SourceLocation {
    private String source;
    private int lineNumber;
    private String name;
    private String type;
    private String container;
    private String propertyContext;
    private Map<String, ConfigurationTokenizer.Property> properties = new HashMap<String, ConfigurationTokenizer.Property>();
    private List<ParsedConfiguration> sections = new ArrayList<ParsedConfiguration>();

    public ParsedConfiguration(String source, int lineNumber) {
        this.lineNumber = lineNumber;
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String v) {
        this.container = v;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String v) {
        this.type = v;
    }

    public String getPropertyContext() {
        return this.propertyContext;
    }

    public void setPropertyContext(String v) {
        this.propertyContext = v;
    }

    public Map<String, ConfigurationTokenizer.Property> getPropertyMap() {
        return this.properties;
    }

    public List<ParsedConfiguration> getSections() {
        return this.sections;
    }

    public void addProperty(ConfigurationTokenizer.Property p) {
        if ("name".equals(p.getName())) {
            this.name = p.getValue();
        }
        if ("type".equals(p.getName())) {
            this.type = p.getValue();
        }
        this.properties.put(p.getName(), p);
    }

    public void addSection(ParsedConfiguration c) {
        this.sections.add(c);
    }

    public ParsedConfiguration getSection(String name) {
        for (ParsedConfiguration c : this.sections) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public String getStringPropertyByPath(String s) {
        ConfigurationTokenizer.Property p = this.getPropertyByPath(s);
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public ConfigurationTokenizer.Property getPropertyByPath(String s) {
        int idx = 0;
        String[] components = s.split("\\.");
        ParsedConfiguration cfg = this;
        while (idx < components.length - 1) {
            if ((cfg = cfg.getSection(components[idx++])) != null) continue;
            return null;
        }
        ConfigurationTokenizer.Property p = cfg.getPropertyMap().get(components[idx]);
        if (p == null) {
            return null;
        }
        return p;
    }

    public String toString() {
        return "ParsedSection{container=" + this.container + ", name=" + this.name + ", type=" + this.type;
    }
}

