/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration.generic;

import org.cache2k.impl.xmlConfiguration.generic.ConfigurationException;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.generic.ParsedConfiguration;

public class ConfigurationParser {
    public static ParsedConfiguration parse(ConfigurationTokenizer parser) throws Exception {
        ParsedConfiguration c = new ParsedConfiguration(parser.getSource(), parser.getLineNumber());
        ConfigurationParser.parseTopLevelSections(parser, c);
        ConfigurationTokenizer.Item item = parser.next();
        return c;
    }

    private static void parseSection(ConfigurationTokenizer parser, ParsedConfiguration container) throws Exception {
        while (true) {
            ConfigurationTokenizer.Item item;
            if ((item = parser.next()) == null) {
                throw new ConfigurationException("null item", parser);
            }
            if (item instanceof ConfigurationTokenizer.Unnest) {
                return;
            }
            if (item instanceof ConfigurationTokenizer.Property) {
                container.addProperty((ConfigurationTokenizer.Property)item);
                continue;
            }
            if (!(item instanceof ConfigurationTokenizer.Nest)) continue;
            ConfigurationParser.parseSections(((ConfigurationTokenizer.Nest)item).getSectionName(), parser, container);
        }
    }

    private static void parseSections(String containerName, ConfigurationTokenizer parser, ParsedConfiguration container) throws Exception {
        boolean maybeSection = true;
        ConfigurationTokenizer.Item item;
        while ((item = parser.next()) != null) {
            if (item instanceof ConfigurationTokenizer.Unnest) {
                return;
            }
            if (item instanceof ConfigurationTokenizer.Property && maybeSection) {
                ParsedConfiguration nestedContainer = new ParsedConfiguration(parser.getSource(), parser.getLineNumber());
                nestedContainer.setName(containerName);
                nestedContainer.setPropertyContext(containerName);
                nestedContainer.setContainer("#DIRECT");
                nestedContainer.addProperty((ConfigurationTokenizer.Property)item);
                ConfigurationParser.parseSection(parser, nestedContainer);
                container.addSection(nestedContainer);
                return;
            }
            if (!(item instanceof ConfigurationTokenizer.Nest)) {
                throw new ConfigurationException("section start expected", item);
            }
            ConfigurationTokenizer.Nest sectionStart = (ConfigurationTokenizer.Nest)item;
            ParsedConfiguration nestedContainer = new ParsedConfiguration(parser.getSource(), parser.getLineNumber());
            nestedContainer.setName(sectionStart.getSectionName());
            nestedContainer.setPropertyContext(sectionStart.getSectionName());
            nestedContainer.setContainer(containerName);
            ConfigurationParser.parseSection(parser, nestedContainer);
            container.addSection(nestedContainer);
            maybeSection = false;
        }
        return;
    }

    private static void parseTopLevelSections(ConfigurationTokenizer parser, ParsedConfiguration container) throws Exception {
        ConfigurationTokenizer.Item item = parser.next();
        if (!(item instanceof ConfigurationTokenizer.Nest)) {
            throw new ConfigurationException("start expected", item);
        }
        while ((item = parser.next()) != null) {
            if (item instanceof ConfigurationTokenizer.Unnest) {
                return;
            }
            if (item instanceof ConfigurationTokenizer.Property) {
                container.addProperty((ConfigurationTokenizer.Property)item);
                continue;
            }
            if (!(item instanceof ConfigurationTokenizer.Nest)) continue;
            ConfigurationTokenizer.Nest sectionStart = (ConfigurationTokenizer.Nest)item;
            ParsedConfiguration nestedContainer = new ParsedConfiguration(parser.getSource(), parser.getLineNumber());
            nestedContainer.setName(sectionStart.getSectionName());
            ConfigurationParser.parseSections(((ConfigurationTokenizer.Nest)item).getSectionName(), parser, nestedContainer);
            if (nestedContainer.getPropertyMap().isEmpty() && nestedContainer.getSections().size() == 1 && nestedContainer.getSections().get(0).getContainer().equals("#DIRECT")) {
                nestedContainer = nestedContainer.getSections().get(0);
            }
            container.addSection(nestedContainer);
        }
        return;
    }
}

