/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CustomizationSupplierByClassName;
import org.cache2k.core.spi.CacheConfigurationProvider;
import org.cache2k.impl.xmlConfiguration.ConfigurationContext;
import org.cache2k.impl.xmlConfiguration.ConfigurationProvider;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationException;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationParser;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.generic.FlexibleXmlTokenizerFactory;
import org.cache2k.impl.xmlConfiguration.generic.ParsedConfiguration;
import org.cache2k.impl.xmlConfiguration.generic.StandardVariableExpander;
import org.cache2k.impl.xmlConfiguration.generic.TokenizerFactory;
import org.cache2k.impl.xmlConfiguration.generic.Util;
import org.cache2k.jcache.JCacheConfiguration;

public class CacheConfigurationProviderImpl
extends ConfigurationProvider
implements CacheConfigurationProvider {
    private static final String DEFAULT_CONFIGURATION_FILE = "cache2k.xml";
    private static final Map<String, String> VERSION_1_SECTION_TYPES = new HashMap<String, String>(){
        {
            this.put("jcache", JCacheConfiguration.class.getName());
            this.put("byClassName", CustomizationSupplierByClassName.class.getName());
        }
    };
    private final TokenizerFactory tokenizerFactory = new FlexibleXmlTokenizerFactory();
    private volatile Map<CacheManager, ConfigurationContext> manager2defaultConfig = new HashMap<CacheManager, ConfigurationContext>();
    private volatile Map<ClassLoader, ConfigurationContext> classLoader2config = new HashMap<ClassLoader, ConfigurationContext>();

    @Override
    public String getDefaultManagerName(ClassLoader cl) {
        ConfigurationContext ctx = this.classLoader2config.get(cl);
        if (ctx == null) {
            ctx = this.createContext(cl, null, DEFAULT_CONFIGURATION_FILE);
            HashMap<ClassLoader, ConfigurationContext> m2 = new HashMap<ClassLoader, ConfigurationContext>(this.classLoader2config);
            m2.put(cl, ctx);
            this.classLoader2config = m2;
        }
        return ctx.getManagerConfiguration().getDefaultManagerName();
    }

    @Override
    public Cache2kConfiguration getDefaultConfiguration(CacheManager mgr) {
        Cache2kConfiguration<?, ?> cfg = this.getManagerContext(mgr).getDefaultManagerConfiguration();
        try {
            return Util.copyViaSerialization(cfg);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Copying default cache configuration for manager '" + mgr.getName() + "'", ex);
        }
    }

    @Override
    public <K, V> void augmentConfiguration(CacheManager mgr, Cache2kConfiguration<K, V> cfg) {
        ConfigurationContext ctx = this.getManagerContext(mgr);
        if (!ctx.isConfigurationPresent()) {
            return;
        }
        String cacheName = cfg.getName();
        if (cacheName == null) {
            if (ctx.getManagerConfiguration().isIgnoreAnonymousCache()) {
                return;
            }
            throw new ConfigurationException("Cache name missing, cannot apply XML configuration. Consider parameter: ignoreAnonymousCache");
        }
        ParsedConfiguration parsedTop = this.readManagerConfigurationWithExceptionHandling(mgr.getClassLoader(), CacheConfigurationProviderImpl.getFileName(mgr));
        ParsedConfiguration section = this.extractCachesSection(parsedTop);
        ParsedConfiguration parsedCache = null;
        if (section != null) {
            parsedCache = section.getSection(cacheName);
        }
        if (parsedCache == null) {
            if (ctx.getManagerConfiguration().isIgnoreMissingCacheConfiguration()) {
                return;
            }
            String exceptionText = "Configuration for cache '" + cacheName + "' is missing. Consider parameter: ignoreMissingCacheConfiguration at " + parsedTop.getSource();
            throw new IllegalArgumentException(exceptionText);
        }
        this.apply(ctx, parsedCache, cfg);
    }

    @Override
    public Iterable<String> getConfiguredCacheNames(CacheManager mgr) {
        ConfigurationContext ctx = this.getManagerContext(mgr);
        if (!ctx.isConfigurationPresent()) {
            return Collections.emptyList();
        }
        ParsedConfiguration parsedTop = this.readManagerConfigurationWithExceptionHandling(mgr.getClassLoader(), CacheConfigurationProviderImpl.getFileName(mgr));
        ParsedConfiguration section = this.extractCachesSection(parsedTop);
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (ParsedConfiguration pc : section.getSections()) {
            names.add(pc.getName());
        }
        return names;
    }

    private static String getFileName(CacheManager mgr) {
        if (mgr.isDefaultManager()) {
            return DEFAULT_CONFIGURATION_FILE;
        }
        return "cache2k-" + mgr.getName() + ".xml";
    }

    private ParsedConfiguration readManagerConfiguration(ClassLoader cl, String fileName) throws Exception {
        InputStream is = cl.getResourceAsStream(fileName);
        if (is == null) {
            return null;
        }
        ConfigurationTokenizer tkn = this.tokenizerFactory.createTokenizer(fileName, is, null);
        ParsedConfiguration cfg = ConfigurationParser.parse(tkn);
        is.close();
        StandardVariableExpander expander = new StandardVariableExpander();
        expander.expand(cfg);
        return cfg;
    }

    private ParsedConfiguration extractCachesSection(ParsedConfiguration pc) {
        ParsedConfiguration cachesSection = pc.getSection("caches");
        return cachesSection;
    }

    private void checkCacheConfigurationOnStartup(ConfigurationContext ctx, ParsedConfiguration pc) {
        ParsedConfiguration cachesSection = pc.getSection("caches");
        if (cachesSection == null) {
            return;
        }
        for (ParsedConfiguration cacheConfig : cachesSection.getSections()) {
            this.apply(ctx, cacheConfig, new Cache2kConfiguration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationContext getManagerContext(CacheManager mgr) {
        ConfigurationContext ctx = this.manager2defaultConfig.get(mgr);
        if (ctx != null) {
            return ctx;
        }
        CacheConfigurationProviderImpl cacheConfigurationProviderImpl = this;
        synchronized (cacheConfigurationProviderImpl) {
            ctx = this.manager2defaultConfig.get(mgr);
            if (ctx != null) {
                return ctx;
            }
            if (mgr.isDefaultManager()) {
                ctx = this.classLoader2config.get(mgr.getClassLoader());
            }
            if (ctx == null) {
                ctx = this.createContext(mgr.getClassLoader(), mgr.getName(), CacheConfigurationProviderImpl.getFileName(mgr));
            }
            HashMap<CacheManager, ConfigurationContext> m2 = new HashMap<CacheManager, ConfigurationContext>(this.manager2defaultConfig);
            m2.put(mgr, ctx);
            this.manager2defaultConfig = m2;
            return ctx;
        }
    }

    private ConfigurationContext createContext(ClassLoader cl, String managerName, String fileName) {
        ParsedConfiguration pc = this.readManagerConfigurationWithExceptionHandling(cl, fileName);
        ConfigurationContext ctx = new ConfigurationContext();
        ctx.setClassLoader(cl);
        Cache2kConfiguration defaultConfiguration = new Cache2kConfiguration();
        ctx.setDefaultManagerConfiguration(defaultConfiguration);
        ctx.getManagerConfiguration().setDefaultManagerName(managerName);
        if (pc != null) {
            defaultConfiguration.setExternalConfigurationPresent(true);
            ctx.setTemplates(this.extractTemplates(pc));
            this.apply(ctx, pc, ctx.getManagerConfiguration());
            if (ctx.getManagerConfiguration().getVersion() != null && ctx.getManagerConfiguration().getVersion().startsWith("1.")) {
                ctx.setPredefinedSectionTypes(VERSION_1_SECTION_TYPES);
            }
            this.applyDefaultConfigurationIfPresent(ctx, pc, defaultConfiguration);
            ctx.setConfigurationPresent(true);
            if (!ctx.getManagerConfiguration().isSkipCheckOnStartup()) {
                this.checkCacheConfigurationOnStartup(ctx, pc);
            }
        }
        return ctx;
    }

    private ParsedConfiguration readManagerConfigurationWithExceptionHandling(ClassLoader cl, String fileName) {
        ParsedConfiguration pc;
        try {
            pc = this.readManagerConfiguration(cl, fileName);
        }
        catch (CacheException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Reading configuration for manager from '" + fileName + "'", ex);
        }
        return pc;
    }

    private void applyDefaultConfigurationIfPresent(ConfigurationContext ctx, ParsedConfiguration pc, Cache2kConfiguration defaultConfiguration) {
        ParsedConfiguration defaults = pc.getSection("defaults");
        if (defaults != null) {
            defaults = defaults.getSection("cache");
        }
        if (defaults != null) {
            this.apply(ctx, defaults, defaultConfiguration);
        }
    }

    private ParsedConfiguration extractTemplates(ParsedConfiguration pc) {
        return pc.getSection("templates");
    }
}

