/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.serverSide;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.cache2k.Cache;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.spi.CacheLifeCycleListener;
import org.cache2k.core.spi.CacheManagerLifeCycleListener;
import org.cache2k.core.util.Log;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;
import org.cache2k.impl.serverSide.ManagerMXBeanImpl;

public class JmxSupport
implements CacheLifeCycleListener,
CacheManagerLifeCycleListener {
    private static final String REGISTERED_FLAG = JmxSupport.class.getName() + ".registered";
    private static final boolean MANAGEMENT_UNAVAILABLE;
    private final Log log = Log.getLog(JmxSupport.class);

    @Override
    public void cacheCreated(Cache c, Cache2kConfiguration cfg) {
        if (MANAGEMENT_UNAVAILABLE || !cfg.isEnableJmx() || cfg.isDisableMonitoring()) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        String name = this.standardName(c.getCacheManager(), c);
        try {
            mbs.registerMBean(c.getStatistics(), new ObjectName(name));
        }
        catch (InstanceAlreadyExistsException existing) {
            this.log.debug("register failure, cache: " + c.getName(), existing);
        }
        catch (Exception e) {
            throw new CacheException("register JMX bean, ObjectName: " + name, e);
        }
    }

    @Override
    public void cacheDestroyed(Cache c) {
        if (MANAGEMENT_UNAVAILABLE) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        String name = this.standardName(c.getCacheManager(), c);
        try {
            mbs.unregisterMBean(new ObjectName(name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new CacheException("unregister JMX bean, ObjectName: " + name, e);
        }
    }

    @Override
    public void managerCreated(CacheManager m) {
        if (MANAGEMENT_UNAVAILABLE) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        ManagerMXBeanImpl mBean = new ManagerMXBeanImpl((CacheManagerImpl)m);
        String name = JmxSupport.managerName(m);
        try {
            mbs.registerMBean(mBean, new ObjectName(name));
            m.getProperties().put(REGISTERED_FLAG, (Object)true);
            this.log.debug("Manager created and registered as: " + name);
        }
        catch (InstanceAlreadyExistsException existing) {
            this.log.debug("register failure, manager: " + m.getName(), existing);
        }
        catch (Exception e) {
            throw new CacheException("register JMX bean, ObjectName: " + name, e);
        }
    }

    @Override
    public void managerDestroyed(CacheManager m) {
        if (MANAGEMENT_UNAVAILABLE) {
            return;
        }
        if (!m.getProperties().containsKey(REGISTERED_FLAG)) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        String name = JmxSupport.managerName(m);
        try {
            mbs.unregisterMBean(new ObjectName(name));
        }
        catch (Exception e) {
            throw new CacheException("Error unregister JMX bean, ObjectName: " + name, e);
        }
    }

    private static MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private static String managerName(CacheManager cm) {
        return "org.cache2k:type=CacheManager,name=" + JmxSupport.sanitizeNameAsJmxValue(cm.getName());
    }

    private String standardName(CacheManager cm, Cache c) {
        return "org.cache2k:type=Cache,manager=" + JmxSupport.sanitizeNameAsJmxValue(cm.getName()) + ",name=" + JmxSupport.sanitizeNameAsJmxValue(c.getName());
    }

    private static String sanitizeNameAsJmxValue(String s) {
        if (s.indexOf(44) >= 0) {
            return '\"' + s + '\"';
        }
        return s;
    }

    static {
        boolean v = false;
        if (TunableFactory.get(Tunable.class).enable) {
            try {
                v = JmxSupport.getPlatformMBeanServer() == null;
            }
            catch (NoClassDefFoundError err) {
                v = true;
            }
        }
        MANAGEMENT_UNAVAILABLE = v;
    }

    public static class Tunable
    extends TunableConstants {
        public boolean enable = true;
    }
}

