/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CustomizationException;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.core.BaseCache;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.core.CacheBuildContext;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntHeapCache;
import org.cache2k.core.IntWiredCache;
import org.cache2k.core.LongHeapCache;
import org.cache2k.core.LongWiredCache;
import org.cache2k.core.WiredCache;
import org.cache2k.core.event.AsyncDispatcher;
import org.cache2k.core.event.AsyncEvent;
import org.cache2k.core.eviction.EvictionFactory;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.timing.Timing;
import org.cache2k.core.util.DefaultClock;
import org.cache2k.core.util.InternalClock;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryEvictedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.FunctionalCacheLoader;

public class InternalCache2kBuilder<K, V>
implements CacheBuildContext<K, V> {
    private static final AtomicLong DERIVED_NAME_COUNTER = new AtomicLong(System.currentTimeMillis() % 1234L);
    private final CacheManagerImpl manager;
    private final Cache2kConfiguration<K, V> config;
    private InternalClock clock;
    static final EvictionFactory EVICTION_FACTORY = new EvictionFactory();

    public InternalCache2kBuilder(Cache2kConfiguration<K, V> config, CacheManager manager) {
        this.config = config;
        this.manager = (CacheManagerImpl)(manager == null ? CacheManager.getInstance() : manager);
    }

    private static boolean isBuilderClass(String className) {
        return Cache2kBuilder.class.getName().equals(className);
    }

    private static String deriveNameFromStackTrace() {
        boolean builderSeen = false;
        Exception ex = new Exception();
        for (StackTraceElement e : ex.getStackTrace()) {
            if (builderSeen && !InternalCache2kBuilder.isBuilderClass(e.getClassName())) {
                String methodName = e.getMethodName();
                if (methodName.equals("<init>")) {
                    methodName = "INIT";
                }
                if (methodName.equals("<clinit>")) {
                    methodName = "CLINIT";
                }
                return "_" + e.getClassName() + "." + methodName + "-" + e.getLineNumber() + "-" + Long.toString(DERIVED_NAME_COUNTER.incrementAndGet(), 36);
            }
            builderSeen = InternalCache2kBuilder.isBuilderClass(e.getClassName());
        }
        throw new IllegalArgumentException("name missing and automatic generation failed");
    }

    @Override
    public InternalClock getClock() {
        return this.clock;
    }

    @Override
    public Cache2kConfiguration<K, V> getConfiguration() {
        return this.config;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.manager;
    }

    @Override
    public <T> T createCustomization(CustomizationSupplier<T> supplier, T fallback) {
        if (supplier == null) {
            return fallback;
        }
        try {
            return supplier.supply(this.getCacheManager());
        }
        catch (Exception ex) {
            throw new CustomizationException("Initialization of customization failed", ex);
        }
    }

    @Override
    public <T> T createCustomization(CustomizationSupplier<T> supplier) {
        return this.createCustomization(supplier, null);
    }

    private void configureViaSettersDirect(HeapCache<K, V> c) {
        if (this.config.getLoader() != null) {
            FunctionalCacheLoader loader;
            FunctionalCacheLoader<K, V> obj = this.createCustomization(this.config.getLoader());
            if (obj instanceof CacheLoader) {
                loader = (CacheLoader)obj;
                c.setAdvancedLoader(new AdvancedCacheLoader<K, V>((CacheLoader)loader){
                    final /* synthetic */ CacheLoader val$loader;
                    {
                        this.val$loader = cacheLoader;
                    }

                    @Override
                    public V load(K key, long startTime, CacheEntry<K, V> currentEntry) throws Exception {
                        return this.val$loader.load(key);
                    }
                });
            } else {
                loader = obj;
                c.setAdvancedLoader(new AdvancedCacheLoader<K, V>(){

                    @Override
                    public V load(K key, long startTime, CacheEntry<K, V> currentEntry) throws Exception {
                        return loader.load(key);
                    }
                });
            }
        }
        if (this.config.getAdvancedLoader() != null) {
            AdvancedCacheLoader<K, V> loader = this.createCustomization(this.config.getAdvancedLoader());
            WrappedAdvancedCacheLoader<K, V> wrappedLoader = new WrappedAdvancedCacheLoader<K, V>(c, loader);
            c.setAdvancedLoader(wrappedLoader);
        }
        if (this.config.getExceptionPropagator() != null) {
            c.setExceptionPropagator(this.createCustomization(this.config.getExceptionPropagator()));
        }
        c.setCacheConfig(this);
    }

    public Cache<K, V> build() {
        Cache2kCoreProviderImpl.CACHE_CONFIGURATION_PROVIDER.augmentConfiguration(this.manager, this.config);
        return this.buildAsIs();
    }

    public Cache<K, V> buildAsIs() {
        if (this.config.getValueType() == null) {
            this.config.setValueType(Object.class);
        }
        if (this.config.getKeyType() == null) {
            this.config.setKeyType(Object.class);
        }
        if (this.config.getName() == null) {
            this.config.setName(InternalCache2kBuilder.deriveNameFromStackTrace());
        }
        this.checkConfiguration();
        Class<K> keyType = this.config.getKeyType().getType();
        BaseCache cache = keyType == Integer.class ? new IntHeapCache() : (keyType == Long.class ? new LongHeapCache() : new HeapCache());
        this.clock = (InternalClock)this.createCustomization(this.config.getTimeReference());
        if (this.clock == null) {
            this.clock = DefaultClock.INSTANCE;
        }
        HeapCache bc = cache;
        bc.setCacheManager(this.manager);
        this.configureViaSettersDirect(bc);
        bc.setClock(this.clock);
        if (this.config.isRefreshAhead() && this.config.getAsyncLoader() == null && this.config.getLoader() == null && this.config.getAdvancedLoader() == null) {
            throw new IllegalArgumentException("refresh ahead enabled, but no loader defined");
        }
        boolean wrap = this.config.getWeigher() != null || this.config.hasListeners() || this.config.hasAsyncListeners() || this.config.getWriter() != null || this.config.getAsyncLoader() != null;
        WiredCache wc = null;
        if (wrap) {
            wc = keyType == Integer.class ? new IntWiredCache() : (keyType == Long.class ? new LongWiredCache() : new WiredCache());
            wc.heapCache = bc;
            cache = wc;
        }
        String name = this.manager.newCache(cache, bc.getName());
        bc.setName(name);
        if (wrap) {
            wc.loader = bc.loader;
            wc.writer = this.createCustomization(this.config.getWriter());
            wc.asyncLoader = this.createCustomization(this.config.getAsyncLoader());
            ArrayList<CacheEntryCreatedListener> syncCreatedListeners = new ArrayList<CacheEntryCreatedListener>();
            ArrayList<CacheEntryUpdatedListener> syncUpdatedListeners = new ArrayList<CacheEntryUpdatedListener>();
            ArrayList<CacheEntryRemovedListener> syncRemovedListeners = new ArrayList<CacheEntryRemovedListener>();
            ArrayList<CacheEntryExpiredListener> syncExpiredListeners = new ArrayList<CacheEntryExpiredListener>();
            ArrayList<CacheEntryEvictedListener> syncEvictedListeners = new ArrayList<CacheEntryEvictedListener>();
            if (this.config.hasListeners()) {
                for (CustomizationSupplier customizationSupplier : this.config.getListeners()) {
                    CacheEntryOperationListener el = (CacheEntryOperationListener)this.createCustomization(customizationSupplier);
                    if (el instanceof CacheEntryCreatedListener) {
                        syncCreatedListeners.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        syncUpdatedListeners.add((CacheEntryUpdatedListener)el);
                    }
                    if (el instanceof CacheEntryRemovedListener) {
                        syncRemovedListeners.add((CacheEntryRemovedListener)el);
                    }
                    if (el instanceof CacheEntryExpiredListener) {
                        syncExpiredListeners.add((CacheEntryExpiredListener)el);
                    }
                    if (!(el instanceof CacheEntryEvictedListener)) continue;
                    syncEvictedListeners.add((CacheEntryEvictedListener)el);
                }
            }
            if (this.config.hasAsyncListeners()) {
                Executor asyncExecutor = bc.getExecutor();
                if (this.config.getAsyncListenerExecutor() != null) {
                    asyncExecutor = this.createCustomization(this.config.getAsyncListenerExecutor());
                }
                AsyncDispatcher asyncDispatcher = new AsyncDispatcher(wc, asyncExecutor);
                ArrayList<CacheEntryCreatedListener> cll = new ArrayList<CacheEntryCreatedListener>();
                ArrayList<CacheEntryUpdatedListener> ull = new ArrayList<CacheEntryUpdatedListener>();
                ArrayList<CacheEntryRemovedListener> rll = new ArrayList<CacheEntryRemovedListener>();
                ArrayList<CacheEntryExpiredListener> ell = new ArrayList<CacheEntryExpiredListener>();
                ArrayList<CacheEntryEvictedListener> evl = new ArrayList<CacheEntryEvictedListener>();
                for (CustomizationSupplier customizationSupplier : this.config.getAsyncListeners()) {
                    CacheEntryOperationListener el = (CacheEntryOperationListener)this.createCustomization(customizationSupplier);
                    if (el instanceof CacheEntryCreatedListener) {
                        cll.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        ull.add((CacheEntryUpdatedListener)el);
                    }
                    if (el instanceof CacheEntryRemovedListener) {
                        rll.add((CacheEntryRemovedListener)el);
                    }
                    if (el instanceof CacheEntryExpiredListener) {
                        ell.add((CacheEntryExpiredListener)el);
                    }
                    if (!(el instanceof CacheEntryEvictedListener)) continue;
                    evl.add((CacheEntryEvictedListener)el);
                }
                for (CacheEntryCreatedListener cacheEntryCreatedListener : cll) {
                    syncCreatedListeners.add(new AsyncCreatedListener(asyncDispatcher, cacheEntryCreatedListener));
                }
                for (CacheEntryUpdatedListener cacheEntryUpdatedListener : ull) {
                    syncUpdatedListeners.add(new AsyncUpdatedListener(asyncDispatcher, cacheEntryUpdatedListener));
                }
                for (CacheEntryRemovedListener cacheEntryRemovedListener : rll) {
                    syncRemovedListeners.add(new AsyncRemovedListener(asyncDispatcher, cacheEntryRemovedListener));
                }
                for (CacheEntryExpiredListener cacheEntryExpiredListener : ell) {
                    syncExpiredListeners.add(new AsyncExpiredListener(asyncDispatcher, cacheEntryExpiredListener));
                }
                for (CacheEntryEvictedListener cacheEntryEvictedListener : evl) {
                    syncEvictedListeners.add(new AsyncEvictedListener(asyncDispatcher, cacheEntryEvictedListener));
                }
            }
            if (!syncCreatedListeners.isEmpty()) {
                wc.syncEntryCreatedListeners = syncCreatedListeners.toArray(new CacheEntryCreatedListener[0]);
            }
            if (!syncUpdatedListeners.isEmpty()) {
                wc.syncEntryUpdatedListeners = syncUpdatedListeners.toArray(new CacheEntryUpdatedListener[0]);
            }
            if (!syncRemovedListeners.isEmpty()) {
                wc.syncEntryRemovedListeners = syncRemovedListeners.toArray(new CacheEntryRemovedListener[0]);
            }
            if (!syncExpiredListeners.isEmpty()) {
                wc.syncEntryExpiredListeners = syncExpiredListeners.toArray(new CacheEntryExpiredListener[0]);
            }
            if (!syncEvictedListeners.isEmpty()) {
                wc.syncEntryEvictedListeners = syncEvictedListeners.toArray(new CacheEntryEvictedListener[0]);
            }
            bc.eviction = EVICTION_FACTORY.constructEviction(this, bc, wc, this.config, Runtime.getRuntime().availableProcessors());
            Timing rh = Timing.of(this);
            bc.setTiming(rh);
            wc.init();
        } else {
            Timing rh = Timing.of(this);
            bc.setTiming(rh);
            bc.eviction = EVICTION_FACTORY.constructEviction(this, bc, HeapCacheListener.NO_OPERATION, this.config, Runtime.getRuntime().availableProcessors());
            bc.init();
        }
        this.manager.sendCreatedEvent(cache, this.config);
        return cache;
    }

    private void checkConfiguration() {
        if (this.config.getExpireAfterWrite() == 0x7FFFFFFFFFFFFFFEL && this.config.getExpiryPolicy() == null) {
            throw new IllegalArgumentException("not eternal is set, but expire value is missing");
        }
    }

    private static class AsyncEvictedListener<K, V>
    implements CacheEntryEvictedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryEvictedListener<K, V> listener;

        AsyncEvictedListener(AsyncDispatcher<K> dispatcher, CacheEntryEvictedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        @Override
        public void onEntryEvicted(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncEvictedListener.this.listener.onEntryEvicted(c, e);
                }
            });
        }
    }

    private static class AsyncExpiredListener<K, V>
    implements CacheEntryExpiredListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryExpiredListener<K, V> listener;

        AsyncExpiredListener(AsyncDispatcher<K> dispatcher, CacheEntryExpiredListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        @Override
        public void onEntryExpired(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncExpiredListener.this.listener.onEntryExpired(c, e);
                }
            });
        }
    }

    private static class AsyncRemovedListener<K, V>
    implements CacheEntryRemovedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryRemovedListener<K, V> listener;

        AsyncRemovedListener(AsyncDispatcher<K> dispatcher, CacheEntryRemovedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        @Override
        public void onEntryRemoved(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncRemovedListener.this.listener.onEntryRemoved(c, e);
                }
            });
        }
    }

    private static class AsyncUpdatedListener<K, V>
    implements CacheEntryUpdatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryUpdatedListener<K, V> listener;

        AsyncUpdatedListener(AsyncDispatcher<K> dispatcher, CacheEntryUpdatedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        @Override
        public void onEntryUpdated(final Cache<K, V> cache, final CacheEntry<K, V> currentEntry, final CacheEntry<K, V> entryWithNewData) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return currentEntry.getKey();
                }

                @Override
                public void execute() {
                    AsyncUpdatedListener.this.listener.onEntryUpdated(cache, currentEntry, entryWithNewData);
                }
            });
        }
    }

    static class AsyncCreatedListener<K, V>
    implements CacheEntryCreatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryCreatedListener<K, V> listener;

        AsyncCreatedListener(AsyncDispatcher<K> dispatcher, CacheEntryCreatedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        @Override
        public void onEntryCreated(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncCreatedListener.this.listener.onEntryCreated(c, e);
                }
            });
        }
    }

    private static class WrappedAdvancedCacheLoader<K, V>
    extends AdvancedCacheLoader<K, V>
    implements Closeable {
        HeapCache<K, V> heapCache;
        private final AdvancedCacheLoader<K, V> forward;

        WrappedAdvancedCacheLoader(HeapCache<K, V> heapCache, AdvancedCacheLoader<K, V> forward) {
            this.heapCache = heapCache;
            this.forward = forward;
        }

        @Override
        public void close() throws IOException {
            if (this.forward instanceof Closeable) {
                ((Closeable)((Object)this.forward)).close();
            }
        }

        @Override
        public V load(K key, long startTime, CacheEntry<K, V> currentEntry) throws Exception {
            if (currentEntry == null) {
                return this.forward.load(key, startTime, null);
            }
            return this.forward.load(key, startTime, this.heapCache.returnCacheEntry((ExaminationEntry)((Object)currentEntry)));
        }
    }
}

