/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.CompletableFuture;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.config.CacheBuildContext;
import org.cache2k.config.ConfigSection;
import org.cache2k.config.CustomizationReferenceSupplier;
import org.cache2k.config.ToggleFeature;
import org.cache2k.config.WithSection;
import org.cache2k.event.CacheCreatedListener;
import org.cache2k.extra.micrometer.Cache2kCacheMetrics;
import org.cache2k.extra.micrometer.MicrometerConfig;

public class MicrometerSupport
extends ToggleFeature
implements WithSection<MicrometerConfig, MicrometerConfig.Builder> {
    private static final MicrometerConfig DEFAULT_CONFIG = new MicrometerConfig();
    private static final CacheCreatedListener LISTENER = new CacheCreatedListener(){

        public <K, V> CompletableFuture<Void> onCacheCreated(Cache<K, V> cache, CacheBuildContext<K, V> ctx) {
            MicrometerConfig config = (MicrometerConfig)ctx.getConfig().getSections().getSection(MicrometerConfig.class, (ConfigSection)DEFAULT_CONFIG);
            Cache2kCacheMetrics.monitor((MeterRegistry)ctx.createCustomization(config.getRegistry()), cache, new String[0]);
            return null;
        }
    };

    public static MicrometerSupport enable(Cache2kBuilder<?, ?> b) {
        return (MicrometerSupport)ToggleFeature.enable(b, MicrometerSupport.class);
    }

    public static void disable(Cache2kBuilder<?, ?> b) {
        b.disable(MicrometerSupport.class);
    }

    protected <K, V> void doEnlist(CacheBuildContext<K, V> ctx) {
        if (ctx.getConfig().isDisableMonitoring()) {
            return;
        }
        ctx.getConfig().getLifecycleListeners().add(new CustomizationReferenceSupplier((Object)LISTENER));
    }

    public Class<MicrometerConfig> getConfigClass() {
        return MicrometerConfig.class;
    }
}

