/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.micrometer;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import java.util.concurrent.TimeUnit;
import org.cache2k.Cache;
import org.cache2k.core.api.InternalCache;
import org.cache2k.operation.CacheControl;
import org.cache2k.operation.CacheStatistics;

public class Cache2kCacheMetrics
extends CacheMeterBinder {
    private final CacheControl control;

    public Cache2kCacheMetrics(Cache<?, ?> cache, Iterable<Tag> tags) {
        super(cache, cache.getName(), (Iterable)Tags.concat(tags, Cache2kCacheMetrics.extendedTags(cache)));
        this.control = CacheControl.of(cache);
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String ... tags) {
        return Cache2kCacheMetrics.monitor(registry, cache, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, Iterable<Tag> tags) {
        new Cache2kCacheMetrics(cache, tags).bindTo(registry);
        return cache;
    }

    protected Long size() {
        return this.control.getSize();
    }

    protected long hitCount() {
        CacheStatistics stats = this.stats();
        if (stats == null) {
            return 0L;
        }
        return stats.getGetCount() - stats.getMissCount();
    }

    protected Long missCount() {
        CacheStatistics stats = this.stats();
        if (stats == null) {
            return null;
        }
        return stats.getMissCount();
    }

    protected Long evictionCount() {
        CacheStatistics stats = this.stats();
        if (stats == null) {
            return null;
        }
        return stats.getEvictedCount() + stats.getExpiredCount() + stats.getRemoveCount();
    }

    protected long putCount() {
        CacheStatistics stats = this.stats();
        if (stats == null) {
            return 0L;
        }
        return stats.getPutCount();
    }

    private CacheStatistics stats() {
        return this.control.sampleStatistics();
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        if (this.control.isWeigherPresent()) {
            Gauge.builder((String)"cache.currentWeight", (Object)this.control, mgm -> mgm.getTotalWeight()).tags(this.getTagsWithCacheName()).description("The sum of weights of all cached entries.").register(registry);
        }
        if (this.control.isLoaderPresent()) {
            TimeGauge.builder((String)"cache.load.duration", (Object)this.control, (TimeUnit)TimeUnit.MILLISECONDS, mgm -> mgm.sampleStatistics().getMillisPerLoad()).tags(this.getTagsWithCacheName()).description("The time the cache has spent loading new values").register(registry);
            FunctionCounter.builder((String)"cache.load", (Object)this.control, mgm -> mgm.sampleStatistics().getLoadCount()).tags(this.getTagsWithCacheName()).tags(new String[]{"result", "success"}).description("The number of times cache lookup methods have successfully loaded a new value").register(registry);
            FunctionCounter.builder((String)"cache.load", (Object)this.control, mgm -> mgm.sampleStatistics().getLoadExceptionCount()).tags(this.getTagsWithCacheName()).tags(new String[]{"result", "failure"}).description("The number of times cache lookup methods threw an exception while loading a new value").register(registry);
        }
    }

    private static Iterable<Tag> extendedTags(Cache<?, ?> cache) {
        InternalCache internalCache = (InternalCache)cache.requestInterface(InternalCache.class);
        return Tags.of((String[])new String[]{"cache2kCacheManager", internalCache.getCacheManager().getName(), "keyType=", internalCache.getKeyType().toString().substring("CacheType:".length()), "valueType=", internalCache.getKeyType().toString().substring("CacheType:".length())});
    }
}

