/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.xmlConfiguration;

import java.util.HashMap;
import java.util.Map;
import org.cache2k.xmlConfiguration.ConfigurationException;
import org.cache2k.xmlConfiguration.ConfigurationTokenizer;
import org.cache2k.xmlConfiguration.ParsedConfiguration;
import org.cache2k.xmlConfiguration.VariableExpander;

public class StandardVariableExpander
implements VariableExpander {
    private Map<String, VariableExpander.ValueAccessor> scope2resolver = new HashMap<String, VariableExpander.ValueAccessor>();

    public StandardVariableExpander() {
        this.scope2resolver.put("ENV", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                return System.getenv(_variable);
            }
        });
        this.scope2resolver.put("PROP", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                return System.getProperty(_variable);
            }
        });
        this.scope2resolver.put("TOP", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                ConfigurationTokenizer.Property p = ctx.getTopLevelConfiguration().getPropertyByPath(_variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
        this.scope2resolver.put("", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                ConfigurationTokenizer.Property p = ctx.getCurrentConfiguration().getPropertyByPath(_variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
    }

    @Override
    public void expand(ParsedConfiguration cfg) {
        new Process(cfg, new HashMap<String, VariableExpander.ValueAccessor>(this.scope2resolver)).expand();
    }

    private String checkAndReturnValue(ConfigurationTokenizer.Property p) {
        if (p == null) {
            return null;
        }
        if (!p.isExpanded()) {
            throw new VariableExpander.NeedsExpansion();
        }
        return p.getValue();
    }

    private static class Process
    implements VariableExpander.ExpanderContext {
        private final Map<String, VariableExpander.ValueAccessor> scope2resolver;
        private final ParsedConfiguration top;
        private ParsedConfiguration current;
        private int forwardReference = 0;
        private ConfigurationTokenizer.Property lastTroublemaker;

        Process(ParsedConfiguration _top, Map<String, VariableExpander.ValueAccessor> _scope2resolver) {
            this.top = _top;
            this.scope2resolver = _scope2resolver;
        }

        private void expand() {
            do {
                int lastCounter = this.forwardReference;
                this.forwardReference = 0;
                this.recurse(this.top);
                if (lastCounter <= 0 || lastCounter != this.forwardReference) continue;
                throw new ConfigurationException("Cyclic reference", this.lastTroublemaker);
            } while (this.forwardReference > 0);
        }

        private void recurse(ParsedConfiguration cfg) {
            this.current = cfg;
            for (ConfigurationTokenizer.Property p : cfg.getPropertyMap().values()) {
                if (p.isExpanded()) continue;
                String v0 = p.getValue();
                try {
                    String v = this.expand(v0);
                    if (v0 != v) {
                        p.setValue(v);
                    }
                    p.setExpanded(true);
                }
                catch (VariableExpander.NeedsExpansion ex) {
                    ++this.forwardReference;
                    this.lastTroublemaker = p;
                }
            }
            for (ParsedConfiguration c2 : cfg.getSections()) {
                String _context = c2.getPropertyContext();
                VariableExpander.ValueAccessor _savedAccessor = null;
                if (_context != null) {
                    _savedAccessor = this.scope2resolver.get(_context);
                    final ParsedConfiguration _localScope = c2;
                    this.scope2resolver.put(_context, new VariableExpander.ValueAccessor(){

                        @Override
                        public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                            return _localScope.getStringPropertyByPath(_variable);
                        }
                    });
                }
                this.recurse(c2);
                if (_savedAccessor == null) continue;
                this.scope2resolver.put(_context, _savedAccessor);
            }
        }

        @Override
        public ParsedConfiguration getCurrentConfiguration() {
            return this.current;
        }

        @Override
        public ParsedConfiguration getTopLevelConfiguration() {
            return this.top;
        }

        private String expand(String s) {
            int idx = 0;
            while ((idx = s.indexOf("${", idx)) >= 0) {
                int _endIdx = s.indexOf(125, idx);
                if (_endIdx < 0) {
                    return s;
                }
                int _scopeIdx = s.indexOf(46, idx);
                if (_scopeIdx >= 0) {
                    String _substitutionString;
                    String _scope = s.substring(idx + 2, _scopeIdx);
                    String _varName = s.substring(_scopeIdx + 1, _endIdx);
                    VariableExpander.ValueAccessor r = this.scope2resolver.get(_scope);
                    if (r != null && (_substitutionString = r.get(this, _varName)) != null) {
                        s = s.substring(0, idx) + _substitutionString + s.substring(_endIdx + 1);
                        _endIdx = idx + _substitutionString.length();
                    }
                }
                idx = _endIdx;
            }
            return s;
        }
    }
}

