/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import java.util.concurrent.Callable;
import org.cache2k.CacheEntry;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.MutableEntryOnProgress;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.ResultEntry;
import org.cache2k.core.operation.Semantic;
import org.cache2k.integration.CacheLoaderException;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessor;
import org.cache2k.processor.RestartException;

public class Operations<K, V> {
    public static final Operations SINGLETON = new Operations();
    static final Semantic PEEK = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            }
        }
    };
    static final Semantic GET = new Semantic.MightUpdateExisting(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            } else {
                c.wantMutation();
            }
        }

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    public static final Semantic UNCONDITIONAL_LOAD = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    public static final Semantic REFRESH = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.refresh();
        }
    };
    static final Semantic GET_ENTRY = new Semantic.MightUpdateExisting(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.entryResult(e);
            } else {
                c.wantMutation();
            }
        }

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }

        @Override
        public void loaded(Progress c, ExaminationEntry e) {
            c.entryResult(e);
        }
    };
    static final Semantic PEEK_ENTRY = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.entryResult(e);
            }
        }
    };
    static final Semantic REMOVE = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.remove();
        }
    };
    static final Semantic CONTAINS_REMOVE = new Semantic.UpdateExisting(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            if (c.isPresent()) {
                c.result(true);
                c.remove();
                return;
            }
            c.result(false);
            c.remove();
        }
    };
    static final Semantic CONTAINS = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresent()) {
                c.result(true);
                return;
            }
            c.result(false);
        }
    };
    static final Semantic PEEK_REMOVE = new Semantic.UpdateExisting(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            }
            c.remove();
        }
    };

    public Semantic<K, V, V> peek(K key) {
        return PEEK;
    }

    public Semantic<K, V, V> get(K key) {
        return GET;
    }

    public Semantic<K, V, ResultEntry<K, V>> getEntry(K key) {
        return GET_ENTRY;
    }

    public Semantic<K, V, ResultEntry<K, V>> peekEntry(K key) {
        return PEEK_ENTRY;
    }

    public Semantic<K, V, V> remove(K key) {
        return REMOVE;
    }

    public Semantic<K, V, Boolean> containsAndRemove(K key) {
        return CONTAINS_REMOVE;
    }

    public Semantic<K, V, Boolean> contains(K key) {
        return CONTAINS;
    }

    public Semantic<K, V, V> peekAndRemove(K key) {
        return PEEK_REMOVE;
    }

    public Semantic<K, V, V> peekAndReplace(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, V>(){

            @Override
            public void update(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(e.getValueOrException());
                    c.put(value);
                }
            }
        };
    }

    public Semantic<K, V, V> peekAndPut(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, V>(){

            @Override
            public void update(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(e.getValueOrException());
                }
                c.put(value);
            }
        };
    }

    public Semantic<K, V, V> computeIfAbsent(K key, final Callable<V> _function) {
        return new Semantic.UpdateExisting<K, V, V>(){

            @Override
            public void update(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(e.getValueOrException());
                } else {
                    try {
                        Object _value = _function.call();
                        c.put(_value);
                        c.result(_value);
                    }
                    catch (Exception ex) {
                        c.failure(new CacheLoaderException(ex));
                    }
                }
            }
        };
    }

    public Semantic<K, V, V> put(K key, final V value) {
        return new Semantic.Update<K, V, V>(){

            @Override
            public void update(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                c.put(value);
            }
        };
    }

    public Semantic<K, V, Boolean> putIfAbsent(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (!c.isPresentOrMiss()) {
                    c.result(true);
                    c.put(value);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(true);
                    c.put(value);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value, final V newValue) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss() && (value == null && e.getValueOrException() == null || value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.put(newValue);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, CacheEntry<K, V>> replaceOrGet(K key, final V value, final V newValue, final CacheEntry<K, V> dummyEntry) {
        return new Semantic.UpdateExisting<K, V, CacheEntry<K, V>>(){

            @Override
            public void update(Progress<K, V, CacheEntry<K, V>> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    if (e.getValueOrException().equals(value)) {
                        c.result(null);
                        c.put(newValue);
                        return;
                    }
                    c.entryResult(e);
                    return;
                }
                c.result(dummyEntry);
            }
        };
    }

    public Semantic<K, V, Boolean> remove(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss() && (value == null && e.getValueOrException() == null || value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.remove();
                    return;
                }
                c.result(false);
            }
        };
    }

    public <R> Semantic<K, V, R> invoke(K key, final boolean _readThrough, final EntryProcessor<K, V, R> _processor) {
        return new Semantic.UpdateExisting<K, V, R>(){

            @Override
            public void update(Progress<K, V, R> c, ExaminationEntry<K, V> e) {
                MutableEntryOnProgress _mutableEntryOnProgress = new MutableEntryOnProgress(c, e, _readThrough);
                try {
                    Object _result = _processor.process(_mutableEntryOnProgress);
                    c.result(_result);
                }
                catch (NeedsLoadRestartException rs) {
                    c.loadAndMutation();
                    return;
                }
                catch (Throwable t) {
                    c.failure(new EntryProcessingException(t));
                    return;
                }
                _mutableEntryOnProgress.sendMutationCommandIfNeeded();
            }

            @Override
            public void loaded(Progress<K, V, R> c, ExaminationEntry<K, V> e) {
            }
        };
    }

    public Semantic<K, V, Void> expire(K key, final long t) {
        return new Semantic.UpdateExisting<K, V, Void>(){

            @Override
            public void update(Progress c, ExaminationEntry e) {
                if (t == 0L || t == 1L) {
                    if (c.isPresentOrInRefreshProbation()) {
                        c.expire(t);
                    }
                    return;
                }
                if (c.isPresent()) {
                    c.expire(t);
                }
            }
        };
    }

    public static class NeedsLoadRestartException
    extends RestartException {
    }
}

