// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.libfreenect2;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.libfreenect2.global.freenect2.*;


/** \defgroup logging Logging utilities
 * Specify logging level and custom logging destination. */
/**\{
<p>
/** Provide interfaces to receive log messages.
 * You can inherit this class and implement your custom logger. */
@Namespace("libfreenect2") @Properties(inherit = org.bytedeco.libfreenect2.presets.freenect2.class)
public class Logger extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Logger(Pointer p) { super(p); }

  /** Available levels of logging, higher is more output. */
  /** enum libfreenect2::Logger::Level */
  public static final int
    None = 0,
    Error = 1,
    Warning = 2,
    Info = 3,
    Debug = 4;

  /** Default is Info, or overridden by environment variable {@code LIBFREENECT2_LOGGER_LEVEL}.
   * {@code LIBFREENECT2_LOGGER_LEVEL} can contain a case-insensitive name of level.
   */
  public static native @Cast("libfreenect2::Logger::Level") int getDefaultLevel();

  /** Convert logging level to a human-readable name.
   */
  public static native @StdString BytePointer level2str(@Cast("libfreenect2::Logger::Level") int level);

  /** Get the level of the logger; the level is immutable. */
  public native @Cast("libfreenect2::Logger::Level") int level();

  /** libfreenect2 calls this function to output all log messages. */
  public native void log(@Cast("libfreenect2::Logger::Level") int level, @StdString BytePointer message);
  public native void log(@Cast("libfreenect2::Logger::Level") int level, @StdString String message);
}
