///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var WaitingPanel = /** @class */ (function () {
        function WaitingPanel(overlay) {
            this.overlay = overlay;
        }
        WaitingPanel.prototype.processAjaxUpdate = function () {
            var _this = this;
            var ajaxRequestsRunning = 0;
            return function (_a) {
                var status = _a.status;
                console.log("ButterFaces.WaitingPanel.onEvent - processEvent: " + status);
                if (status === "begin") {
                    ajaxRequestsRunning++;
                }
                else if (status === "success") {
                    ajaxRequestsRunning--;
                }
                if (ajaxRequestsRunning > 0) {
                    console.log("ButterFaces.WaitingPanel.onEvent  - show " + ajaxRequestsRunning);
                    _this.overlay.show();
                }
                else {
                    console.log("ButterFaces.WaitingPanel.onEvent  - hide " + ajaxRequestsRunning);
                    _this.overlay.hide();
                }
            };
        };
        WaitingPanel.prototype.processOnError = function (data) {
            if (data) {
                console.error("ButterFaces.WaitingPanel.onError  - An error occured, closing waiting panel. errorType: " + data.status + ", description: " + data.description);
                ButterFaces.Overlay.hideAll();
            }
        };
        return WaitingPanel;
    }());
    ButterFaces.WaitingPanel = WaitingPanel;
})(ButterFaces || (ButterFaces = {}));
(function ($) {
    // extend jQuery --------------------------------------------------------------------
    var eventRegistered = false;
    var overlay;
    $.fn.waitingPanel = function (_a) {
        var waitingPanelDelay = _a.waitingPanelDelay, blockpage = _a.blockpage;
        return this.each(function () {
            // I found no way to remove event listener from jsf js.
            // I tried to register a callback once and change it on render waiting panel but after this
            // no waiting panel appears anymore.
            // Actually on each rendering of this component a new callback is put on event listener collection.
            if (!eventRegistered) {
                // console.log("waitingPanel - register: " + _elementId);
                overlay = new ButterFaces.Overlay(waitingPanelDelay, blockpage);
                var waitingPanel = new ButterFaces.WaitingPanel(overlay);
                jsf.ajax.addOnEvent(waitingPanel.processAjaxUpdate());
                jsf.ajax.addOnError(waitingPanel.processOnError);
                eventRegistered = true;
            }
            overlay.delay = waitingPanelDelay;
            overlay.isTransparentBlockingOverlayActive = blockpage;
        });
    };
}(jQuery));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
