///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var CommandLink = /** @class */ (function () {
        function CommandLink() {
        }
        CommandLink.disableOnClick = function (data, showDots, linkText, linkProcessingText, linkGlyphicon, linkProcessingGlyphicon, hideGlyphicon, disableRenderRegionsIds) {
            var status = data.type === "error" ? "error" : data.status;
            // console.log(data.source.id);
            var $commandLink = $(document.getElementById(data.source.id));
            switch (status) {
                case "begin": // Before the ajax request is sent.
                    // console.log('ajax request begin');
                    $commandLink.addClass("disabled");
                    var $glyphicon = $commandLink.find(".butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphicon.hide();
                    }
                    if (linkProcessingGlyphicon.length > 0) {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-glyphicon butter-component-processing-spinner");
                        $glyphicon.addClass(linkProcessingGlyphicon);
                        if (linkProcessingText.length > 0 && linkGlyphicon.length === 0) {
                            // glyphicon only appears on ajax request
                            $glyphicon.addClass("butter-component-glyphicon-width-margin");
                        }
                    }
                    else {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-spinner tiny butter-component-processing-spinner");
                    }
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").startDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "inline-block");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkProcessingText);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Disable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).show();
                    }
                    break;
                case "complete": // After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                case "error": // After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    $commandLink.removeClass("disabled");
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").stopDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "none");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkText ? linkText : "");
                    }
                    var $glyphiconError = $commandLink.find(".butter-component-processing-spinner");
                    $glyphiconError.removeAttr("class");
                    $glyphiconError.addClass("butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphiconError.show();
                    }
                    if (linkGlyphicon.length > 0) {
                        $glyphiconError.addClass(linkGlyphicon);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Enable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).hide();
                    }
                    break;
            }
        };
        /**
         * Submit given form.
         * @param formId the target form id to submit
         * @param params a list of params to be added to form as hidden input fields
         * @param target the target of the form submission
         */
        CommandLink.submitForm = function (formId, params, target) {
            var form = document.getElementById(formId);
            ButterFaces.CommandLink.addParametersAsHiddenFieldsToForm(form, params);
            var oldFormTarget = ButterFaces.CommandLink.setFormTarget(form, target);
            if (form.onsubmit) {
                var result = form.onsubmit();
                if (ButterFaces.ObjectStatics.isNullOrUndefined(result) || result) {
                    form.submit();
                }
            }
            else {
                form.submit();
            }
            form.target = oldFormTarget;
            ButterFaces.CommandLink.removeHiddenFieldsFromForm(form);
        };
        CommandLink.addParametersAsHiddenFieldsToForm = function (form, params) {
            var bfHiddenInputFields = [];
            form.bfHiddenInputFields = bfHiddenInputFields;
            var i = 0;
            for (var k in params) {
                if (params.hasOwnProperty(k)) {
                    var p = document.createElement("input");
                    p.type = "hidden";
                    p.name = k;
                    p.value = params[k];
                    form.appendChild(p);
                    bfHiddenInputFields[i++] = p;
                }
            }
        };
        CommandLink.removeHiddenFieldsFromForm = function (form) {
            var bfHiddenInputFields = form.bfHiddenInputFields;
            if (bfHiddenInputFields !== null) {
                for (var i = 0; i < bfHiddenInputFields.length; i++) {
                    form.removeChild(bfHiddenInputFields[i]);
                }
            }
        };
        /**
         * Updates form target (if exists) and returns previous form target
         * @param form the torm to add the new target to
         * @param target the target to add (if not null)
         * @return the previous form target
         */
        CommandLink.setFormTarget = function (form, target) {
            var previousTarget = form.target;
            if (target) {
                form.target = target;
            }
            return previousTarget;
        };
        return CommandLink;
    }());
    ButterFaces.CommandLink = CommandLink;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
