///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * jQuery-Plugin "Expanded TextAreas" for expandable text areas. It is used for the JSF-Component "b:textarea".
 * Works with at least jQuery 1.7.
 *
 * How to use:
 * jQuery("#someTextAreaSelector").butterExpandable();
 */
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterExpandable"] = function () {
        return this.each(function (index, element) {
            var rootElement = $(element);
            if (rootElement.find("textarea").length > 0) {
                new ButterFaces.TextareaExpandable(rootElement);
            }
            else {
                new ButterFaces.DivExpandable(rootElement);
            }
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var EXPAND_HEIGHT = 250; //in px
    var EXPAND_WIDTH = 500; //in px
    var ANIMATION_DURATION = 200; //in ms
    var REPOSITION_INTERVAL = 500; //in ms
    var EASING = "swing";
    var KEYCODE_ESCAPE = 27;
    var AbstractExpandable = /** @class */ (function () {
        function AbstractExpandable(rootElement) {
            this.rootElement = rootElement;
        }
        AbstractExpandable.prototype.expandElement = function (event) {
            var _this = this;
            if (this.isExpansionEventIgnored(event)) {
                return;
            }
            this.initialHeight = this.originalElement.outerHeight();
            this.initialWidth = this.originalElement.outerWidth();
            this.initialOffset = this.originalElement.offset();
            //create a ghost element that be animated on gets the focus
            this.ghostElement = this.createGhostElement();
            this.transferValueToGhostElement();
            this.ghostElement.css("width", this.initialWidth)
                .css("height", this.initialHeight)
                .css("position", "absolute")
                .css("top", this.initialOffset.top)
                .css("left", this.initialOffset.left)
                .css("z-index", 2000)
                .css("box-shadow", "5px 5px 5px 0 #999")
                .addClass("butter-component-expandable-ghost")
                .appendTo($("body"))
                .animate({
                height: EXPAND_HEIGHT,
                width: this.initialWidth > EXPAND_WIDTH ? this.initialWidth : EXPAND_WIDTH
            }, ANIMATION_DURATION, EASING, function () {
                $(document)
                    .on("click.expandable", function (event) {
                    _this.handleMouseClick(event);
                })
                    .on("keydown.expandable", function (event) {
                    _this.handleEscapeKey(event);
                });
                $(window).on("resize.expandable", function () {
                    _this.repositionGhostElement();
                });
                //keep track of the orginal element"s position
                _this.positionTriggerInterval = window.setInterval(function () { return _this.repositionGhostElement; }, REPOSITION_INTERVAL);
            });
            //make original invisible
            this.originalElement
                .css("visibility", "hidden")
                .siblings()
                .css("visibility", "hidden");
            this.onGhostElementCreated();
        };
        /**
         * Collapses the ghost element and sets the value if not isCancelled
         * @param isCancelled
         */
        AbstractExpandable.prototype.collapseElement = function (cancelled) {
            // "cancelled" can be an event object
            var isCancelled = typeof cancelled === "boolean" && cancelled;
            $(document)
                .off("click.expandable")
                .off("keydown.expandable");
            //make original visible again
            this.originalElement
                .css("visibility", "visible")
                .siblings()
                .css("visibility", "visible");
            var self = this;
            this.ghostElement.animate({
                height: self.initialHeight,
                width: self.initialWidth
            }, ANIMATION_DURATION, EASING, function () {
                //on animation complete
                self.onGhostElementCollapsed(isCancelled);
                //delete the ghost element
                self.ghostElement.remove();
                self.ghostElement = null;
                //delete position trigger timeout and resize listener
                window.clearInterval(self.positionTriggerInterval);
                $(window).off("resize.expandable");
            });
        };
        AbstractExpandable.prototype.handleMouseClick = function (event) {
            // collapse ghost element if user clicks beside it
            if (!$(event.target).is(".butter-component-expandable-ghost")) {
                this.collapseElement(false);
            }
        };
        AbstractExpandable.prototype.handleEscapeKey = function (event) {
            if (event.which === KEYCODE_ESCAPE) {
                this.collapseElement(true);
            }
        };
        AbstractExpandable.prototype.repositionGhostElement = function () {
            //keep track of window resizing and reposition the ghost element
            if (this.ghostElement !== undefined && this.ghostElement != null) {
                this.initialOffset = this.originalElement.offset();
                this.ghostElement
                    .css("top", this.initialOffset.top)
                    .css("left", this.initialOffset.left);
            }
        };
        return AbstractExpandable;
    }());
    var DivExpandable = /** @class */ (function (_super) {
        __extends(DivExpandable, _super);
        function DivExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.originalElement = _this.rootElement.find(".butter-component-value-readonly");
            _this.rearrangeOriginalElementStructure();
            return _this;
        }
        DivExpandable.prototype.rearrangeOriginalElementStructure = function () {
            var _this = this;
            var _label = this.rootElement.find(".butter-component-label");
            this.originalElement
                .addClass("butter-component-expandable-original")
                .click(function (event) {
                _this.expandElement(event);
            })
                .detach();
            var _container = $("<div>")
                .addClass("butter-component-expandable-readonly-container")
                .insertAfter(_label);
            var _icon = $("<span>").addClass("input-group-text glyphicon glyphicon-resize-full");
            this.originalElement.appendTo(_container);
            $("<div>")
                .addClass("butter-component-expandable-readonly-icon")
                .append(_icon)
                .appendTo(_container);
        };
        DivExpandable.prototype.createGhostElement = function () {
            return $("<div>");
        };
        DivExpandable.prototype.isExpansionEventIgnored = function (event) {
            return false;
        };
        DivExpandable.prototype.onGhostElementCreated = function () {
            // do nothing
        };
        DivExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            // do nothing
        };
        DivExpandable.prototype.transferValueToGhostElement = function () {
            $("<div>")
                .html(this.originalElement.html())
                .addClass("butter-component-expandable-ghost-readonlyContent")
                .appendTo(this.ghostElement);
        };
        return DivExpandable;
    }(AbstractExpandable));
    ButterFaces.DivExpandable = DivExpandable;
    var TextareaExpandable = /** @class */ (function (_super) {
        __extends(TextareaExpandable, _super);
        function TextareaExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.blockFocusEventOnOriginal = false;
            _this.blockBlurEventOnOriginal = false;
            _this.originalElement = _this.rootElement.find("textarea");
            _this.originalElement.addClass("butter-component-expandable-original");
            _this.originalElement.focus(function (event) {
                _this.expandElement(event);
            });
            _this.originalElement.blur(function (event) {
                _this.handleBlurEvent(event);
            });
            _this.addInputGroupAddon();
            return _this;
        }
        TextareaExpandable.prototype.addInputGroupAddon = function () {
            this.originalElement
                .addClass("form-control")
                .parent()
                .addClass("input-group");
            $("<span class=\"input-group-append\"><span class=\"input-group-text glyphicon glyphicon-resize-full\"></span></span>")
                .insertAfter(this.originalElement);
        };
        TextareaExpandable.prototype.handleBlurEvent = function (event) {
            if (this.blockBlurEventOnOriginal) {
                // prevent blur event bubbling, so it will not be triggered in jsf
                event.preventDefault();
            }
        };
        TextareaExpandable.prototype.createGhostElement = function () {
            return $("<textarea>");
        };
        TextareaExpandable.prototype.isExpansionEventIgnored = function (event) {
            this.blockBlurEventOnOriginal = true;
            if (this.blockFocusEventOnOriginal) {
                event.preventDefault();
                return true;
            }
            else {
                return false;
            }
        };
        TextareaExpandable.prototype.onGhostElementCreated = function () {
            var _this = this;
            this.ghostElement
                .blur(function (event) {
                _this.collapseElement(event);
            })
                .focus();
            this.moveCaretToEnd(this.ghostElement);
        };
        TextareaExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            var _this = this;
            if (!isCancelled) {
                //transfer value back from ghost to original
                this.originalElement.val(this.ghostElement.val());
                // trigger blur and keyup event on original textarea and don"t block
                // it for jsf
                this.blockBlurEventOnOriginal = false;
                this.blockFocusEventOnOriginal = true;
                // defer the events a little bit, look at
                // (http://stackoverflow.com/questions/8380759/why-isnt-this-textarea-focusing-with-focus#8380785)
                window.setTimeout(function () {
                    _this.originalElement.trigger("keyup");
                    _this.originalElement.trigger("change");
                    _this.originalElement.trigger("blur");
                    _this.blockFocusEventOnOriginal = false;
                }, 50);
            }
            else {
                this.blockBlurEventOnOriginal = true;
                this.blockFocusEventOnOriginal = false;
            }
        };
        TextareaExpandable.prototype.transferValueToGhostElement = function () {
            this.ghostElement.val(this.originalElement.val());
        };
        TextareaExpandable.prototype.moveCaretToEnd = function (element) {
            if (typeof element.selectionStart === "number") {
                element.selectionStart = element.selectionEnd = element.value.length;
            }
            else if (typeof element.createTextRange !== "undefined") {
                var range = element.createTextRange();
                range.collapse(false);
                range.select();
            }
            else {
                var strLength = this.ghostElement.val().length * 2;
                this.ghostElement.get(0).setSelectionRange(strLength, strLength);
            }
        };
        return TextareaExpandable;
    }(AbstractExpandable));
    ButterFaces.TextareaExpandable = TextareaExpandable;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJ1dHRlcmZhY2VzLWV4cGFuZGFibGUuanF1ZXJ5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLGtFQUFrRTs7Ozs7Ozs7Ozs7Ozs7QUFFbEU7Ozs7OztHQU1HO0FBQ0gsQ0FBQyxVQUFVLENBQWU7SUFDdEIsc0dBQXNHO0lBQ3RHLG9EQUFvRDtJQUNwRCxDQUFDLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLEdBQUc7UUFDdkIsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQUMsS0FBSyxFQUFFLE9BQU87WUFDNUIsSUFBSSxXQUFXLEdBQVcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ3JDLElBQUksV0FBVyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO2dCQUN6QyxJQUFJLFdBQVcsQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQzthQUNuRDtpQkFBTTtnQkFDSCxJQUFJLFdBQVcsQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUFDLENBQUM7YUFDOUM7UUFDTCxDQUFDLENBQUMsQ0FBQztJQUNQLENBQUMsQ0FBQztBQUNOLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRVgsSUFBVSxXQUFXLENBa1RwQjtBQWxURCxXQUFVLFdBQVc7SUFFakIsSUFBTSxhQUFhLEdBQVcsR0FBRyxDQUFDLENBQUMsT0FBTztJQUMxQyxJQUFNLFlBQVksR0FBVyxHQUFHLENBQUMsQ0FBQyxPQUFPO0lBQ3pDLElBQU0sa0JBQWtCLEdBQVcsR0FBRyxDQUFDLENBQUMsT0FBTztJQUMvQyxJQUFNLG1CQUFtQixHQUFXLEdBQUcsQ0FBQyxDQUFDLE9BQU87SUFDaEQsSUFBTSxNQUFNLEdBQVcsT0FBTyxDQUFDO0lBQy9CLElBQU0sY0FBYyxHQUFXLEVBQUUsQ0FBQztJQUVsQztRQVdJLDRCQUFZLFdBQW1CO1lBQzNCLElBQUksQ0FBQyxXQUFXLEdBQUcsV0FBVyxDQUFDO1FBQ25DLENBQUM7UUFZRCwwQ0FBYSxHQUFiLFVBQWMsS0FBVTtZQUF4QixpQkFnREM7WUEvQ0csSUFBSSxJQUFJLENBQUMsdUJBQXVCLENBQUMsS0FBSyxDQUFDLEVBQUU7Z0JBQ3JDLE9BQU87YUFDVjtZQUVELElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUN4RCxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDdEQsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLE1BQU0sRUFBRSxDQUFDO1lBRW5ELDJEQUEyRDtZQUMzRCxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQzlDLElBQUksQ0FBQywyQkFBMkIsRUFBRSxDQUFDO1lBQ25DLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDO2lCQUM1QyxHQUFHLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUM7aUJBQ2pDLEdBQUcsQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDO2lCQUMzQixHQUFHLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDO2lCQUNsQyxHQUFHLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO2lCQUNwQyxHQUFHLENBQUMsU0FBUyxFQUFFLElBQUksQ0FBQztpQkFDcEIsR0FBRyxDQUFDLFlBQVksRUFBRSxvQkFBb0IsQ0FBQztpQkFDdkMsUUFBUSxDQUFDLG1DQUFtQyxDQUFDO2lCQUM3QyxRQUFRLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO2lCQUNuQixPQUFPLENBQUM7Z0JBQ0wsTUFBTSxFQUFFLGFBQWE7Z0JBQ3JCLEtBQUssRUFBRSxJQUFJLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWTthQUM3RSxFQUFFLGtCQUFrQixFQUFFLE1BQU0sRUFBRTtnQkFDM0IsQ0FBQyxDQUFDLFFBQVEsQ0FBQztxQkFDTixFQUFFLENBQUMsa0JBQWtCLEVBQUUsVUFBQSxLQUFLO29CQUN6QixLQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQ2pDLENBQUMsQ0FBQztxQkFDRCxFQUFFLENBQUMsb0JBQW9CLEVBQUUsVUFBQSxLQUFLO29CQUMzQixLQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxDQUFDO2dCQUNoQyxDQUFDLENBQUMsQ0FBQztnQkFFUCxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLG1CQUFtQixFQUFFO29CQUM5QixLQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQztnQkFDbEMsQ0FBQyxDQUFDLENBQUM7Z0JBRUgsOENBQThDO2dCQUM5QyxLQUFJLENBQUMsdUJBQXVCLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQyxjQUFNLE9BQUEsS0FBSSxDQUFDLHNCQUFzQixFQUEzQixDQUEyQixFQUFFLG1CQUFtQixDQUFDLENBQUM7WUFDOUcsQ0FBQyxDQUFDLENBQUM7WUFFUCx5QkFBeUI7WUFDekIsSUFBSSxDQUFDLGVBQWU7aUJBQ2YsR0FBRyxDQUFDLFlBQVksRUFBRSxRQUFRLENBQUM7aUJBQzNCLFFBQVEsRUFBRTtpQkFDVixHQUFHLENBQUMsWUFBWSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1lBRWpDLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO1FBQ2pDLENBQUM7UUFFRDs7O1dBR0c7UUFDSCw0Q0FBZSxHQUFmLFVBQWdCLFNBQWM7WUFDMUIscUNBQXFDO1lBQ3JDLElBQUksV0FBVyxHQUFHLE9BQU8sU0FBUyxLQUFLLFNBQVMsSUFBSSxTQUFTLENBQUM7WUFFOUQsQ0FBQyxDQUFDLFFBQVEsQ0FBQztpQkFDTixHQUFHLENBQUMsa0JBQWtCLENBQUM7aUJBQ3ZCLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1lBRS9CLDZCQUE2QjtZQUM3QixJQUFJLENBQUMsZUFBZTtpQkFDZixHQUFHLENBQUMsWUFBWSxFQUFFLFNBQVMsQ0FBQztpQkFDNUIsUUFBUSxFQUFFO2lCQUNWLEdBQUcsQ0FBQyxZQUFZLEVBQUUsU0FBUyxDQUFDLENBQUM7WUFFbEMsSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDO1lBQ2hCLElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDO2dCQUN0QixNQUFNLEVBQUUsSUFBSSxDQUFDLGFBQWE7Z0JBQzFCLEtBQUssRUFBRSxJQUFJLENBQUMsWUFBWTthQUMzQixFQUFFLGtCQUFrQixFQUFFLE1BQU0sRUFBRTtnQkFDM0IsdUJBQXVCO2dCQUV2QixJQUFJLENBQUMsdUJBQXVCLENBQUMsV0FBVyxDQUFDLENBQUM7Z0JBRTFDLDBCQUEwQjtnQkFDMUIsSUFBSSxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDM0IsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUM7Z0JBRXpCLHFEQUFxRDtnQkFDckQsTUFBTSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsdUJBQXVCLENBQUMsQ0FBQztnQkFDbkQsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1lBQ3ZDLENBQUMsQ0FBQyxDQUFDO1FBQ1AsQ0FBQztRQUVPLDZDQUFnQixHQUF4QixVQUF5QixLQUFVO1lBQy9CLGtEQUFrRDtZQUNsRCxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsRUFBRTtnQkFDM0QsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsQ0FBQzthQUMvQjtRQUNMLENBQUM7UUFFTyw0Q0FBZSxHQUF2QixVQUF3QixLQUFVO1lBQzlCLElBQUksS0FBSyxDQUFDLEtBQUssS0FBSyxjQUFjLEVBQUU7Z0JBQ2hDLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLENBQUM7YUFDOUI7UUFDTCxDQUFDO1FBRU8sbURBQXNCLEdBQTlCO1lBQ0ksZ0VBQWdFO1lBQ2hFLElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLElBQUksSUFBSSxDQUFDLFlBQVksSUFBSSxJQUFJLEVBQUU7Z0JBQzlELElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDbkQsSUFBSSxDQUFDLFlBQVk7cUJBQ1osR0FBRyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQztxQkFDbEMsR0FBRyxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQzdDO1FBQ0wsQ0FBQztRQUNMLHlCQUFDO0lBQUQsQ0F0SUEsQUFzSUMsSUFBQTtJQUVEO1FBQW1DLGlDQUFrQjtRQUVqRCx1QkFBWSxXQUFtQjtZQUEvQixZQUNJLGtCQUFNLFdBQVcsQ0FBQyxTQUdyQjtZQUZHLEtBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsa0NBQWtDLENBQUMsQ0FBQztZQUNqRixLQUFJLENBQUMsaUNBQWlDLEVBQUUsQ0FBQzs7UUFDN0MsQ0FBQztRQUVPLHlEQUFpQyxHQUF6QztZQUFBLGlCQXFCQztZQXBCRyxJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO1lBRTlELElBQUksQ0FBQyxlQUFlO2lCQUNmLFFBQVEsQ0FBQyxzQ0FBc0MsQ0FBQztpQkFDaEQsS0FBSyxDQUFDLFVBQUEsS0FBSztnQkFDUixLQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQzlCLENBQUMsQ0FBQztpQkFDRCxNQUFNLEVBQUUsQ0FBQztZQUVkLElBQUksVUFBVSxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUM7aUJBQ3RCLFFBQVEsQ0FBQyxnREFBZ0QsQ0FBQztpQkFDMUQsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBRXpCLElBQUksS0FBSyxHQUFHLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxRQUFRLENBQUMsa0RBQWtELENBQUMsQ0FBQztZQUVyRixJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUMxQyxDQUFDLENBQUMsT0FBTyxDQUFDO2lCQUNMLFFBQVEsQ0FBQywyQ0FBMkMsQ0FBQztpQkFDckQsTUFBTSxDQUFDLEtBQUssQ0FBQztpQkFDYixRQUFRLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDOUIsQ0FBQztRQUVELDBDQUFrQixHQUFsQjtZQUNJLE9BQU8sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3RCLENBQUM7UUFFRCwrQ0FBdUIsR0FBdkIsVUFBd0IsS0FBVTtZQUM5QixPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO1FBRUQsNkNBQXFCLEdBQXJCO1lBQ0ksYUFBYTtRQUNqQixDQUFDO1FBRUQsK0NBQXVCLEdBQXZCLFVBQXdCLFdBQW9CO1lBQ3hDLGFBQWE7UUFDakIsQ0FBQztRQUVELG1EQUEyQixHQUEzQjtZQUNJLENBQUMsQ0FBQyxPQUFPLENBQUM7aUJBQ0wsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLENBQUM7aUJBQ2pDLFFBQVEsQ0FBQyxtREFBbUQsQ0FBQztpQkFDN0QsUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUNyQyxDQUFDO1FBRUwsb0JBQUM7SUFBRCxDQXREQSxBQXNEQyxDQXREa0Msa0JBQWtCLEdBc0RwRDtJQXREWSx5QkFBYSxnQkFzRHpCLENBQUE7SUFFRDtRQUF3QyxzQ0FBa0I7UUFLdEQsNEJBQVksV0FBbUI7WUFBL0IsWUFDSSxrQkFBTSxXQUFXLENBQUMsU0FnQnJCO1lBZEcsS0FBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQztZQUN2QyxLQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO1lBRXRDLEtBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7WUFDekQsS0FBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsc0NBQXNDLENBQUMsQ0FBQztZQUV0RSxLQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxVQUFBLEtBQUs7Z0JBQzVCLEtBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDOUIsQ0FBQyxDQUFDLENBQUM7WUFDSCxLQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxVQUFBLEtBQUs7Z0JBQzNCLEtBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDaEMsQ0FBQyxDQUFDLENBQUM7WUFFSCxLQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQzs7UUFDOUIsQ0FBQztRQUVPLCtDQUFrQixHQUExQjtZQUNJLElBQUksQ0FBQyxlQUFlO2lCQUNmLFFBQVEsQ0FBQyxjQUFjLENBQUM7aUJBQ3hCLE1BQU0sRUFBRTtpQkFDUixRQUFRLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDN0IsQ0FBQyxDQUFDLG9IQUFvSCxDQUFDO2lCQUNsSCxXQUFXLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQzNDLENBQUM7UUFFTyw0Q0FBZSxHQUF2QixVQUF3QixLQUFVO1lBQzlCLElBQUksSUFBSSxDQUFDLHdCQUF3QixFQUFFO2dCQUMvQixrRUFBa0U7Z0JBQ2xFLEtBQUssQ0FBQyxjQUFjLEVBQUUsQ0FBQzthQUMxQjtRQUNMLENBQUM7UUFFRCwrQ0FBa0IsR0FBbEI7WUFDSSxPQUFPLENBQUMsQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUMzQixDQUFDO1FBRUQsb0RBQXVCLEdBQXZCLFVBQXdCLEtBQVU7WUFDOUIsSUFBSSxDQUFDLHdCQUF3QixHQUFHLElBQUksQ0FBQztZQUNyQyxJQUFJLElBQUksQ0FBQyx5QkFBeUIsRUFBRTtnQkFDaEMsS0FBSyxDQUFDLGNBQWMsRUFBRSxDQUFDO2dCQUN2QixPQUFPLElBQUksQ0FBQzthQUNmO2lCQUFNO2dCQUNILE9BQU8sS0FBSyxDQUFDO2FBQ2hCO1FBQ0wsQ0FBQztRQUVELGtEQUFxQixHQUFyQjtZQUFBLGlCQU9DO1lBTkcsSUFBSSxDQUFDLFlBQVk7aUJBQ1osSUFBSSxDQUFDLFVBQUEsS0FBSztnQkFDUCxLQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2hDLENBQUMsQ0FBQztpQkFDRCxLQUFLLEVBQUUsQ0FBQztZQUNiLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQzNDLENBQUM7UUFFRCxvREFBdUIsR0FBdkIsVUFBd0IsV0FBb0I7WUFBNUMsaUJBcUJDO1lBcEJHLElBQUksQ0FBQyxXQUFXLEVBQUU7Z0JBQ2QsNENBQTRDO2dCQUM1QyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUM7Z0JBRWxELG9FQUFvRTtnQkFDcEUsYUFBYTtnQkFDYixJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO2dCQUN0QyxJQUFJLENBQUMseUJBQXlCLEdBQUcsSUFBSSxDQUFDO2dCQUN0Qyx5Q0FBeUM7Z0JBQ3pDLGtHQUFrRztnQkFDbEcsTUFBTSxDQUFDLFVBQVUsQ0FBQztvQkFDZCxLQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQztvQkFDdEMsS0FBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUM7b0JBQ3ZDLEtBQUksQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO29CQUNyQyxLQUFJLENBQUMseUJBQXlCLEdBQUcsS0FBSyxDQUFDO2dCQUMzQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7YUFDVjtpQkFBTTtnQkFDSCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsSUFBSSxDQUFDO2dCQUNyQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsS0FBSyxDQUFDO2FBQzFDO1FBQ0wsQ0FBQztRQUVELHdEQUEyQixHQUEzQjtZQUNJLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUN0RCxDQUFDO1FBRU8sMkNBQWMsR0FBdEIsVUFBdUIsT0FBWTtZQUMvQixJQUFJLE9BQU8sT0FBTyxDQUFDLGNBQWMsS0FBSyxRQUFRLEVBQUU7Z0JBQzVDLE9BQU8sQ0FBQyxjQUFjLEdBQUcsT0FBTyxDQUFDLFlBQVksR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQzthQUN4RTtpQkFBTSxJQUFJLE9BQU8sT0FBTyxDQUFDLGVBQWUsS0FBSyxXQUFXLEVBQUU7Z0JBQ3ZELElBQUksS0FBSyxHQUFHLE9BQU8sQ0FBQyxlQUFlLEVBQUUsQ0FBQztnQkFDdEMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztnQkFDdEIsS0FBSyxDQUFDLE1BQU0sRUFBRSxDQUFDO2FBQ2xCO2lCQUFNO2dCQUNILElBQUksU0FBUyxHQUFZLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxFQUFHLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQztnQkFDMUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFFLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsQ0FBQyxDQUFDO2FBQ3hGO1FBRUwsQ0FBQztRQUVMLHlCQUFDO0lBQUQsQ0F4R0EsQUF3R0MsQ0F4R3VDLGtCQUFrQixHQXdHekQ7SUF4R1ksOEJBQWtCLHFCQXdHOUIsQ0FBQTtBQUNMLENBQUMsRUFsVFMsV0FBVyxLQUFYLFdBQVcsUUFrVHBCIiwiZmlsZSI6ImJ1dHRlcmZhY2VzLWV4cGFuZGFibGUuanF1ZXJ5LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8vPHJlZmVyZW5jZSBwYXRoPVwiLi4vLi4vbm9kZV9tb2R1bGVzL0B0eXBlcy9qcXVlcnkvaW5kZXguZC50c1wiLz5cblxuLyoqXG4gKiBqUXVlcnktUGx1Z2luIFwiRXhwYW5kZWQgVGV4dEFyZWFzXCIgZm9yIGV4cGFuZGFibGUgdGV4dCBhcmVhcy4gSXQgaXMgdXNlZCBmb3IgdGhlIEpTRi1Db21wb25lbnQgXCJiOnRleHRhcmVhXCIuXG4gKiBXb3JrcyB3aXRoIGF0IGxlYXN0IGpRdWVyeSAxLjcuXG4gKlxuICogSG93IHRvIHVzZTpcbiAqIGpRdWVyeShcIiNzb21lVGV4dEFyZWFTZWxlY3RvclwiKS5idXR0ZXJFeHBhbmRhYmxlKCk7XG4gKi9cbihmdW5jdGlvbiAoJDogSlF1ZXJ5U3RhdGljKSB7XG4gICAgLy8geW91IGhhdmUgdG8gZXh0ZW5kIGpRdWVyeSB3aXRoIHRoZSBmbltcInBsdWdpbk5hbWVcIl0gbm90YXRpb24gYmVjYXVzZSBpbiBUeXBlc2NyaXB0IHlvdSBjYW4ndCBleHRlbmRcbiAgICAvLyB0aGUgZXhpc3RpbmcgdHlwaW5nIGludGVyZmFjZSB3aXRoIGZuLnBsdWdpbk5hbWUhXG4gICAgJC5mbltcImJ1dHRlckV4cGFuZGFibGVcIl0gPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgIHJldHVybiB0aGlzLmVhY2goKGluZGV4LCBlbGVtZW50KSA9PiB7XG4gICAgICAgICAgICBsZXQgcm9vdEVsZW1lbnQ6IEpRdWVyeSA9ICQoZWxlbWVudCk7XG4gICAgICAgICAgICBpZiAocm9vdEVsZW1lbnQuZmluZChcInRleHRhcmVhXCIpLmxlbmd0aCA+IDApIHtcbiAgICAgICAgICAgICAgICBuZXcgQnV0dGVyRmFjZXMuVGV4dGFyZWFFeHBhbmRhYmxlKHJvb3RFbGVtZW50KTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgbmV3IEJ1dHRlckZhY2VzLkRpdkV4cGFuZGFibGUocm9vdEVsZW1lbnQpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KTtcbiAgICB9O1xufSkoalF1ZXJ5KTtcblxubmFtZXNwYWNlIEJ1dHRlckZhY2VzIHtcblxuICAgIGNvbnN0IEVYUEFORF9IRUlHSFQ6IG51bWJlciA9IDI1MDsgLy9pbiBweFxuICAgIGNvbnN0IEVYUEFORF9XSURUSDogbnVtYmVyID0gNTAwOyAvL2luIHB4XG4gICAgY29uc3QgQU5JTUFUSU9OX0RVUkFUSU9OOiBudW1iZXIgPSAyMDA7IC8vaW4gbXNcbiAgICBjb25zdCBSRVBPU0lUSU9OX0lOVEVSVkFMOiBudW1iZXIgPSA1MDA7IC8vaW4gbXNcbiAgICBjb25zdCBFQVNJTkc6IHN0cmluZyA9IFwic3dpbmdcIjtcbiAgICBjb25zdCBLRVlDT0RFX0VTQ0FQRTogbnVtYmVyID0gMjc7XG5cbiAgICBhYnN0cmFjdCBjbGFzcyBBYnN0cmFjdEV4cGFuZGFibGUge1xuXG4gICAgICAgIHJvb3RFbGVtZW50OiBKUXVlcnk7XG5cbiAgICAgICAgZ2hvc3RFbGVtZW50OiBKUXVlcnk7XG4gICAgICAgIG9yaWdpbmFsRWxlbWVudDogSlF1ZXJ5O1xuICAgICAgICBpbml0aWFsSGVpZ2h0OiBudW1iZXI7XG4gICAgICAgIGluaXRpYWxXaWR0aDogbnVtYmVyO1xuICAgICAgICBpbml0aWFsT2Zmc2V0OiBKUXVlcnkuQ29vcmRpbmF0ZXM7XG4gICAgICAgIHBvc2l0aW9uVHJpZ2dlckludGVydmFsOiBudW1iZXI7XG5cbiAgICAgICAgY29uc3RydWN0b3Iocm9vdEVsZW1lbnQ6IEpRdWVyeSkge1xuICAgICAgICAgICAgdGhpcy5yb290RWxlbWVudCA9IHJvb3RFbGVtZW50O1xuICAgICAgICB9XG5cbiAgICAgICAgYWJzdHJhY3QgY3JlYXRlR2hvc3RFbGVtZW50KCk6IEpRdWVyeTtcblxuICAgICAgICBhYnN0cmFjdCBpc0V4cGFuc2lvbkV2ZW50SWdub3JlZChldmVudDogYW55KTogYm9vbGVhbjtcblxuICAgICAgICBhYnN0cmFjdCBvbkdob3N0RWxlbWVudENyZWF0ZWQoKTogdm9pZDtcblxuICAgICAgICBhYnN0cmFjdCBvbkdob3N0RWxlbWVudENvbGxhcHNlZChpc0NhbmNlbGxlZDogYm9vbGVhbik6IHZvaWQ7XG5cbiAgICAgICAgYWJzdHJhY3QgdHJhbnNmZXJWYWx1ZVRvR2hvc3RFbGVtZW50KCk6IHZvaWQ7XG5cbiAgICAgICAgZXhwYW5kRWxlbWVudChldmVudDogYW55KTogdm9pZCB7XG4gICAgICAgICAgICBpZiAodGhpcy5pc0V4cGFuc2lvbkV2ZW50SWdub3JlZChldmVudCkpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIHRoaXMuaW5pdGlhbEhlaWdodCA9IHRoaXMub3JpZ2luYWxFbGVtZW50Lm91dGVySGVpZ2h0KCk7XG4gICAgICAgICAgICB0aGlzLmluaXRpYWxXaWR0aCA9IHRoaXMub3JpZ2luYWxFbGVtZW50Lm91dGVyV2lkdGgoKTtcbiAgICAgICAgICAgIHRoaXMuaW5pdGlhbE9mZnNldCA9IHRoaXMub3JpZ2luYWxFbGVtZW50Lm9mZnNldCgpO1xuXG4gICAgICAgICAgICAvL2NyZWF0ZSBhIGdob3N0IGVsZW1lbnQgdGhhdCBiZSBhbmltYXRlZCBvbiBnZXRzIHRoZSBmb2N1c1xuICAgICAgICAgICAgdGhpcy5naG9zdEVsZW1lbnQgPSB0aGlzLmNyZWF0ZUdob3N0RWxlbWVudCgpO1xuICAgICAgICAgICAgdGhpcy50cmFuc2ZlclZhbHVlVG9HaG9zdEVsZW1lbnQoKTtcbiAgICAgICAgICAgIHRoaXMuZ2hvc3RFbGVtZW50LmNzcyhcIndpZHRoXCIsIHRoaXMuaW5pdGlhbFdpZHRoKVxuICAgICAgICAgICAgICAgIC5jc3MoXCJoZWlnaHRcIiwgdGhpcy5pbml0aWFsSGVpZ2h0KVxuICAgICAgICAgICAgICAgIC5jc3MoXCJwb3NpdGlvblwiLCBcImFic29sdXRlXCIpXG4gICAgICAgICAgICAgICAgLmNzcyhcInRvcFwiLCB0aGlzLmluaXRpYWxPZmZzZXQudG9wKVxuICAgICAgICAgICAgICAgIC5jc3MoXCJsZWZ0XCIsIHRoaXMuaW5pdGlhbE9mZnNldC5sZWZ0KVxuICAgICAgICAgICAgICAgIC5jc3MoXCJ6LWluZGV4XCIsIDIwMDApXG4gICAgICAgICAgICAgICAgLmNzcyhcImJveC1zaGFkb3dcIiwgXCI1cHggNXB4IDVweCAwICM5OTlcIilcbiAgICAgICAgICAgICAgICAuYWRkQ2xhc3MoXCJidXR0ZXItY29tcG9uZW50LWV4cGFuZGFibGUtZ2hvc3RcIilcbiAgICAgICAgICAgICAgICAuYXBwZW5kVG8oJChcImJvZHlcIikpXG4gICAgICAgICAgICAgICAgLmFuaW1hdGUoe1xuICAgICAgICAgICAgICAgICAgICBoZWlnaHQ6IEVYUEFORF9IRUlHSFQsXG4gICAgICAgICAgICAgICAgICAgIHdpZHRoOiB0aGlzLmluaXRpYWxXaWR0aCA+IEVYUEFORF9XSURUSCA/IHRoaXMuaW5pdGlhbFdpZHRoIDogRVhQQU5EX1dJRFRIXG4gICAgICAgICAgICAgICAgfSwgQU5JTUFUSU9OX0RVUkFUSU9OLCBFQVNJTkcsICgpID0+IHtcbiAgICAgICAgICAgICAgICAgICAgJChkb2N1bWVudClcbiAgICAgICAgICAgICAgICAgICAgICAgIC5vbihcImNsaWNrLmV4cGFuZGFibGVcIiwgZXZlbnQgPT4ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuaGFuZGxlTW91c2VDbGljayhldmVudCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgICAgICAgICAgLm9uKFwia2V5ZG93bi5leHBhbmRhYmxlXCIsIGV2ZW50ID0+IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmhhbmRsZUVzY2FwZUtleShldmVudCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9KTtcblxuICAgICAgICAgICAgICAgICAgICAkKHdpbmRvdykub24oXCJyZXNpemUuZXhwYW5kYWJsZVwiLCAoKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnJlcG9zaXRpb25HaG9zdEVsZW1lbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgfSk7XG5cbiAgICAgICAgICAgICAgICAgICAgLy9rZWVwIHRyYWNrIG9mIHRoZSBvcmdpbmFsIGVsZW1lbnRcInMgcG9zaXRpb25cbiAgICAgICAgICAgICAgICAgICAgdGhpcy5wb3NpdGlvblRyaWdnZXJJbnRlcnZhbCA9IHdpbmRvdy5zZXRJbnRlcnZhbCgoKSA9PiB0aGlzLnJlcG9zaXRpb25HaG9zdEVsZW1lbnQsIFJFUE9TSVRJT05fSU5URVJWQUwpO1xuICAgICAgICAgICAgICAgIH0pO1xuXG4gICAgICAgICAgICAvL21ha2Ugb3JpZ2luYWwgaW52aXNpYmxlXG4gICAgICAgICAgICB0aGlzLm9yaWdpbmFsRWxlbWVudFxuICAgICAgICAgICAgICAgIC5jc3MoXCJ2aXNpYmlsaXR5XCIsIFwiaGlkZGVuXCIpXG4gICAgICAgICAgICAgICAgLnNpYmxpbmdzKClcbiAgICAgICAgICAgICAgICAuY3NzKFwidmlzaWJpbGl0eVwiLCBcImhpZGRlblwiKTtcblxuICAgICAgICAgICAgdGhpcy5vbkdob3N0RWxlbWVudENyZWF0ZWQoKTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8qKlxuICAgICAgICAgKiBDb2xsYXBzZXMgdGhlIGdob3N0IGVsZW1lbnQgYW5kIHNldHMgdGhlIHZhbHVlIGlmIG5vdCBpc0NhbmNlbGxlZFxuICAgICAgICAgKiBAcGFyYW0gaXNDYW5jZWxsZWRcbiAgICAgICAgICovXG4gICAgICAgIGNvbGxhcHNlRWxlbWVudChjYW5jZWxsZWQ6IGFueSk6IHZvaWQge1xuICAgICAgICAgICAgLy8gXCJjYW5jZWxsZWRcIiBjYW4gYmUgYW4gZXZlbnQgb2JqZWN0XG4gICAgICAgICAgICBsZXQgaXNDYW5jZWxsZWQgPSB0eXBlb2YgY2FuY2VsbGVkID09PSBcImJvb2xlYW5cIiAmJiBjYW5jZWxsZWQ7XG5cbiAgICAgICAgICAgICQoZG9jdW1lbnQpXG4gICAgICAgICAgICAgICAgLm9mZihcImNsaWNrLmV4cGFuZGFibGVcIilcbiAgICAgICAgICAgICAgICAub2ZmKFwia2V5ZG93bi5leHBhbmRhYmxlXCIpO1xuXG4gICAgICAgICAgICAvL21ha2Ugb3JpZ2luYWwgdmlzaWJsZSBhZ2FpblxuICAgICAgICAgICAgdGhpcy5vcmlnaW5hbEVsZW1lbnRcbiAgICAgICAgICAgICAgICAuY3NzKFwidmlzaWJpbGl0eVwiLCBcInZpc2libGVcIilcbiAgICAgICAgICAgICAgICAuc2libGluZ3MoKVxuICAgICAgICAgICAgICAgIC5jc3MoXCJ2aXNpYmlsaXR5XCIsIFwidmlzaWJsZVwiKTtcblxuICAgICAgICAgICAgbGV0IHNlbGYgPSB0aGlzO1xuICAgICAgICAgICAgdGhpcy5naG9zdEVsZW1lbnQuYW5pbWF0ZSh7XG4gICAgICAgICAgICAgICAgaGVpZ2h0OiBzZWxmLmluaXRpYWxIZWlnaHQsXG4gICAgICAgICAgICAgICAgd2lkdGg6IHNlbGYuaW5pdGlhbFdpZHRoXG4gICAgICAgICAgICB9LCBBTklNQVRJT05fRFVSQVRJT04sIEVBU0lORywgZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgIC8vb24gYW5pbWF0aW9uIGNvbXBsZXRlXG5cbiAgICAgICAgICAgICAgICBzZWxmLm9uR2hvc3RFbGVtZW50Q29sbGFwc2VkKGlzQ2FuY2VsbGVkKTtcblxuICAgICAgICAgICAgICAgIC8vZGVsZXRlIHRoZSBnaG9zdCBlbGVtZW50XG4gICAgICAgICAgICAgICAgc2VsZi5naG9zdEVsZW1lbnQucmVtb3ZlKCk7XG4gICAgICAgICAgICAgICAgc2VsZi5naG9zdEVsZW1lbnQgPSBudWxsO1xuXG4gICAgICAgICAgICAgICAgLy9kZWxldGUgcG9zaXRpb24gdHJpZ2dlciB0aW1lb3V0IGFuZCByZXNpemUgbGlzdGVuZXJcbiAgICAgICAgICAgICAgICB3aW5kb3cuY2xlYXJJbnRlcnZhbChzZWxmLnBvc2l0aW9uVHJpZ2dlckludGVydmFsKTtcbiAgICAgICAgICAgICAgICAkKHdpbmRvdykub2ZmKFwicmVzaXplLmV4cGFuZGFibGVcIik7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuXG4gICAgICAgIHByaXZhdGUgaGFuZGxlTW91c2VDbGljayhldmVudDogYW55KTogdm9pZCB7XG4gICAgICAgICAgICAvLyBjb2xsYXBzZSBnaG9zdCBlbGVtZW50IGlmIHVzZXIgY2xpY2tzIGJlc2lkZSBpdFxuICAgICAgICAgICAgaWYgKCEkKGV2ZW50LnRhcmdldCkuaXMoXCIuYnV0dGVyLWNvbXBvbmVudC1leHBhbmRhYmxlLWdob3N0XCIpKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5jb2xsYXBzZUVsZW1lbnQoZmFsc2UpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgcHJpdmF0ZSBoYW5kbGVFc2NhcGVLZXkoZXZlbnQ6IGFueSk6IHZvaWQge1xuICAgICAgICAgICAgaWYgKGV2ZW50LndoaWNoID09PSBLRVlDT0RFX0VTQ0FQRSkge1xuICAgICAgICAgICAgICAgIHRoaXMuY29sbGFwc2VFbGVtZW50KHRydWUpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgcHJpdmF0ZSByZXBvc2l0aW9uR2hvc3RFbGVtZW50KCk6IHZvaWQge1xuICAgICAgICAgICAgLy9rZWVwIHRyYWNrIG9mIHdpbmRvdyByZXNpemluZyBhbmQgcmVwb3NpdGlvbiB0aGUgZ2hvc3QgZWxlbWVudFxuICAgICAgICAgICAgaWYgKHRoaXMuZ2hvc3RFbGVtZW50ICE9PSB1bmRlZmluZWQgJiYgdGhpcy5naG9zdEVsZW1lbnQgIT0gbnVsbCkge1xuICAgICAgICAgICAgICAgIHRoaXMuaW5pdGlhbE9mZnNldCA9IHRoaXMub3JpZ2luYWxFbGVtZW50Lm9mZnNldCgpO1xuICAgICAgICAgICAgICAgIHRoaXMuZ2hvc3RFbGVtZW50XG4gICAgICAgICAgICAgICAgICAgIC5jc3MoXCJ0b3BcIiwgdGhpcy5pbml0aWFsT2Zmc2V0LnRvcClcbiAgICAgICAgICAgICAgICAgICAgLmNzcyhcImxlZnRcIiwgdGhpcy5pbml0aWFsT2Zmc2V0LmxlZnQpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuXG4gICAgZXhwb3J0IGNsYXNzIERpdkV4cGFuZGFibGUgZXh0ZW5kcyBBYnN0cmFjdEV4cGFuZGFibGUge1xuXG4gICAgICAgIGNvbnN0cnVjdG9yKHJvb3RFbGVtZW50OiBKUXVlcnkpIHtcbiAgICAgICAgICAgIHN1cGVyKHJvb3RFbGVtZW50KTtcbiAgICAgICAgICAgIHRoaXMub3JpZ2luYWxFbGVtZW50ID0gdGhpcy5yb290RWxlbWVudC5maW5kKFwiLmJ1dHRlci1jb21wb25lbnQtdmFsdWUtcmVhZG9ubHlcIik7XG4gICAgICAgICAgICB0aGlzLnJlYXJyYW5nZU9yaWdpbmFsRWxlbWVudFN0cnVjdHVyZSgpO1xuICAgICAgICB9XG5cbiAgICAgICAgcHJpdmF0ZSByZWFycmFuZ2VPcmlnaW5hbEVsZW1lbnRTdHJ1Y3R1cmUoKTogdm9pZCB7XG4gICAgICAgICAgICBsZXQgX2xhYmVsID0gdGhpcy5yb290RWxlbWVudC5maW5kKFwiLmJ1dHRlci1jb21wb25lbnQtbGFiZWxcIik7XG5cbiAgICAgICAgICAgIHRoaXMub3JpZ2luYWxFbGVtZW50XG4gICAgICAgICAgICAgICAgLmFkZENsYXNzKFwiYnV0dGVyLWNvbXBvbmVudC1leHBhbmRhYmxlLW9yaWdpbmFsXCIpXG4gICAgICAgICAgICAgICAgLmNsaWNrKGV2ZW50ID0+IHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5leHBhbmRFbGVtZW50KGV2ZW50KTtcbiAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgIC5kZXRhY2goKTtcblxuICAgICAgICAgICAgbGV0IF9jb250YWluZXIgPSAkKFwiPGRpdj5cIilcbiAgICAgICAgICAgICAgICAuYWRkQ2xhc3MoXCJidXR0ZXItY29tcG9uZW50LWV4cGFuZGFibGUtcmVhZG9ubHktY29udGFpbmVyXCIpXG4gICAgICAgICAgICAgICAgLmluc2VydEFmdGVyKF9sYWJlbCk7XG5cbiAgICAgICAgICAgIGxldCBfaWNvbiA9ICQoXCI8c3Bhbj5cIikuYWRkQ2xhc3MoXCJpbnB1dC1ncm91cC10ZXh0IGdseXBoaWNvbiBnbHlwaGljb24tcmVzaXplLWZ1bGxcIik7XG5cbiAgICAgICAgICAgIHRoaXMub3JpZ2luYWxFbGVtZW50LmFwcGVuZFRvKF9jb250YWluZXIpO1xuICAgICAgICAgICAgJChcIjxkaXY+XCIpXG4gICAgICAgICAgICAgICAgLmFkZENsYXNzKFwiYnV0dGVyLWNvbXBvbmVudC1leHBhbmRhYmxlLXJlYWRvbmx5LWljb25cIilcbiAgICAgICAgICAgICAgICAuYXBwZW5kKF9pY29uKVxuICAgICAgICAgICAgICAgIC5hcHBlbmRUbyhfY29udGFpbmVyKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGNyZWF0ZUdob3N0RWxlbWVudCgpOiBKUXVlcnkge1xuICAgICAgICAgICAgcmV0dXJuICQoXCI8ZGl2PlwiKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlzRXhwYW5zaW9uRXZlbnRJZ25vcmVkKGV2ZW50OiBhbnkpOiBib29sZWFuIHtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfVxuXG4gICAgICAgIG9uR2hvc3RFbGVtZW50Q3JlYXRlZCgpOiB2b2lkIHtcbiAgICAgICAgICAgIC8vIGRvIG5vdGhpbmdcbiAgICAgICAgfVxuXG4gICAgICAgIG9uR2hvc3RFbGVtZW50Q29sbGFwc2VkKGlzQ2FuY2VsbGVkOiBib29sZWFuKTogdm9pZCB7XG4gICAgICAgICAgICAvLyBkbyBub3RoaW5nXG4gICAgICAgIH1cblxuICAgICAgICB0cmFuc2ZlclZhbHVlVG9HaG9zdEVsZW1lbnQoKTogdm9pZCB7XG4gICAgICAgICAgICAkKFwiPGRpdj5cIilcbiAgICAgICAgICAgICAgICAuaHRtbCh0aGlzLm9yaWdpbmFsRWxlbWVudC5odG1sKCkpXG4gICAgICAgICAgICAgICAgLmFkZENsYXNzKFwiYnV0dGVyLWNvbXBvbmVudC1leHBhbmRhYmxlLWdob3N0LXJlYWRvbmx5Q29udGVudFwiKVxuICAgICAgICAgICAgICAgIC5hcHBlbmRUbyh0aGlzLmdob3N0RWxlbWVudCk7XG4gICAgICAgIH1cblxuICAgIH1cblxuICAgIGV4cG9ydCBjbGFzcyBUZXh0YXJlYUV4cGFuZGFibGUgZXh0ZW5kcyBBYnN0cmFjdEV4cGFuZGFibGUge1xuXG4gICAgICAgIHByaXZhdGUgYmxvY2tGb2N1c0V2ZW50T25PcmlnaW5hbDogYm9vbGVhbjtcbiAgICAgICAgcHJpdmF0ZSBibG9ja0JsdXJFdmVudE9uT3JpZ2luYWw6IGJvb2xlYW47XG5cbiAgICAgICAgY29uc3RydWN0b3Iocm9vdEVsZW1lbnQ6IEpRdWVyeSkge1xuICAgICAgICAgICAgc3VwZXIocm9vdEVsZW1lbnQpO1xuXG4gICAgICAgICAgICB0aGlzLmJsb2NrRm9jdXNFdmVudE9uT3JpZ2luYWwgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuYmxvY2tCbHVyRXZlbnRPbk9yaWdpbmFsID0gZmFsc2U7XG5cbiAgICAgICAgICAgIHRoaXMub3JpZ2luYWxFbGVtZW50ID0gdGhpcy5yb290RWxlbWVudC5maW5kKFwidGV4dGFyZWFcIik7XG4gICAgICAgICAgICB0aGlzLm9yaWdpbmFsRWxlbWVudC5hZGRDbGFzcyhcImJ1dHRlci1jb21wb25lbnQtZXhwYW5kYWJsZS1vcmlnaW5hbFwiKTtcblxuICAgICAgICAgICAgdGhpcy5vcmlnaW5hbEVsZW1lbnQuZm9jdXMoZXZlbnQgPT4ge1xuICAgICAgICAgICAgICAgIHRoaXMuZXhwYW5kRWxlbWVudChldmVudCk7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIHRoaXMub3JpZ2luYWxFbGVtZW50LmJsdXIoZXZlbnQgPT4ge1xuICAgICAgICAgICAgICAgIHRoaXMuaGFuZGxlQmx1ckV2ZW50KGV2ZW50KTtcbiAgICAgICAgICAgIH0pO1xuXG4gICAgICAgICAgICB0aGlzLmFkZElucHV0R3JvdXBBZGRvbigpO1xuICAgICAgICB9XG5cbiAgICAgICAgcHJpdmF0ZSBhZGRJbnB1dEdyb3VwQWRkb24oKTogdm9pZCB7XG4gICAgICAgICAgICB0aGlzLm9yaWdpbmFsRWxlbWVudFxuICAgICAgICAgICAgICAgIC5hZGRDbGFzcyhcImZvcm0tY29udHJvbFwiKVxuICAgICAgICAgICAgICAgIC5wYXJlbnQoKVxuICAgICAgICAgICAgICAgIC5hZGRDbGFzcyhcImlucHV0LWdyb3VwXCIpO1xuICAgICAgICAgICAgJChcIjxzcGFuIGNsYXNzPVxcXCJpbnB1dC1ncm91cC1hcHBlbmRcXFwiPjxzcGFuIGNsYXNzPVxcXCJpbnB1dC1ncm91cC10ZXh0IGdseXBoaWNvbiBnbHlwaGljb24tcmVzaXplLWZ1bGxcXFwiPjwvc3Bhbj48L3NwYW4+XCIpXG4gICAgICAgICAgICAgICAgLmluc2VydEFmdGVyKHRoaXMub3JpZ2luYWxFbGVtZW50KTtcbiAgICAgICAgfVxuXG4gICAgICAgIHByaXZhdGUgaGFuZGxlQmx1ckV2ZW50KGV2ZW50OiBhbnkpOiB2b2lkIHtcbiAgICAgICAgICAgIGlmICh0aGlzLmJsb2NrQmx1ckV2ZW50T25PcmlnaW5hbCkge1xuICAgICAgICAgICAgICAgIC8vIHByZXZlbnQgYmx1ciBldmVudCBidWJibGluZywgc28gaXQgd2lsbCBub3QgYmUgdHJpZ2dlcmVkIGluIGpzZlxuICAgICAgICAgICAgICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBjcmVhdGVHaG9zdEVsZW1lbnQoKTogSlF1ZXJ5IHtcbiAgICAgICAgICAgIHJldHVybiAkKFwiPHRleHRhcmVhPlwiKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlzRXhwYW5zaW9uRXZlbnRJZ25vcmVkKGV2ZW50OiBhbnkpOiBib29sZWFuIHtcbiAgICAgICAgICAgIHRoaXMuYmxvY2tCbHVyRXZlbnRPbk9yaWdpbmFsID0gdHJ1ZTtcbiAgICAgICAgICAgIGlmICh0aGlzLmJsb2NrRm9jdXNFdmVudE9uT3JpZ2luYWwpIHtcbiAgICAgICAgICAgICAgICBldmVudC5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBvbkdob3N0RWxlbWVudENyZWF0ZWQoKTogdm9pZCB7XG4gICAgICAgICAgICB0aGlzLmdob3N0RWxlbWVudFxuICAgICAgICAgICAgICAgIC5ibHVyKGV2ZW50ID0+IHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5jb2xsYXBzZUVsZW1lbnQoZXZlbnQpO1xuICAgICAgICAgICAgICAgIH0pXG4gICAgICAgICAgICAgICAgLmZvY3VzKCk7XG4gICAgICAgICAgICB0aGlzLm1vdmVDYXJldFRvRW5kKHRoaXMuZ2hvc3RFbGVtZW50KTtcbiAgICAgICAgfVxuXG4gICAgICAgIG9uR2hvc3RFbGVtZW50Q29sbGFwc2VkKGlzQ2FuY2VsbGVkOiBib29sZWFuKTogdm9pZCB7XG4gICAgICAgICAgICBpZiAoIWlzQ2FuY2VsbGVkKSB7XG4gICAgICAgICAgICAgICAgLy90cmFuc2ZlciB2YWx1ZSBiYWNrIGZyb20gZ2hvc3QgdG8gb3JpZ2luYWxcbiAgICAgICAgICAgICAgICB0aGlzLm9yaWdpbmFsRWxlbWVudC52YWwodGhpcy5naG9zdEVsZW1lbnQudmFsKCkpO1xuXG4gICAgICAgICAgICAgICAgLy8gdHJpZ2dlciBibHVyIGFuZCBrZXl1cCBldmVudCBvbiBvcmlnaW5hbCB0ZXh0YXJlYSBhbmQgZG9uXCJ0IGJsb2NrXG4gICAgICAgICAgICAgICAgLy8gaXQgZm9yIGpzZlxuICAgICAgICAgICAgICAgIHRoaXMuYmxvY2tCbHVyRXZlbnRPbk9yaWdpbmFsID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgdGhpcy5ibG9ja0ZvY3VzRXZlbnRPbk9yaWdpbmFsID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICAvLyBkZWZlciB0aGUgZXZlbnRzIGEgbGl0dGxlIGJpdCwgbG9vayBhdFxuICAgICAgICAgICAgICAgIC8vIChodHRwOi8vc3RhY2tvdmVyZmxvdy5jb20vcXVlc3Rpb25zLzgzODA3NTkvd2h5LWlzbnQtdGhpcy10ZXh0YXJlYS1mb2N1c2luZy13aXRoLWZvY3VzIzgzODA3ODUpXG4gICAgICAgICAgICAgICAgd2luZG93LnNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLm9yaWdpbmFsRWxlbWVudC50cmlnZ2VyKFwia2V5dXBcIik7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMub3JpZ2luYWxFbGVtZW50LnRyaWdnZXIoXCJjaGFuZ2VcIik7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMub3JpZ2luYWxFbGVtZW50LnRyaWdnZXIoXCJibHVyXCIpO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLmJsb2NrRm9jdXNFdmVudE9uT3JpZ2luYWwgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB9LCA1MCk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHRoaXMuYmxvY2tCbHVyRXZlbnRPbk9yaWdpbmFsID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICB0aGlzLmJsb2NrRm9jdXNFdmVudE9uT3JpZ2luYWwgPSBmYWxzZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIHRyYW5zZmVyVmFsdWVUb0dob3N0RWxlbWVudCgpOiB2b2lkIHtcbiAgICAgICAgICAgIHRoaXMuZ2hvc3RFbGVtZW50LnZhbCh0aGlzLm9yaWdpbmFsRWxlbWVudC52YWwoKSk7XG4gICAgICAgIH1cblxuICAgICAgICBwcml2YXRlIG1vdmVDYXJldFRvRW5kKGVsZW1lbnQ6IGFueSk6IHZvaWQge1xuICAgICAgICAgICAgaWYgKHR5cGVvZiBlbGVtZW50LnNlbGVjdGlvblN0YXJ0ID09PSBcIm51bWJlclwiKSB7XG4gICAgICAgICAgICAgICAgZWxlbWVudC5zZWxlY3Rpb25TdGFydCA9IGVsZW1lbnQuc2VsZWN0aW9uRW5kID0gZWxlbWVudC52YWx1ZS5sZW5ndGg7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKHR5cGVvZiBlbGVtZW50LmNyZWF0ZVRleHRSYW5nZSAhPT0gXCJ1bmRlZmluZWRcIikge1xuICAgICAgICAgICAgICAgIGxldCByYW5nZSA9IGVsZW1lbnQuY3JlYXRlVGV4dFJhbmdlKCk7XG4gICAgICAgICAgICAgICAgcmFuZ2UuY29sbGFwc2UoZmFsc2UpO1xuICAgICAgICAgICAgICAgIHJhbmdlLnNlbGVjdCgpO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBsZXQgc3RyTGVuZ3RoID0gKDxzdHJpbmc+dGhpcy5naG9zdEVsZW1lbnQudmFsKCkpLmxlbmd0aCAqIDI7XG4gICAgICAgICAgICAgICAgKDxIVE1MSW5wdXRFbGVtZW50PnRoaXMuZ2hvc3RFbGVtZW50LmdldCgwKSkuc2V0U2VsZWN0aW9uUmFuZ2Uoc3RyTGVuZ3RoLCBzdHJMZW5ndGgpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgIH1cblxuICAgIH1cbn0iXX0=
