/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.util;

import java.util.ArrayList;
import java.util.List;
import org.butterfaces.util.StringUtils;

public final class StringJoiner {
    private final List<String> joins = new ArrayList<String>();
    private String separator;
    private String wrapped;

    private StringJoiner(String separator) {
        this.separator = separator;
        this.wrapped = null;
    }

    private StringJoiner(String separator, String wrapped, Iterable<String> values) {
        this(separator);
        this.wrapped = wrapped;
        for (String value : values) {
            this.joins.add(StringUtils.getNullSafeValue(value));
        }
    }

    public static StringJoiner on(String sep) {
        return new StringJoiner(sep);
    }

    public static StringJoiner on(char sep) {
        return new StringJoiner(String.valueOf(sep));
    }

    public StringJoiner join(String value) {
        ArrayList<String> newJoins = new ArrayList<String>(this.joins);
        newJoins.add(value);
        return new StringJoiner(this.separator, this.wrapped, newJoins);
    }

    public StringJoiner join(Iterable<String> values) {
        ArrayList<String> newJoins = new ArrayList<String>(this.joins);
        for (String value : values) {
            newJoins.add(value);
        }
        return new StringJoiner(this.separator, this.wrapped, newJoins);
    }

    public StringJoiner wrappedBy(String wrapped) {
        return new StringJoiner(this.separator, wrapped, this.joins);
    }

    public StringJoiner wrappedBy(char wrapped) {
        return new StringJoiner(this.separator, String.valueOf(wrapped), this.joins);
    }

    public String toString() {
        if (this.joins.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.joins) {
            if (s == null) continue;
            if (sb.length() > 0) {
                sb.append(this.separator);
            }
            if (StringUtils.isNotEmpty(this.wrapped)) {
                sb.append(this.wrapped);
                sb.append(s);
                sb.append(this.wrapped);
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

