/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.partrenderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.butterfaces.util.StringUtils;

public class RenderUtils {
    public static void renderJQueryPluginCall(String elementId, String pluginFunctionCall, ResponseWriter writer, UIComponent uiComponent) throws IOException {
        String jsCall = RenderUtils.createJQueryPluginCall(elementId, pluginFunctionCall);
        writer.startElement("script", uiComponent);
        writer.writeText((Object)jsCall, null);
        writer.endElement("script");
    }

    public static String createJQueryPluginCall(String elementId, String pluginFunctionCall) {
        return RenderUtils.createJQueryPluginCall(elementId, null, pluginFunctionCall, null);
    }

    public static String createJQueryPluginCall(String elementId, String childSelector, String pluginFunctionCall) {
        return RenderUtils.createJQueryPluginCall(elementId, childSelector, pluginFunctionCall, null);
    }

    public static String createJQueryPluginCall(String elementId, String childSelector, String pluginFunctionCall, String previousCalls) {
        StringBuilder jsCall = new StringBuilder();
        jsCall.append("jQuery(function () {");
        if (StringUtils.isNotEmpty(previousCalls)) {
            jsCall.append(previousCalls);
        }
        jsCall.append(RenderUtils.createJQueryBySelector(elementId, childSelector));
        jsCall.append(".");
        jsCall.append(pluginFunctionCall);
        jsCall.append(";");
        jsCall.append("});");
        return jsCall.toString();
    }

    public static String createJQueryBySelector(String elementId, String childSelector) {
        StringBuilder jsCall = new StringBuilder();
        jsCall.append("jQuery(");
        jsCall.append("document.getElementById('");
        jsCall.append(elementId);
        jsCall.append("')");
        jsCall.append(")");
        if (StringUtils.isNotEmpty(childSelector)) {
            jsCall.append(".");
            jsCall.append("find('");
            jsCall.append(childSelector);
            jsCall.append("')");
        }
        return jsCall.toString();
    }

    public static String createOptionsStringForJQueryPluginCall(Map<String, String> options) {
        StringBuilder sb = new StringBuilder("{");
        int index = 0;
        for (String key : options.keySet()) {
            if (index > 0) {
                sb.append(", ");
            }
            sb.append(key).append(": '").append(options.get(key)).append("'");
            ++index;
        }
        sb.append("}");
        return sb.toString();
    }
}

