/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.partrenderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ResponseWriter;
import org.butterfaces.component.html.HtmlCheckBox;
import org.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import org.butterfaces.util.StringUtils;

public class CheckBoxReadonlyPartRenderer
extends ReadonlyPartRenderer {
    @Override
    protected void renderInnerReadonlyPart(UIInput uiComponent, Object value, ResponseWriter writer) throws IOException {
        HtmlCheckBox checkBox = (HtmlCheckBox)uiComponent;
        String styleClass = (Boolean)value != false ? "butter-component-value-readonly-wrapper checked" : "butter-component-value-readonly-wrapper";
        writer.startElement("span", (UIComponent)uiComponent);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (checkBox.isSwitch()) {
            writer.startElement("div", (UIComponent)checkBox);
            writer.writeAttribute("class", (Object)"slider round", "styleClass");
            writer.endElement("div");
            if (StringUtils.isNotEmpty(checkBox.getDescription())) {
                writer.startElement("span", (UIComponent)checkBox);
                writer.writeAttribute("class", (Object)"butter-component-checkbox-description", "styleClass");
                writer.writeText((Object)checkBox.getDescription(), null);
                writer.endElement("span");
            }
        } else {
            writer.writeText((Object)this.getReadonlyDisplayValue(value, checkBox), null);
        }
        writer.endElement("span");
    }

    private String getReadonlyDisplayValue(Object value, HtmlCheckBox checkBox) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty(checkBox.getDescription())) {
            sb.append(checkBox.getDescription()).append(": ");
        }
        sb.append((Boolean)value != false ? "ja" : "nein");
        return sb.toString();
    }
}

