/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.base.renderer;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.butterfaces.component.base.renderer.HtmlBasicRenderer;

public class HtmlBasicInputRenderer
extends HtmlBasicRenderer {
    private static final Logger LOGGER = Logger.getLogger(HtmlBasicRenderer.class.getName());
    private boolean hasStringConverter = false;
    private boolean hasStringConverterSet = false;

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String newValue = (String)submittedValue;
        ValueExpression valueExpression = component.getValueExpression("value");
        Converter converter = this.getValueHolderConverter(component);
        if (null == converter && null != valueExpression) {
            Class converterType = valueExpression.getType(context.getELContext());
            if (this.shouldNotBeConverted(converterType, context)) {
                this.logFine("No conversion necessary for value {0} of component {1}", submittedValue, component.getId());
                return newValue;
            }
            try {
                converter = context.getApplication().createConverter(converterType);
                this.logFine("Created converter ({0}) for type {1} for component {2}.", converter.getClass().getName(), converterType.getName(), component.getId());
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Could not instantiate converter for type {0}: {1}", e, converterType, e.toString());
                return null;
            }
        } else if (converter == null) {
            String message = "No conversion necessary for value {0} of component {1} since there is no explicitly registered converter and the component value is not bound to a model property";
            this.logFine("No conversion necessary for value {0} of component {1} since there is no explicitly registered converter and the component value is not bound to a model property", submittedValue, component.getId());
            return newValue;
        }
        return converter.getAsObject(context, component, newValue);
    }

    private boolean shouldNotBeConverted(Class converterType, FacesContext context) {
        return converterType == null || converterType == Object.class || converterType == String.class && this.hasNoStringConverter(context);
    }

    private void logFine(String message, Object ... parameters) {
        this.log(Level.FINE, message, null, parameters);
    }

    private void log(Level level, String message, Throwable throwable, Object ... parameters) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, message, parameters);
            if (throwable != null) {
                LOGGER.log(level, "", throwable);
            }
        }
    }

    private Converter getValueHolderConverter(UIComponent component) {
        if (component instanceof ValueHolder) {
            return ((ValueHolder)component).getConverter();
        }
        return null;
    }

    private boolean hasNoStringConverter(FacesContext context) {
        if (!this.hasStringConverterSet) {
            this.hasStringConverter = context.getApplication().createConverter(String.class) != null;
            this.hasStringConverterSet = true;
        }
        return !this.hasStringConverter;
    }
}

