/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;

public class PaginationSizeLinkProcessor
extends AbstractAttributeModifierAttrProcessor {
    public PaginationSizeLinkProcessor() {
        super("pagination-size-link");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        HttpServletRequest request = BroadleafRequestContext.getBroadleafRequestContext().getRequest();
        String baseUrl = request.getRequestURL().toString();
        HashMap<String, String[]> params = new HashMap<String, String[]>(request.getParameterMap());
        Integer pageSize = Integer.parseInt(element.getAttributeValue(attributeName));
        if (pageSize != null && pageSize > 1) {
            params.put(ProductSearchCriteria.PAGE_SIZE_STRING, new String[]{pageSize.toString()});
        } else {
            params.remove(ProductSearchCriteria.PAGE_SIZE_STRING);
        }
        String url = ProcessorUtils.getUrl(baseUrl, params);
        attributes.put("href", url);
        return attributes;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

