/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Properties;

public abstract class PublicKeyKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    public static final String SESSION_KEY_OBFUSCATION_PROPERTY = "org.bouncycastle.openpgp.session_key_obfuscation";
    public static final long WILDCARD = 0L;
    private PGPPublicKey pubKey;
    protected boolean sessionKeyObfuscation;
    protected boolean useWildcardKeyID;

    private static boolean getSessionKeyObfuscationDefault() {
        return !Properties.isOverrideSetTo((String)SESSION_KEY_OBFUSCATION_PROPERTY, (boolean)false);
    }

    protected PublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pubKey) {
        switch (pubKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: {
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Can't use an RSA_SIGN key for encryption.");
            }
            case 17: {
                throw new IllegalArgumentException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new IllegalArgumentException("Can't use ECDSA for encryption.");
            }
            case 22: 
            case 27: 
            case 28: {
                throw new IllegalArgumentException("Can't use EdDSA for encryption.");
            }
            default: {
                throw new IllegalArgumentException("unknown asymmetric algorithm: " + pubKey.getAlgorithm());
            }
        }
        this.pubKey = pubKey;
        this.sessionKeyObfuscation = PublicKeyKeyEncryptionMethodGenerator.getSessionKeyObfuscationDefault();
    }

    public PublicKeyKeyEncryptionMethodGenerator setSessionKeyObfuscation(boolean enabled) {
        this.sessionKeyObfuscation = enabled;
        return this;
    }

    public PublicKeyKeyEncryptionMethodGenerator setUseWildcardKeyID(boolean enabled) {
        this.useWildcardKeyID = enabled;
        return this;
    }

    public byte[][] processSessionInfo(byte[] encryptedSessionInfo) throws PGPException {
        byte[][] data;
        switch (this.pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                data = new byte[][]{this.convertToEncodedMPI(encryptedSessionInfo)};
                break;
            }
            case 16: 
            case 20: {
                byte[] b1 = new byte[encryptedSessionInfo.length / 2];
                byte[] b2 = new byte[encryptedSessionInfo.length / 2];
                System.arraycopy(encryptedSessionInfo, 0, b1, 0, b1.length);
                System.arraycopy(encryptedSessionInfo, b1.length, b2, 0, b2.length);
                data = new byte[][]{this.convertToEncodedMPI(b1), this.convertToEncodedMPI(b2)};
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                data = new byte[][]{encryptedSessionInfo};
                break;
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
            }
        }
        return data;
    }

    private byte[] convertToEncodedMPI(byte[] encryptedSessionInfo) throws PGPException {
        try {
            return new MPInteger(new BigInteger(1, encryptedSessionInfo)).getEncoded();
        }
        catch (IOException e) {
            throw new PGPException("Invalid MPI encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public ContainedPacket generate(int encAlgorithm, byte[] sessionInfo) throws PGPException {
        long keyId = this.useWildcardKeyID ? 0L : this.pubKey.getKeyID();
        return PublicKeyEncSessionPacket.createV3PKESKPacket(keyId, this.pubKey.getAlgorithm(), this.processSessionInfo(this.encryptSessionInfo(this.pubKey, sessionInfo)));
    }

    @Override
    public ContainedPacket generateV5(int encAlgorithm, int aeadAlgorithm, byte[] sessionInfo) throws PGPException {
        return null;
    }

    @Override
    public ContainedPacket generateV6(int encAlgorithm, int aeadAlgorithm, byte[] sessionInfo) throws PGPException {
        return null;
    }

    protected abstract byte[] encryptSessionInfo(PGPPublicKey var1, byte[] var2) throws PGPException;

    protected static byte[] getSessionInfo(byte[] ephPubEncoding, byte[] c) throws IOException {
        byte[] VB = new MPInteger(new BigInteger(1, ephPubEncoding)).getEncoded();
        byte[] rv = new byte[VB.length + 1 + c.length];
        System.arraycopy(VB, 0, rv, 0, VB.length);
        rv[VB.length] = (byte)c.length;
        System.arraycopy(c, 0, rv, VB.length + 1, c.length);
        return rv;
    }

    protected static byte[] getSessionInfo(byte[] VB, int sysmmetricKeyAlgorithm, byte[] c) {
        byte[] rv = new byte[VB.length + 2 + c.length];
        System.arraycopy(VB, 0, rv, 0, VB.length);
        rv[VB.length] = (byte)(c.length + 1);
        rv[VB.length + 1] = (byte)sysmmetricKeyAlgorithm;
        System.arraycopy(c, 0, rv, VB.length + 2, c.length);
        return rv;
    }
}

