/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.util.Strings;

public class ClearSignedFileProcessor {
    private static int readInputLine(ByteArrayOutputStream bOut, InputStream fIn) throws IOException {
        int ch;
        bOut.reset();
        int lookAhead = -1;
        while ((ch = fIn.read()) >= 0) {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = ClearSignedFileProcessor.readPassedEOL(bOut, ch, fIn);
            break;
        }
        return lookAhead;
    }

    private static int readInputLine(ByteArrayOutputStream bOut, int lookAhead, InputStream fIn) throws IOException {
        bOut.reset();
        int ch = lookAhead;
        do {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = ClearSignedFileProcessor.readPassedEOL(bOut, ch, fIn);
            break;
        } while ((ch = fIn.read()) >= 0);
        if (ch < 0) {
            lookAhead = -1;
        }
        return lookAhead;
    }

    private static int readPassedEOL(ByteArrayOutputStream bOut, int lastCh, InputStream fIn) throws IOException {
        int lookAhead = fIn.read();
        if (lastCh == 13 && lookAhead == 10) {
            bOut.write(lookAhead);
            lookAhead = fIn.read();
        }
        return lookAhead;
    }

    private static void verifyFile(InputStream in, InputStream keyIn, String resultName) throws Exception {
        byte[] line;
        ArmoredInputStream aIn = new ArmoredInputStream(in);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(resultName));
        ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
        int lookAhead = ClearSignedFileProcessor.readInputLine(lineOut, aIn);
        byte[] lineSep = ClearSignedFileProcessor.getLineSeparator();
        if (lookAhead != -1 && aIn.isClearText()) {
            line = lineOut.toByteArray();
            ((OutputStream)out).write(line, 0, ClearSignedFileProcessor.getLengthWithoutSeparatorOrTrailingWhitespace(line));
            ((OutputStream)out).write(lineSep);
            while (lookAhead != -1 && aIn.isClearText()) {
                lookAhead = ClearSignedFileProcessor.readInputLine(lineOut, lookAhead, aIn);
                line = lineOut.toByteArray();
                ((OutputStream)out).write(line, 0, ClearSignedFileProcessor.getLengthWithoutSeparatorOrTrailingWhitespace(line));
                ((OutputStream)out).write(lineSep);
            }
        } else if (lookAhead != -1) {
            line = lineOut.toByteArray();
            ((OutputStream)out).write(line, 0, ClearSignedFileProcessor.getLengthWithoutSeparatorOrTrailingWhitespace(line));
            ((OutputStream)out).write(lineSep);
        }
        ((OutputStream)out).close();
        PGPPublicKeyRingCollection pgpRings = new PGPPublicKeyRingCollection(keyIn, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(aIn);
        PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
        PGPSignature sig = p3.get(0);
        PGPPublicKey publicKey = pgpRings.getPublicKey(sig.getKeyID());
        sig.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), publicKey);
        BufferedInputStream sigIn = new BufferedInputStream(new FileInputStream(resultName));
        lookAhead = ClearSignedFileProcessor.readInputLine(lineOut, sigIn);
        ClearSignedFileProcessor.processLine(sig, lineOut.toByteArray());
        if (lookAhead != -1) {
            do {
                lookAhead = ClearSignedFileProcessor.readInputLine(lineOut, lookAhead, sigIn);
                sig.update((byte)13);
                sig.update((byte)10);
                ClearSignedFileProcessor.processLine(sig, lineOut.toByteArray());
            } while (lookAhead != -1);
        }
        ((InputStream)sigIn).close();
        if (sig.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static byte[] getLineSeparator() {
        String nl = Strings.lineSeparator();
        byte[] nlBytes = new byte[nl.length()];
        for (int i = 0; i != nlBytes.length; ++i) {
            nlBytes[i] = (byte)nl.charAt(i);
        }
        return nlBytes;
    }

    private static void signFile(String fileName, InputStream keyIn, OutputStream out, char[] pass, String digestName) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        int digest = digestName.equals("SHA256") ? 8 : (digestName.equals("SHA384") ? 9 : (digestName.equals("SHA512") ? 10 : (digestName.equals("MD5") ? 1 : (digestName.equals("RIPEMD160") ? 3 : 2))));
        PGPSecretKey pgpSecKey = PGPExampleUtil.readSecretKey(keyIn);
        PGPPrivateKey pgpPrivKey = pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(pass));
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pgpSecKey.getPublicKey().getAlgorithm(), digest).setProvider("BC"));
        PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
        sGen.init(1, pgpPrivKey);
        Iterator<String> it = pgpSecKey.getPublicKey().getUserIDs();
        if (it.hasNext()) {
            spGen.addSignerUserID(false, it.next());
        }
        sGen.setHashedSubpackets(spGen.generate());
        BufferedInputStream fIn = new BufferedInputStream(new FileInputStream(fileName));
        ArmoredOutputStream aOut = new ArmoredOutputStream(out);
        aOut.beginClearText(digest);
        ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
        int lookAhead = ClearSignedFileProcessor.readInputLine(lineOut, fIn);
        ClearSignedFileProcessor.processLine(aOut, sGen, lineOut.toByteArray());
        if (lookAhead != -1) {
            do {
                lookAhead = ClearSignedFileProcessor.readInputLine(lineOut, lookAhead, fIn);
                sGen.update((byte)13);
                sGen.update((byte)10);
                ClearSignedFileProcessor.processLine(aOut, sGen, lineOut.toByteArray());
            } while (lookAhead != -1);
        }
        ((InputStream)fIn).close();
        aOut.endClearText();
        BCPGOutputStream bOut = new BCPGOutputStream(aOut);
        sGen.generate().encode(bOut);
        aOut.close();
    }

    private static void processLine(PGPSignature sig, byte[] line) throws SignatureException, IOException {
        int length = ClearSignedFileProcessor.getLengthWithoutWhiteSpace(line);
        if (length > 0) {
            sig.update(line, 0, length);
        }
    }

    private static void processLine(OutputStream aOut, PGPSignatureGenerator sGen, byte[] line) throws SignatureException, IOException {
        int length = ClearSignedFileProcessor.getLengthWithoutWhiteSpace(line);
        if (length > 0) {
            sGen.update(line, 0, length);
        }
        aOut.write(line, 0, line.length);
    }

    private static int getLengthWithoutSeparatorOrTrailingWhitespace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && ClearSignedFileProcessor.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isLineEnding(byte b) {
        return b == 13 || b == 10;
    }

    private static int getLengthWithoutWhiteSpace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && ClearSignedFileProcessor.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isWhiteSpace(byte b) {
        return ClearSignedFileProcessor.isLineEnding(b) || b == 9 || b == 32;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args[0].equals("-s")) {
            InputStream keyIn = PGPUtil.getDecoderStream(new FileInputStream(args[2]));
            FileOutputStream out = new FileOutputStream(args[1] + ".asc");
            if (args.length == 4) {
                ClearSignedFileProcessor.signFile(args[1], keyIn, out, args[3].toCharArray(), "SHA1");
            } else {
                ClearSignedFileProcessor.signFile(args[1], keyIn, out, args[3].toCharArray(), args[4]);
            }
        } else if (args[0].equals("-v")) {
            if (args[1].indexOf(".asc") < 0) {
                System.err.println("file needs to end in \".asc\"");
                System.exit(1);
            }
            FileInputStream in = new FileInputStream(args[1]);
            InputStream keyIn = PGPUtil.getDecoderStream(new FileInputStream(args[2]));
            ClearSignedFileProcessor.verifyFile(in, keyIn, args[1].substring(0, args[1].length() - 4));
        } else {
            System.err.println("usage: ClearSignedFileProcessor [-s file keyfile passPhrase]|[-v sigFile keyFile]");
        }
    }
}

