/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public class ByteArrayHandler {
    public static byte[] decrypt(byte[] encrypted, char[] passPhrase) throws IOException, PGPException, NoSuchProviderException {
        InputStream in = new ByteArrayInputStream(encrypted);
        JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(in = PGPUtil.getDecoderStream(in));
        Object o = pgpF.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        PGPPBEEncryptedData pbe = (PGPPBEEncryptedData)enc.get(0);
        InputStream clear = pbe.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(passPhrase));
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(clear);
        PGPCompressedData cData = (PGPCompressedData)pgpFact.nextObject();
        pgpFact = new JcaPGPObjectFactory(cData.getDataStream());
        PGPLiteralData ld = (PGPLiteralData)pgpFact.nextObject();
        return Streams.readAll((InputStream)ld.getInputStream());
    }

    public static byte[] encrypt(byte[] clearData, char[] passPhrase, String fileName, int algorithm, boolean armor) throws IOException, PGPException, NoSuchProviderException {
        if (fileName == null) {
            fileName = "_CONSOLE";
        }
        byte[] compressedData = ByteArrayHandler.compress(clearData, fileName, 1);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream out = bOut;
        if (armor) {
            out = new ArmoredOutputStream(out);
        }
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(algorithm).setSecureRandom(new SecureRandom()).setProvider("BC");
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(encryptorBuilder);
        encGen.addMethod(new JcePBEKeyEncryptionMethodGenerator(passPhrase).setProvider("BC"));
        OutputStream encOut = encGen.open(out, compressedData.length);
        encOut.write(compressedData);
        encOut.close();
        if (armor) {
            out.close();
        }
        return bOut.toByteArray();
    }

    private static byte[] compress(byte[] clearData, String fileName, int algorithm) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(algorithm);
        OutputStream cos = comData.open(bOut);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(cos, 'b', fileName, clearData.length, new Date());
        pOut.write(clearData);
        pOut.close();
        comData.close();
        return bOut.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String passPhrase = "Dick Beck";
        char[] passArray = passPhrase.toCharArray();
        byte[] original = "Hello world".getBytes();
        System.out.println("Starting PGP test");
        byte[] encrypted = ByteArrayHandler.encrypt(original, passArray, "iway", 3, true);
        System.out.println("\nencrypted data = '" + new String(encrypted) + "'");
        byte[] decrypted = ByteArrayHandler.decrypt(encrypted, passArray);
        System.out.println("\ndecrypted data = '" + new String(decrypted) + "'");
        encrypted = ByteArrayHandler.encrypt(original, passArray, "iway", 9, false);
        System.out.println("\nencrypted data = '" + new String(Hex.encode((byte[])encrypted)) + "'");
        decrypted = ByteArrayHandler.decrypt(encrypted, passArray);
        System.out.println("\ndecrypted data = '" + new String(decrypted) + "'");
    }
}

