/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.AbstractPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.contentHelper);
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String providerName) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    private int getExpectedPayloadSize(PrivateKey key) {
        if (key instanceof DHKey) {
            DHKey k = (DHKey)((Object)key);
            return (k.getParams().getP().bitLength() + 7) / 8;
        }
        if (key instanceof RSAKey) {
            RSAKey k = (RSAKey)((Object)key);
            return (k.getModulus().bitLength() + 7) / 8;
        }
        return -1;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privKey) {
        return new AbstractPublicKeyDataDecryptorFactory(){
            final int expectedPayLoadSize;
            {
                this.expectedPayLoadSize = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(privKey);
            }

            public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData, int pkeskVersion) throws PGPException {
                if (keyAlgorithm == 18 || keyAlgorithm == 25 || keyAlgorithm == 26) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(keyAlgorithm, privKey, this.expectedPayLoadSize, secKeyData);
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }

            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
            }

            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(seipd, sessionKey);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey privKey) {
        return new AbstractPublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData, int pkeskVersion) throws PGPException {
                boolean containsSKAlg = this.containsSKAlg(pkeskVersion);
                if (keyAlgorithm == 18) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, privKey, secKeyData);
                }
                if (keyAlgorithm == 25) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, privKey, secKeyData[0], 32, "X25519withSHA256HKDF", 7, EdECObjectIdentifiers.id_X25519, "X25519", containsSKAlg);
                }
                if (keyAlgorithm == 26) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, privKey, secKeyData[0], 56, "X448withSHA512HKDF", 9, EdECObjectIdentifiers.id_X448, "X448", containsSKAlg);
                }
                PrivateKey jcePrivKey = JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(privKey);
                int expectedPayLoadSize = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(jcePrivKey);
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(keyAlgorithm, jcePrivKey, expectedPayLoadSize, secKeyData);
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }

            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
            }

            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(seipd, sessionKey);
            }
        };
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter converter, PGPPrivateKey privKey, byte[][] secKeyData) throws PGPException {
        PublicKeyPacket pubKeyData = privKey.getPublicKeyPacket();
        byte[] enc = secKeyData[0];
        int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
        JcePublicKeyDataDecryptorFactoryBuilder.checkRange(2 + pLen + 1, enc);
        byte[] pEnc = new byte[pLen];
        System.arraycopy(enc, 2, pEnc, 0, pLen);
        int keyLen = enc[pLen + 2] & 0xFF;
        JcePublicKeyDataDecryptorFactoryBuilder.checkRange(2 + pLen + 1 + keyLen, enc);
        byte[] keyEnc = new byte[keyLen];
        System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyLen);
        try {
            PublicKey publicKey;
            String agreementName;
            ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
            if (JcaJcePGPUtil.isX25519(ecKey.getCurveOID())) {
                agreementName = RFC6637Utils.getXDHAlgorithm(pubKeyData);
                if (pEnc.length != 33 || 64 != pEnc[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = this.getPublicKey(pEnc, EdECObjectIdentifiers.id_X25519, 1);
            } else if (ecKey.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
                agreementName = RFC6637Utils.getXDHAlgorithm(pubKeyData);
                if (pEnc.length != 57 || 64 != pEnc[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = this.getPublicKey(pEnc, EdECObjectIdentifiers.id_X448, 1);
            } else {
                X9ECParametersHolder x9Params = ECNamedCurveTable.getByOIDLazy((ASN1ObjectIdentifier)ecKey.getCurveOID());
                ECPoint publicPoint = x9Params.getCurve().decodePoint(pEnc);
                agreementName = RFC6637Utils.getAgreementAlgorithm(pubKeyData);
                publicKey = converter.getPublicKey(new PGPPublicKey(new PublicKeyPacket(pubKeyData.getVersion(), 18, new Date(), new ECDHPublicBCPGKey(ecKey.getCurveOID(), publicPoint, (int)ecKey.getHashAlgorithm(), (int)ecKey.getSymmetricKeyAlgorithm())), this.fingerprintCalculator));
            }
            byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(pubKeyData, this.fingerprintCalculator);
            Key paddedSessionKey = this.getSessionKey(converter, privKey, agreementName, publicKey, ecKey.getSymmetricKeyAlgorithm(), keyEnc, (AlgorithmParameterSpec)new UserKeyingMaterialSpec(userKeyingMaterial));
            return PGPPad.unpadSessionData(paddedSessionKey.getEncoded());
        }
        catch (Exception e) {
            throw new PGPException("error decrypting session data: " + e.getMessage(), e);
        }
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter converter, PGPPrivateKey privKey, byte[] enc, int pLen, String agreementAlgorithm, int symmetricKeyAlgorithm, ASN1ObjectIdentifier algorithmIdentifier, String algorithmName, boolean containsSKAlg) throws PGPException {
        try {
            byte[] ephemeralKey = Arrays.copyOf((byte[])enc, (int)pLen);
            int size = enc[pLen] & 0xFF;
            JcePublicKeyDataDecryptorFactoryBuilder.checkRange(pLen + 1 + size, enc);
            int sesKeyLen = size - (containsSKAlg ? 1 : 0);
            int sesKeyOff = pLen + 1 + (containsSKAlg ? 1 : 0);
            byte[] keyEnc = Arrays.copyOfRange((byte[])enc, (int)sesKeyOff, (int)(sesKeyOff + sesKeyLen));
            PublicKey ephemeralPubKey = this.getPublicKey(ephemeralKey, algorithmIdentifier, 0);
            Key paddedSessionKey = this.getSessionKey(converter, privKey, agreementAlgorithm, ephemeralPubKey, symmetricKeyAlgorithm, keyEnc, (AlgorithmParameterSpec)JcaJcePGPUtil.getHybridValueParameterSpecWithPrepend(ephemeralKey, privKey.getPublicKeyPacket(), algorithmName));
            return paddedSessionKey.getEncoded();
        }
        catch (Exception e) {
            throw new PGPException("error decrypting session data: " + e.getMessage(), e);
        }
    }

    private Key getSessionKey(JcaPGPKeyConverter converter, PGPPrivateKey privKey, String agreementName, PublicKey publicKey, int symmetricKeyAlgorithm, byte[] keyEnc, AlgorithmParameterSpec ukms) throws PGPException, GeneralSecurityException {
        PrivateKey privateKey = converter.getPrivateKey(privKey);
        Key key = JcaJcePGPUtil.getSecret(this.helper, publicKey, RFC6637Utils.getKeyEncryptionOID(symmetricKeyAlgorithm).getId(), agreementName, ukms, privateKey);
        Cipher c = this.helper.createKeyWrapper(symmetricKeyAlgorithm);
        c.init(4, key);
        return c.unwrap(keyEnc, "Session", 3);
    }

    private PublicKey getPublicKey(byte[] pEnc, ASN1ObjectIdentifier algprithmIdentifier, int pEncOff) throws PGPException, GeneralSecurityException, IOException {
        KeyFactory keyFact = this.helper.createKeyFactory("XDH");
        return keyFact.generatePublic(new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(algprithmIdentifier), Arrays.copyOfRange((byte[])pEnc, (int)pEncOff, (int)pEnc.length)).getEncoded()));
    }

    private void updateWithMPI(Cipher c, int expectedPayloadSize, byte[] encMPI) {
        if (expectedPayloadSize > 0) {
            if (encMPI.length - 2 > expectedPayloadSize) {
                c.update(encMPI, 3, encMPI.length - 3);
            } else {
                if (expectedPayloadSize > encMPI.length - 2) {
                    c.update(new byte[expectedPayloadSize - (encMPI.length - 2)]);
                }
                c.update(encMPI, 2, encMPI.length - 2);
            }
        } else {
            c.update(encMPI, 2, encMPI.length - 2);
        }
    }

    private byte[] decryptSessionData(int keyAlgorithm, PrivateKey privKey, int expectedPayloadSize, byte[][] secKeyData) throws PGPException {
        Cipher c1 = this.helper.createPublicKeyCipher(keyAlgorithm);
        try {
            c1.init(2, privKey);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        if (keyAlgorithm == 2 || keyAlgorithm == 1) {
            this.updateWithMPI(c1, expectedPayloadSize, secKeyData[0]);
        } else {
            this.updateWithMPI(c1, expectedPayloadSize, secKeyData[0]);
            this.updateWithMPI(c1, expectedPayloadSize, secKeyData[1]);
        }
        try {
            return c1.doFinal();
        }
        catch (Exception e) {
            throw new PGPException("exception decrypting session data", e);
        }
    }

    private static void checkRange(int pLen, byte[] enc) throws PGPException {
        if (pLen > enc.length) {
            throw new PGPException("encoded length out of range");
        }
    }
}

