/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        this.digestCalculatorProviderBuilder.setProvider(providerName);
        return this;
    }

    public PGPContentVerifierBuilder get(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        return new JcaPGPContentVerifierBuilder(keyAlgorithm, hashAlgorithm);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int keyAlgorithm, int hashAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.hashAlgorithm = hashAlgorithm;
        }

        public PGPContentVerifier build(PGPPublicKey publicKey) throws PGPException {
            PGPDigestCalculator digestCalculator = JcaPGPContentVerifierBuilderProvider.this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
            PublicKey jcaKey = JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(publicKey);
            Signature signature = this.keyAlgorithm == 22 && jcaKey.getAlgorithm().equals("Ed448") ? JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(28, this.hashAlgorithm) : JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            try {
                signature.initVerify(jcaKey);
            }
            catch (InvalidKeyException e) {
                throw new PGPException("invalid key.", e);
            }
            return new PGPContentVerifier(this, publicKey, jcaKey, signature, digestCalculator){
                private final boolean isEdDsa;
                private final /* synthetic */ PGPPublicKey val$publicKey;
                private final /* synthetic */ PublicKey val$jcaKey;
                private final /* synthetic */ Signature val$signature;
                private final /* synthetic */ PGPDigestCalculator val$digestCalculator;
                private final /* synthetic */ JcaPGPContentVerifierBuilder this$1;
                {
                    this.this$1 = this$1;
                    this.val$publicKey = val$publicKey;
                    this.val$jcaKey = val$jcaKey;
                    this.val$signature = val$signature;
                    this.val$digestCalculator = val$digestCalculator;
                    this.isEdDsa = JcaPGPContentVerifierBuilder.access$300(this.this$1) == 22 || JcaPGPContentVerifierBuilder.access$300(this.this$1) == 28 || JcaPGPContentVerifierBuilder.access$300(this.this$1) == 27;
                }

                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.access$400(this.this$1);
                }

                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.access$300(this.this$1);
                }

                public long getKeyID() {
                    return this.val$publicKey.getKeyID();
                }

                public boolean verify(byte[] expected) {
                    try {
                        int modLength;
                        if (this.val$jcaKey instanceof RSAPublicKey && expected.length < (modLength = (((RSAPublicKey)this.val$jcaKey).getModulus().bitLength() + 7) / 8)) {
                            byte[] tmp = new byte[modLength];
                            System.arraycopy(expected, 0, tmp, tmp.length - expected.length, expected.length);
                            return this.val$signature.verify(tmp);
                        }
                        if (this.isEdDsa) {
                            this.val$signature.update(this.val$digestCalculator.getDigest());
                            return this.val$signature.verify(expected);
                        }
                        return this.val$signature.verify(expected);
                    }
                    catch (SignatureException e) {
                        throw new PGPRuntimeOperationException("unable to verify signature: " + e.getMessage(), e);
                    }
                }

                public OutputStream getOutputStream() {
                    if (this.isEdDsa) {
                        return this.val$digestCalculator.getOutputStream();
                    }
                    return OutputStreamFactory.createStream((Signature)this.val$signature);
                }
            };
        }

        static /* synthetic */ int access$300(JcaPGPContentVerifierBuilder x0) {
            return x0.keyAlgorithm;
        }

        static /* synthetic */ int access$400(JcaPGPContentVerifierBuilder x0) {
            return x0.hashAlgorithm;
        }
    }
}

