/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.AEADSecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;

public class BcAEADSecretKeyEncryptorBuilder
implements AEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;
    private SecureRandom random = new SecureRandom();

    public BcAEADSecretKeyEncryptorBuilder(int aeadAlgorithm, int symmetricAlgorithm, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = aeadAlgorithm;
        this.symmetricAlgorithm = symmetricAlgorithm;
        this.argon2Params = argon2Params;
    }

    public BcAEADSecretKeyEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PBESecretKeyEncryptor build(char[] passphrase, final PublicKeyPacket pubKey) {
        return new PBESecretKeyEncryptor(this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, this.random, passphrase){
            private byte[] iv;
            {
                super(x0, x1, x2, x3, x4);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            public byte[] encryptKeyData(byte[] key, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                try {
                    return BcAEADUtil.processAeadKeyData(true, this.encAlgorithm, this.aeadAlgorithm, this.getKey(), this.getCipherIV(), pubKey.getPacketTag() == 6 ? 5 : 7, pubKey.getVersion(), keyData, keyOff, keyLen, pubKey.getEncodedContents());
                }
                catch (IOException e) {
                    throw new PGPException("Exception AEAD protecting private key material", e);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

