/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;

public class PGPPublicKeyRing
extends PGPKeyRing
implements Iterable {
    private static final Logger LOG = Logger.getLogger(PGPPublicKeyRing.class.getName());
    List keys;

    public PGPPublicKeyRing(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    private static List checkKeys(List keys) {
        ArrayList<PGPPublicKey> rv = new ArrayList<PGPPublicKey>(keys.size());
        for (int i = 0; i != keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)keys.get(i);
            if (i == 0) {
                if (!k.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (k.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            rv.add(k);
        }
        return rv;
    }

    public PGPPublicKeyRing(List pubKeys) {
        this.keys = PGPPublicKeyRing.checkKeys(pubKeys);
    }

    public PGPPublicKeyRing(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream pIn = BCPGInputStream.wrap(in);
        int initialTag = pIn.skipMarkerAndPaddingPackets();
        if (initialTag != 6 && initialTag != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        PublicKeyPacket pubPk = PGPPublicKeyRing.readPublicKeyPacket(pIn);
        TrustPacket trustPk = PGPPublicKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPPublicKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPPublicKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        try {
            this.keys.add(new PGPPublicKey(pubPk, trustPk, keySigs, ids, idTrusts, idSigs, fingerPrintCalculator));
            while (pIn.nextPacketTag() == 14) {
                PGPPublicKey publicKey = PGPPublicKeyRing.readSubkey(pIn, fingerPrintCalculator);
                if (publicKey == null) continue;
                this.keys.add(publicKey);
            }
        }
        catch (PGPException e) {
            throw new IOException("processing exception: " + e.toString());
        }
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long keyID) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] fingerprint) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (!k.hasFingerprint(fingerprint)) continue;
            return k;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(KeyIdentifier identifier) {
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)it.next();
            if (!identifier.matchesExplicit(k.getKeyIdentifier())) continue;
            return k;
        }
        return null;
    }

    public Iterator getPublicKeys(KeyIdentifier identifier) {
        ArrayList<PGPPublicKey> matches = new ArrayList<PGPPublicKey>();
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)it.next();
            if (!identifier.matchesExplicit(k.getKeyIdentifier())) continue;
            matches.add(k);
        }
        return matches.iterator();
    }

    public Iterator getKeysWithSignaturesBy(long keyID) {
        ArrayList<PGPPublicKey> keysWithSigs = new ArrayList<PGPPublicKey>();
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            Iterator sigIt = k.getSignaturesForKeyID(keyID);
            if (!sigIt.hasNext()) continue;
            keysWithSigs.add(k);
        }
        return keysWithSigs.iterator();
    }

    public Iterator getKeysWithSignaturesBy(KeyIdentifier identifier) {
        ArrayList<PGPPublicKey> keysWithSigs = new ArrayList<PGPPublicKey>();
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)it.next();
            Iterator sigIt = k.getSignaturesForKey(identifier);
            if (!sigIt.hasNext()) continue;
            keysWithSigs.add(k);
        }
        return keysWithSigs.iterator();
    }

    public Iterator getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public Iterator iterator() {
        return this.getPublicKeys();
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat format) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)bOut, format);
        this.encode(pOut);
        pOut.close();
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    public int size() {
        return this.keys.size();
    }

    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            k.encode(outStream, forTransfer);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>(pubRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPPublicKey key = (PGPPublicKey)keys.get(i);
            if (key.getKeyID() == pubKey.getKeyID()) {
                found = true;
                keys.set(i, pubKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (pubKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, pubKey);
            } else {
                keys.add(pubKey);
            }
        }
        return new PGPPublicKeyRing(keys);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        int count = pubRing.keys.size();
        long keyID = pubKey.getKeyID();
        ArrayList<PGPPublicKey> result = new ArrayList<PGPPublicKey>(count);
        boolean found = false;
        for (int i = 0; i < count; ++i) {
            PGPPublicKey key = (PGPPublicKey)pubRing.keys.get(i);
            if (key.getKeyID() == keyID) {
                found = true;
                continue;
            }
            result.add(key);
        }
        if (!found) {
            return null;
        }
        return new PGPPublicKeyRing(result);
    }

    static PublicKeyPacket readPublicKeyPacket(BCPGInputStream in) throws IOException {
        Packet packet = in.readPacket();
        if (!(packet instanceof PublicKeyPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (PublicKeyPacket)packet;
    }

    static PGPPublicKey readSubkey(BCPGInputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        try {
            PublicKeyPacket pk = PGPPublicKeyRing.readPublicKeyPacket(in);
            TrustPacket kTrust = PGPPublicKeyRing.readOptionalTrustPacket(in);
            List sigList = PGPPublicKeyRing.readSignaturesAndTrust(in);
            return new PGPPublicKey(pk, kTrust, sigList, fingerPrintCalculator);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (ArmoredInputException e) {
            throw e;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("skipping unknown subkey: " + e.getMessage());
            }
            return null;
        }
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing first, PGPPublicKeyRing second) throws PGPException {
        return PGPPublicKeyRing.join(first, second, false, false);
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing first, PGPPublicKeyRing second, boolean joinTrustPackets, boolean allowSubkeySigsOnNonSubkey) throws PGPException {
        if (!second.getPublicKey().hasFingerprint(first.getPublicKey().getFingerprint())) {
            throw new IllegalArgumentException("Cannot merge certificates with differing primary keys.");
        }
        HashSet<Long> secondKeys = new HashSet<Long>();
        Iterator it = second.iterator();
        while (it.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)it.next();
            secondKeys.add(Longs.valueOf((long)key.getKeyID()));
        }
        ArrayList<PGPPublicKey> merged = new ArrayList<PGPPublicKey>();
        Iterator it2 = first.iterator();
        while (it2.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)it2.next();
            PGPPublicKey copy = second.getPublicKey(key.getKeyID());
            if (copy != null) {
                merged.add(PGPPublicKey.join(key, copy, joinTrustPackets, allowSubkeySigsOnNonSubkey));
                secondKeys.remove(Longs.valueOf((long)key.getKeyID()));
                continue;
            }
            merged.add(key);
        }
        it2 = secondKeys.iterator();
        while (it2.hasNext()) {
            Long additionalKeyId = (Long)it2.next();
            merged.add(second.getPublicKey(additionalKeyId));
        }
        return new PGPPublicKeyRing(merged);
    }
}

