/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.bouncycastle.apache.bzip2.CBZip2OutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;

public class PGPCompressedDataGenerator
implements CompressionAlgorithmTags,
StreamGenerator {
    private int algorithm;
    private int compression;
    private OutputStream dOut;
    private BCPGOutputStream pkOut;

    public PGPCompressedDataGenerator(int algorithm) {
        this(algorithm, -1);
    }

    public PGPCompressedDataGenerator(int algorithm, int compression) {
        switch (algorithm) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown compression algorithm");
            }
        }
        if (compression != -1 && (compression < 0 || compression > 9)) {
            throw new IllegalArgumentException("unknown compression level: " + compression);
        }
        this.algorithm = algorithm;
        this.compression = compression;
    }

    public OutputStream open(OutputStream out) throws IOException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(out, 8);
        this.doOpen();
        return new WrappedGeneratorStream(this.dOut, this);
    }

    public OutputStream open(OutputStream out, byte[] buffer) throws IOException, PGPException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(out, 8, buffer);
        this.doOpen();
        return new WrappedGeneratorStream(this.dOut, this);
    }

    private void doOpen() throws IOException {
        this.pkOut.write(this.algorithm);
        switch (this.algorithm) {
            case 0: {
                this.dOut = this.pkOut;
                break;
            }
            case 1: {
                this.dOut = new SafeDeflaterOutputStream((OutputStream)this.pkOut, this.compression, true);
                break;
            }
            case 2: {
                this.dOut = new SafeDeflaterOutputStream((OutputStream)this.pkOut, this.compression, false);
                break;
            }
            case 3: {
                this.dOut = new SafeCBZip2OutputStream(this.pkOut);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void close() throws IOException {
        if (this.dOut != null) {
            if (this.dOut != this.pkOut) {
                this.dOut.close();
            }
            this.dOut = null;
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }

    private static class SafeDeflaterOutputStream
    extends DeflaterOutputStream {
        public SafeDeflaterOutputStream(OutputStream output, int compression, boolean nowrap) {
            super(output, new Deflater(compression, nowrap));
        }

        public void close() throws IOException {
            this.finish();
            this.def.end();
        }
    }

    private static class SafeCBZip2OutputStream
    extends CBZip2OutputStream {
        public SafeCBZip2OutputStream(OutputStream output) throws IOException {
            super(output);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

