/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.util.Strings;

public class PGPLiteralDataGenerator
implements StreamGenerator {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private BCPGOutputStream pkOut;
    private boolean oldFormat = false;

    public PGPLiteralDataGenerator() {
    }

    public PGPLiteralDataGenerator(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    private void writeHeader(OutputStream out, char format, byte[] encName, long modificationTime) throws IOException {
        out.write(format);
        out.write((byte)encName.length);
        for (int i = 0; i != encName.length; ++i) {
            out.write(encName[i]);
        }
        long modDate = modificationTime / 1000L;
        out.write((byte)(modDate >> 24));
        out.write((byte)(modDate >> 16));
        out.write((byte)(modDate >> 8));
        out.write((byte)modDate);
    }

    public OutputStream open(OutputStream out, char format, String name, long length, Date modificationTime) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        byte[] encName = Strings.toUTF8ByteArray((String)name);
        this.pkOut = new BCPGOutputStream(out, 11, length + 2L + (long)encName.length + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, format, encName, modificationTime.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream out, char format, String name, Date modificationTime, byte[] buffer) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(out, 11, buffer);
        byte[] encName = Strings.toUTF8ByteArray((String)name);
        this.writeHeader(this.pkOut, format, encName, modificationTime.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream out, char format, File file) throws IOException {
        return this.open(out, format, file.getName(), file.length(), new Date(file.lastModified()));
    }

    public void close() throws IOException {
        if (this.pkOut != null) {
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }
}

