/*
 * Decompiled with CFR 0.152.
 */
package org.cef.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cef.network.CefPostData;
import org.cef.network.CefRequest_N;

public abstract class CefRequest {
    CefRequest() {
    }

    public static final CefRequest create() {
        return CefRequest_N.createNative();
    }

    public abstract boolean isReadOnly();

    public abstract String getURL();

    public abstract void setURL(String var1);

    public abstract String getMethod();

    public abstract void setMethod(String var1);

    public abstract CefPostData getPostData();

    public abstract void setPostData(CefPostData var1);

    public abstract void getHeaderMap(Map<String, String> var1);

    public abstract void setHeaderMap(Map<String, String> var1);

    public abstract void set(String var1, String var2, CefPostData var3, Map<String, String> var4);

    public abstract int getFlags();

    public abstract void setFlags(int var1);

    public abstract String getFirstPartyForCookies();

    public abstract void setFirstPartyForCookies(String var1);

    public abstract ResourceType getResourceType();

    public abstract TransitionType getTransitionType();

    public String toString() {
        String returnValue = "\nHTTP-Request";
        returnValue = returnValue + "\n  Flags:" + this.getFlags();
        returnValue = returnValue + "\n  resourceType: " + (Object)((Object)this.getResourceType());
        returnValue = returnValue + "\n  transitionType: " + (Object)((Object)this.getTransitionType());
        returnValue = returnValue + "\n  firstPartyForCookies: " + this.getFirstPartyForCookies();
        returnValue = returnValue + "\n    " + this.getMethod() + " " + this.getURL() + " HTTP/1.1\n";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        this.getHeaderMap(headerMap);
        Set entrySet = headerMap.entrySet();
        String mimeType = null;
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            returnValue = returnValue + "    " + key + "=" + (String)entry.getValue() + "\n";
            if (!key.equals("Content-Type")) continue;
            mimeType = (String)entry.getValue();
        }
        CefPostData pd = this.getPostData();
        if (pd != null) {
            returnValue = returnValue + pd.toString(mimeType);
        }
        return returnValue;
    }

    public static enum TransitionFlags {
        TT_BLOCKED_FLAG(0x800000),
        TT_FORWARD_BACK_FLAG(0x1000000),
        TT_CHAIN_START_FLAG(0x10000000),
        TT_CHAIN_END_FLAG(0x20000000),
        TT_CLIENT_REDIRECT_FLAG(0x40000000),
        TT_SERVER_REDIRECT_FLAG(Integer.MIN_VALUE);

        private final int flag;

        private TransitionFlags(int flag) {
            this.flag = flag;
        }

        public int getValue() {
            return this.flag;
        }
    }

    public static final class CefUrlRequestFlags {
        public static final int UR_FLAG_NONE = 0;
        public static final int UR_FLAG_SKIP_CACHE = 1;
        public static final int UR_FLAG_ALLOW_CACHED_CREDENTIALS = 2;
        public static final int UR_FLAG_REPORT_UPLOAD_PROGRESS = 8;
        public static final int UR_FLAG_REPORT_RAW_HEADERS = 32;
        public static final int UR_FLAG_NO_DOWNLOAD_DATA = 64;
        public static final int UR_FLAG_NO_RETRY_ON_5XX = 128;
    }

    public static enum TransitionType {
        TT_LINK(0),
        TT_EXPLICIT(1),
        TT_AUTO_SUBFRAME(3),
        TT_MANUAL_SUBFRAME(4),
        TT_FORM_SUBMIT(7),
        TT_RELOAD(8);

        private int value;

        private TransitionType(int source) {
            this.value = source;
        }

        public int getValue() {
            return this.value;
        }

        public int getSource() {
            return this.value & 0xFF;
        }

        public void addQualifier(TransitionFlags flag) {
            this.value |= flag.getValue();
        }

        public void addQualifiers(int flags) {
            this.value |= flags & 0xFFFFFF00;
        }

        public int getQualifiers() {
            return this.value & 0xFFFFFF00;
        }

        public void removeQualifier(TransitionFlags flag) {
            this.value &= ~flag.getValue();
        }

        public boolean isSet(TransitionFlags flag) {
            return (this.value & flag.getValue()) != 0;
        }

        public boolean isRedirect() {
            return (this.value & 0xC0000000) != 0;
        }
    }

    public static enum ResourceType {
        RT_MAIN_FRAME,
        RT_SUB_FRAME,
        RT_STYLESHEET,
        RT_SCRIPT,
        RT_IMAGE,
        RT_FONT_RESOURCE,
        RT_SUB_RESOURCE,
        RT_OBJECT,
        RT_MEDIA,
        RT_WORKER,
        RT_SHARED_WORKER,
        RT_PREFETCH,
        RT_FAVICON,
        RT_XHR,
        RT_PING,
        RT_SERVICE_WORKER;

    }
}

