/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserWindow;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.handler.CefWindowHandlerAdapter;

class CefBrowserWr
extends CefBrowser_N {
    private Canvas canvas_ = null;
    private Component component_ = null;
    private Rectangle content_rect_ = new Rectangle(0, 0, 0, 0);
    private long window_handle_ = 0L;
    private CefClientHandler clientHandler_;
    private String url_;
    private CefRequestContext context_;
    private CefBrowserWr parent_ = null;
    private Point inspectAt_ = null;
    private CefBrowserWr devTools_ = null;
    private boolean isDisposed = false;
    private Timer delayedUpdate_ = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CefBrowserWr.this.createUIIfRequired();
                    if (OS.isMacintosh()) {
                        CefBrowserWr.this.doUpdate();
                    }
                }
            });
        }
    });
    private CefWindowHandlerAdapter win_handler_ = new CefWindowHandlerAdapter(){
        private Point lastPos = new Point(-1, -1);
        private long[] nextClick = new long[MouseInfo.getNumberOfButtons()];
        private int[] clickCnt = new int[MouseInfo.getNumberOfButtons()];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Rectangle getRect(CefBrowser browser) {
            Rectangle rectangle = CefBrowserWr.this.content_rect_;
            synchronized (rectangle) {
                return CefBrowserWr.this.content_rect_;
            }
        }

        @Override
        public void onMouseEvent(CefBrowser browser, int event, final int screenX, final int screenY, final int modifier, final int button) {
            final Point pt = new Point(screenX, screenY);
            if (event == 503) {
                if (pt.equals(this.lastPos)) {
                    return;
                }
                this.lastPos = pt;
                if ((modifier & 0x400) != 0) {
                    event = 506;
                }
            }
            final int finalEvent = event;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component parent = SwingUtilities.getRoot(CefBrowserWr.this.component_);
                    if (parent == null) {
                        return;
                    }
                    SwingUtilities.convertPointFromScreen(pt, parent);
                    int clickCnt = 0;
                    long now = new Date().getTime();
                    if (finalEvent == 507) {
                        int scrollType = 0;
                        int rotation = button > 0 ? 1 : -1;
                        CefBrowserWr.this.component_.dispatchEvent(new MouseWheelEvent(parent, finalEvent, now, modifier, pt.x, pt.y, 0, false, scrollType, 3, rotation));
                    } else {
                        clickCnt = this.getClickCount(finalEvent, button);
                        CefBrowserWr.this.component_.dispatchEvent(new MouseEvent(parent, finalEvent, now, modifier, pt.x, pt.y, screenX, screenY, clickCnt, false, button));
                    }
                    if (finalEvent == 502) {
                        CefBrowserWr.this.component_.dispatchEvent(new MouseEvent(parent, 500, now, modifier, pt.x, pt.y, screenX, screenY, clickCnt, false, button));
                    }
                }
            });
        }

        public int getClickCount(int event, int button) {
            int idx = button % this.nextClick.length;
            switch (event) {
                case 501: {
                    long currTime = new Date().getTime();
                    if (currTime > this.nextClick[idx]) {
                        this.nextClick[idx] = currTime + (long)((Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval")).intValue();
                        this.clickCnt[idx] = 1;
                    } else {
                        int n = idx;
                        this.clickCnt[n] = this.clickCnt[n] + 1;
                    }
                }
                case 502: {
                    return this.clickCnt[idx];
                }
            }
            return 0;
        }
    };

    CefBrowserWr(CefClientHandler clientHandler, String url, CefRequestContext context) {
        this(clientHandler, url, context, null, null);
    }

    private CefBrowserWr(CefClientHandler clientHandler, String url, CefRequestContext context, CefBrowserWr parent, Point inspectAt) {
        this.clientHandler_ = clientHandler;
        this.url_ = url;
        this.context_ = context;
        this.parent_ = parent;
        this.inspectAt_ = inspectAt;
        this.delayedUpdate_.setRepeats(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.component_ = new JPanel(new BorderLayout()){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                CefBrowserWr.this.wasResized(width, height);
            }

            @Override
            public void setBounds(Rectangle r) {
                this.setBounds(r.x, r.y, r.width, r.height);
            }

            @Override
            public void setSize(int width, int height) {
                super.setSize(width, height);
                CefBrowserWr.this.wasResized(width, height);
            }

            @Override
            public void setSize(Dimension d) {
                this.setSize(d.width, d.height);
            }

            @Override
            public void paint(Graphics g) {
                CefBrowserWr.this.doUpdate();
                CefBrowserWr.this.delayedUpdate_.restart();
            }
        };
        if (OS.isWindows()) {
            this.canvas_ = new Canvas();
            ((JPanel)this.component_).add((Component)this.canvas_, "Center");
        }
        this.component_.setMinimumSize(new Dimension(0, 0));
        this.component_.setFocusable(true);
        this.component_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CefBrowserWr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserWr.this.setFocus(true);
            }
        });
        this.component_.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                CefBrowserWr.this.doUpdate();
            }

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                CefBrowserWr.this.doUpdate();
            }
        });
        this.component_.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    CefBrowserWr.this.setWindowVisibility(e.getChanged().isVisible());
                }
            }
        });
    }

    @Override
    public Component getUIComponent() {
        return this.component_;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return this.win_handler_;
    }

    @Override
    public synchronized void close() {
        this.isDisposed = true;
        if (this.context_ != null) {
            this.context_.dispose();
        }
        if (this.parent_ != null) {
            this.parent_.closeDevTools();
            this.parent_.devTools_ = null;
            this.parent_ = null;
        }
        super.close();
    }

    @Override
    public synchronized CefBrowser getDevTools() {
        return this.getDevTools(null);
    }

    @Override
    public synchronized CefBrowser getDevTools(Point inspectAt) {
        if (this.devTools_ == null) {
            this.devTools_ = new CefBrowserWr(this.clientHandler_, this.url_, this.context_, this, inspectAt);
        }
        return this.devTools_;
    }

    private long getWindowHandle() {
        if (this.window_handle_ == 0L && OS.isMacintosh()) {
            try {
                Class<?> cls = Class.forName("org.cef.browser.mac.CefBrowserWindowMac");
                CefBrowserWindow browserWindow = (CefBrowserWindow)cls.newInstance();
                if (browserWindow != null) {
                    this.window_handle_ = browserWindow.getWindowHandle(this.component_);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.window_handle_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        if (this.isDisposed) {
            return;
        }
        Rectangle clipping = ((JPanel)this.component_).getVisibleRect();
        if (OS.isMacintosh()) {
            Container next;
            Container parent = this.component_.getParent();
            Point contentPos = this.component_.getLocation();
            while (!(parent == null || (next = parent.getParent()) != null && next instanceof Window)) {
                Point parentPos = parent.getLocation();
                contentPos.translate(parentPos.x, parentPos.y);
                parent = next;
            }
            contentPos.translate(clipping.x, clipping.y);
            Point browserPos = clipping.getLocation();
            browserPos.x *= -1;
            browserPos.y *= -1;
            Rectangle rectangle = this.content_rect_;
            synchronized (rectangle) {
                this.content_rect_ = new Rectangle(contentPos, clipping.getSize());
                Rectangle browserRect = new Rectangle(browserPos, this.component_.getSize());
                this.updateUI(this.content_rect_, browserRect);
            }
        }
        Rectangle rectangle = this.content_rect_;
        synchronized (rectangle) {
            this.content_rect_ = this.component_.getBounds();
            this.updateUI(clipping, this.content_rect_);
        }
    }

    private void createUIIfRequired() {
        if (this.getNativeRef("CefBrowser") == 0L && !this.isDisposed) {
            if (this.parent_ != null) {
                this.createDevTools(this.parent_, this.clientHandler_, this.getWindowHandle(), false, OS.isWindows() ? this.canvas_ : this.component_, this.inspectAt_);
            } else {
                this.createBrowser(this.clientHandler_, this.getWindowHandle(), this.url_, false, OS.isWindows() ? this.canvas_ : this.component_, this.context_);
            }
        }
    }
}

