/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import javax.swing.KeyStroke;

public class KeyCombination {
    private final KeyStroke keyStroke;

    private KeyCombination(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public static KeyCombination of(String s) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(s);
        if (keyStroke == null) {
            return null;
        }
        return new KeyCombination(keyStroke);
    }

    public int getCode() {
        return this.keyStroke.getKeyCode();
    }

    public char getChar() {
        return this.keyStroke.getKeyChar();
    }

    public boolean isTyped() {
        return this.keyStroke.getKeyEventType() == 400;
    }

    public int getCharOrCode() {
        return this.isTyped() ? this.getChar() : this.getCode();
    }

    public boolean isShiftDown() {
        return (this.keyStroke.getModifiers() & 0x41) != 0;
    }

    public boolean isCtrlDown() {
        return (this.keyStroke.getModifiers() & 0x82) != 0;
    }

    public boolean isAltDown() {
        return (this.keyStroke.getModifiers() & 0x208) != 0;
    }
}

