/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class EnumInputReader<T extends Enum<T>>
extends InputReader<T, EnumInputReader<T>> {
    private final Map<String, T> enumValues = new LinkedHashMap<String, T>();

    public EnumInputReader(Supplier<TextTerminal<?>> textTerminalSupplier, Class<T> enumClass) {
        super(textTerminalSupplier);
        try {
            Enum[] values;
            Method mValues = enumClass.getMethod("values", new Class[0]);
            for (Enum value : values = (Enum[])mValues.invoke(null, new Object[0])) {
                this.enumValues.put(value.toString(), value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create EnumInputReader<" + enumClass.getName() + ">", e);
        }
        this.possibleValues = new ArrayList<T>(this.enumValues.values());
        this.numberedPossibleValues = true;
    }

    public EnumInputReader<T> withAllValues() {
        return (EnumInputReader)this.withPossibleValues(new ArrayList<T>(this.enumValues.values()));
    }

    public EnumInputReader<T> withAllValuesNumbered() {
        return (EnumInputReader)this.withNumberedPossibleValues(new ArrayList<T>(this.enumValues.values()));
    }

    public EnumInputReader<T> withAllValuesInline() {
        return (EnumInputReader)this.withInlinePossibleValues(new ArrayList<T>(this.enumValues.values()));
    }

    @Override
    protected InputReader.ParseResult<T> parse(String s) {
        Enum value = (Enum)this.enumValues.get(s);
        if (value != null) {
            return new InputReader.ParseResult<Enum>(value);
        }
        return new InputReader.ParseResult<Object>(null, this.getErrorMessages(s));
    }
}

