/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.web;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.beryx.textio.AbstractTextTerminal;
import org.beryx.textio.KeyCombination;
import org.beryx.textio.PropertiesPrefixes;
import org.beryx.textio.ReadAbortedException;
import org.beryx.textio.ReadHandlerData;
import org.beryx.textio.ReadInterruptionData;
import org.beryx.textio.ReadInterruptionException;
import org.beryx.textio.ReadInterruptionStrategy;
import org.beryx.textio.TerminalProperties;
import org.beryx.textio.web.DataApi;
import org.beryx.textio.web.TextTerminalData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PropertiesPrefixes(value={"web"})
public class WebTextTerminal
extends AbstractTextTerminal<WebTextTerminal>
implements DataApi {
    private static final Logger logger = LoggerFactory.getLogger(WebTextTerminal.class);
    public static final long DEFAULT_TIMEOUT_NOT_EMPTY = 5000L;
    public static final long DEFAULT_TIMEOUT_HAS_ACTION = 250L;
    public static final long DEFAULT_TIMEOUT_DATA_CLEARED = 1000L;
    private final TextTerminalData data = new TextTerminalData();
    private final Lock dataLock = new ReentrantLock();
    private final Condition dataNotEmpty = this.dataLock.newCondition();
    private final Condition dataHasAction = this.dataLock.newCondition();
    private final Condition dataCleared = this.dataLock.newCondition();
    private String input;
    private boolean userInterruptedInput;
    private String handlerIdInput;
    private final Lock inputLock = new ReentrantLock();
    private final Condition inputAvailable = this.inputLock.newCondition();
    private Runnable onDispose;
    private Runnable onAbort;
    private long timeoutNotEmpty = 5000L;
    private long timeoutHasAction = 250L;
    private long timeoutDataCleared = 1000L;
    private int userInterruptKeyCode = 81;
    private boolean userInterruptKeyCtrl = true;
    private boolean userInterruptKeyShift = false;
    private boolean userInterruptKeyAlt = false;
    private final Map<String, Function<WebTextTerminal, ReadHandlerData>> registeredHandlers = new HashMap<String, Function<WebTextTerminal, ReadHandlerData>>();
    private Consumer<WebTextTerminal> userInterruptHandler = textTerm -> {
        textTerm.abort();
        Executors.newSingleThreadScheduledExecutor().schedule(() -> System.exit(-1), 2L, TimeUnit.SECONDS);
    };
    private boolean abortRead = true;

    public void setTimeoutNotEmpty(long timeoutNotEmpty) {
        this.timeoutNotEmpty = timeoutNotEmpty;
    }

    public void setTimeoutHasAction(long timeoutHasAction) {
        this.timeoutHasAction = timeoutHasAction;
    }

    public void setTimeoutDataCleared(long timeoutDataCleared) {
        this.timeoutDataCleared = timeoutDataCleared;
    }

    public WebTextTerminal() {
        TerminalProperties props = this.getProperties();
        props.addStringListener("user.interrupt.key", null, (term, newVal) -> this.setUserInterruptKey(newVal));
        props.addStringListener("prompt.style.class", null, (term, newVal) -> this.addSetting("promptStyleClass", newVal));
        props.addStringListener("prompt.color", null, (term, newVal) -> this.addSetting("promptColor", newVal));
        props.addStringListener("prompt.bgcolor", null, (term, newVal) -> this.addSetting("promptBackgroundColor", newVal));
        props.addBooleanListener("prompt.bold", false, (term, newVal) -> this.addSetting("promptBold", newVal));
        props.addBooleanListener("prompt.italic", false, (term, newVal) -> this.addSetting("promptItalic", newVal));
        props.addBooleanListener("prompt.underline", false, (term, newVal) -> this.addSetting("promptUnderline", newVal));
        props.addStringListener("input.style.class", null, (term, newVal) -> this.addSetting("inputStyleClass", newVal));
        props.addStringListener("input.color", null, (term, newVal) -> this.addSetting("inputColor", newVal));
        props.addStringListener("input.bgcolor", null, (term, newVal) -> this.addSetting("inputBackgroundColor", newVal));
        props.addBooleanListener("input.bold", false, (term, newVal) -> this.addSetting("inputBold", newVal));
        props.addBooleanListener("input.italic", false, (term, newVal) -> this.addSetting("inputItalic", newVal));
        props.addBooleanListener("input.underline", false, (term, newVal) -> this.addSetting("inputUnderline", newVal));
        props.addStringListener("pane.bgcolor", null, (term, newVal) -> this.addSetting("paneBackgroundColor", newVal));
        props.addStringListener("pane.style.class", null, (term, newVal) -> this.addSetting("paneStyleClass", newVal));
    }

    public WebTextTerminal createCopy() {
        WebTextTerminal copy = new WebTextTerminal();
        copy.setOnDispose(this.onDispose);
        copy.setOnAbort(this.onAbort);
        TerminalProperties props = copy.getProperties();
        List listeners = this.getProperties().getListeners();
        listeners.forEach(arg_0 -> ((TerminalProperties)props).addListener(arg_0));
        copy.setTimeoutNotEmpty(this.timeoutNotEmpty);
        copy.setTimeoutHasAction(this.timeoutHasAction);
        copy.setUserInterruptKey(this.userInterruptKeyCode, this.userInterruptKeyCtrl, this.userInterruptKeyShift, this.userInterruptKeyAlt);
        copy.registerUserInterruptHandler(this.userInterruptHandler, this.abortRead);
        copy.init();
        return copy;
    }

    public void dispose(String resultData) {
        if (this.onDispose != null) {
            this.onDispose.run();
        }
        this.setAction(TextTerminalData.Action.DISPOSE, resultData);
    }

    public void abort() {
        if (this.onAbort != null) {
            this.onAbort.run();
        }
        this.setAction(TextTerminalData.Action.ABORT);
    }

    public boolean resetLine() {
        this.setAction(TextTerminalData.Action.VIRTUAL);
        this.waitForDataCleared();
        this.data.setLineResetRequired(true);
        this.setAction(TextTerminalData.Action.VIRTUAL);
        return true;
    }

    public boolean moveToLineStart() {
        this.setAction(TextTerminalData.Action.VIRTUAL);
        this.waitForDataCleared();
        this.data.setMoveToLineStartRequired(true);
        return true;
    }

    public boolean setBookmark(String bookmark) {
        this.setAction(TextTerminalData.Action.VIRTUAL);
        this.waitForDataCleared();
        this.data.setBookmark(bookmark);
        return true;
    }

    public boolean resetToBookmark(String bookmark) {
        this.setAction(TextTerminalData.Action.VIRTUAL);
        this.waitForDataCleared();
        this.data.setResetToBookmark(bookmark);
        return true;
    }

    private void waitForDataCleared() {
        this.dataLock.lock();
        try {
            try {
                boolean ok;
                if (this.data.hasAction() && !(ok = this.dataCleared.await(this.timeoutDataCleared, TimeUnit.MILLISECONDS))) {
                    logger.warn("dataCleared timeout.");
                }
            }
            finally {
                this.dataLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setOnDispose(Runnable onDispose) {
        this.onDispose = onDispose;
    }

    public void setOnAbort(Runnable onAbort) {
        this.onAbort = onAbort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String read(boolean masking) {
        this.inputLock.lock();
        try {
            String string;
            if (this.data.getAction() != TextTerminalData.Action.ABORT) {
                this.setAction(masking ? TextTerminalData.Action.READ_MASKED : TextTerminalData.Action.READ);
            }
            try {
                String result;
                block12: while (true) {
                    logger.trace("read(): waiting for input...");
                    this.inputAvailable.await();
                    result = this.input;
                    if (this.input == null) continue;
                    if (this.userInterruptedInput && this.userInterruptHandler != null) {
                        logger.debug("Calling userInterruptHandler");
                        this.userInterruptHandler.accept(this);
                        if (this.abortRead) break;
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)this.handlerIdInput)) break;
                    logger.debug("Calling handler: {}", (Object)this.handlerIdInput);
                    String hInput = this.handlerIdInput;
                    this.handlerIdInput = null;
                    Function<WebTextTerminal, ReadHandlerData> handler = this.registeredHandlers.get(hInput);
                    if (handler == null) {
                        logger.error("Unknown handler: {}", (Object)hInput);
                        continue;
                    }
                    ReadHandlerData handlerData = handler.apply(this);
                    logger.debug("handlerData: {}", (Object)handlerData);
                    ReadInterruptionStrategy.Action action = handlerData.getAction();
                    switch (action) {
                        case CONTINUE: {
                            logger.debug("Setting action: CONTINUE_READ");
                            this.setAction(TextTerminalData.Action.CONTINUE_READ);
                            continue block12;
                        }
                        case RESTART: {
                            ReadInterruptionData readInterruptionData = ReadInterruptionData.from((ReadHandlerData)handlerData, (String)this.input);
                            throw new ReadInterruptionException(readInterruptionData, this.input);
                        }
                        case RETURN: {
                            this.setAction(TextTerminalData.Action.FLUSH);
                            this.waitForDataCleared();
                            this.println();
                            this.waitForDataCleared();
                            Function valueProvider = handlerData.getReturnValueProvider();
                            result = valueProvider == null ? null : (String)valueProvider.apply(this.input);
                            this.setAction(TextTerminalData.Action.CLEAR_OLD_INPUT);
                            this.waitForDataCleared();
                            break block12;
                        }
                        case ABORT: {
                            this.println();
                            this.waitForDataCleared();
                            this.setAction(TextTerminalData.Action.CLEAR_OLD_INPUT);
                            this.waitForDataCleared();
                            throw new ReadAbortedException(handlerData.getPayload(), this.input);
                        }
                    }
                    break;
                }
                this.input = null;
                this.userInterruptedInput = false;
                if (logger.isTraceEnabled()) {
                    logger.trace("read: {}", (Object)(masking ? result.replaceAll(".", "*") : result));
                }
                string = result;
                return string;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("read() interrupted", (Throwable)e);
                string = null;
                return string;
            }
        }
        finally {
            this.inputLock.unlock();
        }
    }

    protected void setAction(TextTerminalData.Action action) {
        this.setAction(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAction(TextTerminalData.Action action, String actionData) {
        if (action == TextTerminalData.Action.NONE || action == null) {
            logger.error("Not a proper action: {}", (Object)action);
            return;
        }
        this.dataLock.lock();
        try {
            TextTerminalData.Action currAction = this.data.getAction();
            if (currAction != TextTerminalData.Action.NONE && currAction != TextTerminalData.Action.FLUSH) {
                logger.warn("data.getAction() is {} in setAction({})", (Object)currAction, (Object)action);
            }
            this.data.setAction(action);
            this.data.setActionData(actionData);
            this.dataNotEmpty.signalAll();
            this.dataHasAction.signalAll();
        }
        finally {
            this.dataLock.unlock();
        }
    }

    public void rawPrint(String message) {
        this.dataLock.lock();
        try {
            if (this.data.getAction() != TextTerminalData.Action.ABORT) {
                String escapedMessage = this.data.addMessage(message);
                logger.trace("rawPrint(): signalling data: {}", (Object)escapedMessage);
            }
            this.dataNotEmpty.signalAll();
            if (this.data.hasAction()) {
                this.dataHasAction.signalAll();
            }
        }
        finally {
            this.dataLock.unlock();
        }
    }

    public void println() {
        this.setAction(TextTerminalData.Action.FLUSH);
        this.rawPrint("\n");
    }

    public boolean registerUserInterruptHandler(Consumer<WebTextTerminal> handler, boolean abortRead) {
        this.userInterruptHandler = handler;
        this.abortRead = abortRead;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerHandler(String keyStroke, Function<WebTextTerminal, ReadHandlerData> handler) {
        KeyCombination kc = KeyCombination.of((String)keyStroke);
        if (kc == null) {
            return false;
        }
        this.dataLock.lock();
        try {
            String key = this.data.addKey(keyStroke);
            if (key != null) {
                this.registeredHandlers.put(key, handler);
                this.dataNotEmpty.signalAll();
                if (this.data.hasAction()) {
                    this.dataHasAction.signalAll();
                }
            }
        }
        finally {
            this.dataLock.unlock();
        }
        return true;
    }

    @Override
    public TextTerminalData getTextTerminalData() {
        this.dataLock.lock();
        try {
            try {
                if (this.data.isEmpty()) {
                    this.dataNotEmpty.await(this.timeoutNotEmpty, TimeUnit.MILLISECONDS);
                }
                if (!this.data.hasAction()) {
                    this.dataHasAction.await(this.timeoutHasAction, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            TextTerminalData result = this.data.getCopy();
            this.data.clear();
            this.dataCleared.signalAll();
            logger.debug("returning terminalData: {}", (Object)result);
            TextTerminalData textTerminalData = result;
            return textTerminalData;
        }
        finally {
            this.dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUserInput(String newInput, boolean userInterrupt, String handlerId) {
        this.inputLock.lock();
        try {
            this.userInterruptedInput = userInterrupt;
            this.handlerIdInput = handlerId;
            if (newInput == null) {
                if (userInterrupt) {
                    newInput = "";
                } else if (StringUtils.isEmpty((CharSequence)handlerId)) {
                    logger.error("newInput is null");
                    return;
                }
            }
            if (this.input != null) {
                logger.warn("old input is not null");
            }
            this.input = newInput;
            this.inputAvailable.signalAll();
        }
        finally {
            this.inputLock.unlock();
        }
    }

    @Override
    public void postUserInput(String newInput) {
        this.postUserInput(newInput, false, null);
    }

    @Override
    public void postUserInterrupt(String partialInput) {
        this.postUserInput(partialInput, true, null);
    }

    @Override
    public void postHandlerCall(String handlerId, String partialInput) {
        this.postUserInput(partialInput, false, handlerId);
    }

    public void setUserInterruptKey(String keyStroke) {
        KeyCombination kc = KeyCombination.of((String)keyStroke);
        if (kc == null) {
            logger.warn("Invalid keyStroke: {}", (Object)keyStroke);
        } else {
            this.setUserInterruptKey(kc.getCharOrCode(), kc.isCtrlDown(), kc.isShiftDown(), kc.isAltDown());
        }
    }

    public void addSetting(String key, Object value) {
        this.addSettings(new TextTerminalData.KeyValue(key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSettings(TextTerminalData.KeyValue ... keyValues) {
        logger.debug("Adding settings: {}", Arrays.asList(keyValues));
        this.dataLock.lock();
        try {
            for (TextTerminalData.KeyValue keyVal : keyValues) {
                this.data.addSetting(keyVal);
            }
            this.dataNotEmpty.signalAll();
            if (this.data.hasAction()) {
                this.dataHasAction.signalAll();
            }
        }
        finally {
            this.dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserInterruptKey(int code, boolean ctrl, boolean shift, boolean alt) {
        this.dataLock.lock();
        try {
            this.userInterruptKeyCode = code;
            this.userInterruptKeyCtrl = ctrl;
            this.userInterruptKeyShift = shift;
            this.userInterruptKeyAlt = alt;
            this.data.addSetting("userInterruptKeyCode", code);
            this.data.addSetting("userInterruptKeyCtrl", ctrl);
            this.data.addSetting("userInterruptKeyShift", shift);
            this.data.addSetting("userInterruptKeyAlt", alt);
            this.dataNotEmpty.signalAll();
            if (this.data.hasAction()) {
                this.dataHasAction.signalAll();
            }
        }
        finally {
            this.dataLock.unlock();
        }
    }
}

