/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.web;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextTerminal;
import org.beryx.textio.web.DataApiProviderException;
import org.beryx.textio.web.RunnerData;
import org.beryx.textio.web.SparkDataServer;
import org.beryx.textio.web.TextIoApp;
import org.beryx.textio.web.WebTextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Session;
import spark.Spark;

public class SparkTextIoApp
implements TextIoApp<SparkTextIoApp> {
    private static final Logger logger = LoggerFactory.getLogger(SparkTextIoApp.class);
    private final WebTextTerminal termTemplate;
    private final BiConsumer<TextIO, RunnerData> textIoRunner;
    private final SparkDataServer server;
    private Integer maxInactiveSeconds = null;
    private Consumer<String> onDispose;
    private Consumer<String> onAbort;
    private Function<Session, Map<String, String>> sessionDataProvider = session -> Collections.emptyMap();

    public SparkTextIoApp(BiConsumer<TextIO, RunnerData> textIoRunner, WebTextTerminal termTemplate) {
        this.textIoRunner = textIoRunner;
        this.termTemplate = termTemplate;
        this.server = new SparkDataServer(this::create, this::get);
    }

    public SparkDataServer getServer() {
        return this.server;
    }

    @Override
    public void init() {
        this.server.init();
    }

    @Override
    public SparkTextIoApp withOnDispose(Consumer<String> onDispose) {
        this.onDispose = onDispose;
        return this;
    }

    @Override
    public SparkTextIoApp withOnAbort(Consumer<String> onAbort) {
        this.onAbort = onAbort;
        return this;
    }

    @Override
    public SparkTextIoApp withMaxInactiveSeconds(Integer maxInactiveSeconds) {
        this.maxInactiveSeconds = maxInactiveSeconds;
        return this;
    }

    @Override
    public SparkTextIoApp withStaticFilesLocation(String location) {
        Spark.staticFiles.location(location);
        return this;
    }

    @Override
    public SparkTextIoApp withPort(Integer portNumber) {
        if (portNumber != null) {
            this.server.withPort(portNumber);
        }
        return this;
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    public SparkTextIoApp withSessionDataProvider(Function<Session, Map<String, String>> provider) {
        this.sessionDataProvider = provider;
        return this;
    }

    protected WebTextTerminal create(SparkDataServer.SessionHolder sessionHolder, String initData) {
        String sessionId = sessionHolder.sessionId;
        Session session = sessionHolder.session;
        logger.debug("Creating terminal for sessionId: {}", (Object)sessionId);
        WebTextTerminal terminal = this.termTemplate.createCopy();
        terminal.setOnDispose(() -> {
            if (this.onDispose != null) {
                this.onDispose.accept(sessionId);
            }
            Executors.newSingleThreadScheduledExecutor().schedule(() -> session.removeAttribute(this.getSessionIdAttribute(sessionId)), 5L, TimeUnit.SECONDS);
        });
        terminal.setOnAbort(() -> {
            if (this.onAbort != null) {
                this.onAbort.accept(sessionId);
            }
            Executors.newSingleThreadScheduledExecutor().schedule(() -> session.removeAttribute(this.getSessionIdAttribute(sessionId)), 5L, TimeUnit.SECONDS);
        });
        session.attribute(this.getSessionIdAttribute(sessionId), (Object)terminal);
        if (this.maxInactiveSeconds != null) {
            session.maxInactiveInterval(this.maxInactiveSeconds.intValue());
        }
        TextIO textIO = new TextIO((TextTerminal)terminal);
        RunnerData runnerData = this.createRunnerData(initData, sessionHolder);
        Thread thread = new Thread(() -> this.textIoRunner.accept(textIO, runnerData));
        thread.setDaemon(true);
        thread.start();
        return terminal;
    }

    private RunnerData createRunnerData(String initData, SparkDataServer.SessionHolder sessionHolder) {
        RunnerData runnerData = new RunnerData(initData);
        Session session = sessionHolder.session;
        Map<String, String> sessionData = this.sessionDataProvider.apply(session);
        runnerData.setSessionData(sessionData);
        return runnerData;
    }

    protected WebTextTerminal get(SparkDataServer.SessionHolder sessionHolder) {
        Session session = sessionHolder.session;
        String sessionId = sessionHolder.sessionId;
        WebTextTerminal terminal = (WebTextTerminal)session.attribute(this.getSessionIdAttribute(sessionId));
        if (terminal == null) {
            throw new DataApiProviderException("Unknown session: " + sessionId);
        }
        logger.trace("Terminal found for sessionId: {} on session with attributes {}", (Object)sessionId, (Object)session.attributes());
        return terminal;
    }

    private String getSessionIdAttribute(String sessionId) {
        return "web-text-terminal-" + sessionId;
    }
}

