/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.web;

import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.beryx.textio.web.AbstractDataServer;
import org.beryx.textio.web.DataApi;
import org.beryx.textio.web.DataApiProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Session;
import spark.Spark;

public class SparkDataServer
extends AbstractDataServer<Request> {
    private static final Logger logger = LoggerFactory.getLogger(SparkDataServer.class);
    private final BiFunction<SessionHolder, String, DataApi> dataApiCreator;
    private final Function<SessionHolder, DataApi> dataApiGetter;
    private final DataApiProvider<Request> dataApiProvider = new DataApiProvider<Request>(){

        @Override
        public DataApi create(Request request, String initData) {
            return (DataApi)SparkDataServer.this.dataApiCreator.apply(SparkDataServer.getSessionHolder(request), initData);
        }

        @Override
        public DataApi get(Request request) {
            return (DataApi)SparkDataServer.this.dataApiGetter.apply(SparkDataServer.getSessionHolder(request));
        }
    };

    private static SessionHolder getSessionHolder(Request r) {
        return new SessionHolder(SparkDataServer.getId(r), r.session());
    }

    @Override
    public DataApiProvider<Request> getDataApiProvider() {
        return this.dataApiProvider;
    }

    public SparkDataServer(BiFunction<SessionHolder, String, DataApi> dataApiCreator, Function<SessionHolder, DataApi> dataApiGetter) {
        this.dataApiCreator = dataApiCreator;
        this.dataApiGetter = dataApiGetter;
    }

    @Override
    public SparkDataServer withPort(int portNumber) {
        Spark.port((int)portNumber);
        return this;
    }

    @Override
    public int getPort() {
        return Spark.port();
    }

    protected static String getId(Request request) {
        Session session = request.session();
        String id = session.id();
        String uuid = request.headers("uuid");
        if (uuid != null) {
            id = id + "-" + uuid;
        }
        logger.trace("id: {}", (Object)id);
        return id;
    }

    protected String configureResponseData(Response response, AbstractDataServer.ResponseData r) {
        response.status(r.status);
        response.type(r.contentType);
        response.body(r.text);
        return r.text;
    }

    @Override
    public void init() {
        Spark.post((String)("/" + this.getPathForPostInit()), (request, response) -> {
            logger.trace("Received INIT");
            String initData = new String(request.bodyAsBytes(), StandardCharsets.UTF_8);
            return this.configureResponseData(response, this.handleInit(request, initData));
        });
        Spark.get((String)("/" + this.getPathForGetData()), (String)"application/json", (request, response) -> {
            logger.trace("Received GET");
            return this.configureResponseData(response, this.handleGetData(request));
        });
        Spark.post((String)("/" + this.getPathForPostInput()), (request, response) -> {
            logger.trace("Received POST");
            boolean userInterrupt = Boolean.parseBoolean(request.headers("textio-user-interrupt"));
            String handlerId = request.headers("textio-handler-id");
            String input = new String(request.body().getBytes(), StandardCharsets.UTF_8);
            return this.configureResponseData(response, this.handlePostInput(request, input, userInterrupt, handlerId));
        });
    }

    static {
        Spark.exception(Exception.class, (exception, request, response) -> logger.error("Spark failure", (Throwable)exception));
    }

    public static class SessionHolder {
        public final String sessionId;
        public final Session session;

        public SessionHolder(String sessionId, Session session) {
            this.sessionId = sessionId;
            this.session = session;
        }
    }
}

