/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.web;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextTerminal;
import org.beryx.textio.web.DataApi;
import org.beryx.textio.web.DataApiProviderException;
import org.beryx.textio.web.RatpackDataServer;
import org.beryx.textio.web.RunnerData;
import org.beryx.textio.web.TextIoApp;
import org.beryx.textio.web.WebTextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.session.Session;

public class RatpackTextIoApp
implements TextIoApp<RatpackTextIoApp> {
    private static final Logger logger = LoggerFactory.getLogger(RatpackTextIoApp.class);
    private final WebTextTerminal termTemplate;
    private final BiConsumer<TextIO, RunnerData> textIoRunner;
    private final RatpackDataServer server;
    private Consumer<String> onDispose;
    private Consumer<String> onAbort;
    private Cache<String, WebTextTerminal> webTextTerminalCache;
    private int maxInactiveSeconds = 600;
    private Function<Session, Map<String, String>> sessionDataProvider = session -> Collections.emptyMap();

    public RatpackTextIoApp(BiConsumer<TextIO, RunnerData> textIoRunner, WebTextTerminal termTemplate) {
        this.textIoRunner = textIoRunner;
        this.termTemplate = termTemplate;
        this.server = new RatpackDataServer(this::create, this::get);
    }

    public RatpackDataServer getServer() {
        return this.server;
    }

    @Override
    public void init() {
        this.webTextTerminalCache = CacheBuilder.newBuilder().expireAfterAccess((long)this.maxInactiveSeconds, TimeUnit.SECONDS).removalListener(notification -> logger.debug("removed from cache: {}. Remaining entries: {}", notification.getKey(), (Object)this.webTextTerminalCache.size())).build();
        this.server.init();
    }

    @Override
    public RatpackTextIoApp withOnDispose(Consumer<String> onDispose) {
        this.onDispose = onDispose;
        return this;
    }

    @Override
    public RatpackTextIoApp withOnAbort(Consumer<String> onAbort) {
        this.onAbort = onAbort;
        return this;
    }

    @Override
    public RatpackTextIoApp withMaxInactiveSeconds(Integer maxInactiveSeconds) {
        if (maxInactiveSeconds != null) {
            this.maxInactiveSeconds = maxInactiveSeconds;
        }
        return this;
    }

    @Override
    public RatpackTextIoApp withStaticFilesLocation(String location) {
        this.server.withBaseDir(location);
        return this;
    }

    @Override
    public RatpackTextIoApp withPort(Integer portNumber) {
        if (portNumber != null) {
            this.server.withPort(portNumber);
        }
        return this;
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    public RatpackTextIoApp withSessionDataProvider(Function<Session, Map<String, String>> provider) {
        this.sessionDataProvider = provider;
        return this;
    }

    protected DataApi create(RatpackDataServer.ContextHolder ctxHolder, String initData) {
        String textTermSessionId = ctxHolder.contextId;
        logger.debug("Creating terminal for textTermSessionId: {}", (Object)textTermSessionId);
        WebTextTerminal terminal = this.termTemplate.createCopy();
        String mapKey = RatpackTextIoApp.getSessionIdMapKey(textTermSessionId);
        terminal.setOnDispose(() -> {
            if (this.onDispose != null) {
                this.onDispose.accept(textTermSessionId);
            }
            Executors.newSingleThreadScheduledExecutor().schedule(() -> this.webTextTerminalCache.invalidate((Object)mapKey), 5L, TimeUnit.SECONDS);
        });
        terminal.setOnAbort(() -> {
            if (this.onAbort != null) {
                this.onAbort.accept(textTermSessionId);
            }
            Executors.newSingleThreadScheduledExecutor().schedule(() -> this.webTextTerminalCache.invalidate((Object)mapKey), 5L, TimeUnit.SECONDS);
        });
        this.webTextTerminalCache.put((Object)mapKey, (Object)terminal);
        TextIO textIO = new TextIO((TextTerminal)terminal);
        RunnerData runnerData = this.createRunnerData(initData, ctxHolder);
        Thread thread = new Thread(() -> this.textIoRunner.accept(textIO, runnerData));
        thread.setDaemon(true);
        thread.start();
        this.webTextTerminalCache.cleanUp();
        return terminal;
    }

    private RunnerData createRunnerData(String initData, RatpackDataServer.ContextHolder ctxHolder) {
        RunnerData runnerData = new RunnerData(initData);
        Session session = (Session)ctxHolder.context.get(Session.class);
        Map<String, String> sessionData = this.sessionDataProvider.apply(session);
        runnerData.setSessionData(sessionData);
        return runnerData;
    }

    protected DataApi get(RatpackDataServer.ContextHolder ctxHolder) {
        String textTermSessionId = ctxHolder.contextId;
        String mapKey = RatpackTextIoApp.getSessionIdMapKey(textTermSessionId);
        WebTextTerminal terminal = (WebTextTerminal)this.webTextTerminalCache.getIfPresent((Object)mapKey);
        if (terminal == null) {
            throw new DataApiProviderException("Unknown session: " + textTermSessionId);
        }
        this.webTextTerminalCache.cleanUp();
        return terminal;
    }

    private static String getSessionIdMapKey(String textTermSessionId) {
        return "web-text-terminal-" + textTermSessionId;
    }
}

