/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.Participant;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.FreeAndBusyHandler;
import org.bedework.calsvc.scheduling.hosts.HostInfo;
import org.bedework.calsvc.scheduling.hosts.IscheduleClient;
import org.bedework.calsvc.scheduling.hosts.Response;
import org.bedework.convert.IcalTranslator;

public abstract class IScheduleHandler
extends FreeAndBusyHandler {
    private IscheduleClient calDav;

    IScheduleHandler(CalSvc svci) {
        super(svci);
    }

    protected void sendExternalRequest(ScheduleResult sr, EventInfo ei, Collection<UserInbox> inboxes) {
        Response r;
        HostInfo hi = null;
        BwEvent ev = ei.getEvent();
        boolean freeBusyRequest = ev.getEntityType() == 4;
        TreeSet<String> recipients = null;
        HashMap<String, UserInbox> uimap = new HashMap<String, UserInbox>();
        for (UserInbox ui : inboxes) {
            if (hi == null && ((hi = ui.host).getSupportsBedework() || hi.getSupportsCaldav() || hi.getSupportsISchedule())) {
                recipients = new TreeSet<String>();
            }
            if (recipients == null) {
                if (!this.debug()) continue;
                this.debug("freebusy request to " + hi.getFbUrl() + " for " + ui.recipient);
                continue;
            }
            recipients.add(ui.recipient);
            uimap.put(ui.recipient, ui);
        }
        if (recipients == null) {
            return;
        }
        if (this.debug()) {
            String meth = freeBusyRequest ? "freebusy" : "meeting";
            this.trace(meth + " request to " + hi.getFbUrl() + " for " + recipients);
        }
        EventInfo cei = this.copyEventInfo(ei, this.getPrincipal());
        cei.getEvent().setRecipients((Set)recipients);
        if (freeBusyRequest) {
            try {
                r = this.getCalDavClient().getFreeBusy(hi, cei);
            }
            catch (BedeworkException be) {
                this.error(be);
                return;
            }
            for (Response.ResponseElement re : r.getResponses()) {
                UserInbox ui = (UserInbox)((Object)uimap.get(re.getRecipient()));
                if (ui == null) continue;
                if (re.getCalData() == null) {
                    ui.setStatus(-1);
                    continue;
                }
                ui.freeBusy = re.getCalData().getEvent();
                ui.setStatus(0);
                sr.externalRcs.remove(ui.recipient);
            }
            return;
        }
        try {
            r = this.getCalDavClient().scheduleMeeting(hi, cei);
        }
        catch (BedeworkException be) {
            this.error(be);
            return;
        }
        for (Response.ResponseElement re : r.getResponses()) {
            UserInbox ui = (UserInbox)((Object)uimap.get(re.getRecipient()));
            if (ui == null) continue;
            ui.setStatus(0);
            sr.externalRcs.remove(ui.recipient);
        }
    }

    private IscheduleClient getCalDavClient() {
        if (this.calDav == null) {
            class PrivateKeysGetter
            extends IscheduleClient.PrivateKeys {
                PrivateKeysGetter() {
                }

                @Override
                public PrivateKey getKey(String domain, String service) {
                    try {
                        return IScheduleHandler.this.getEncrypter().getPrivateKey();
                    }
                    catch (Throwable t) {
                        throw new BedeworkException(t);
                    }
                }
            }
            this.calDav = new IscheduleClient(this.getSvc(), new IcalTranslator(this.getSvc().getIcalCallback()), new PrivateKeysGetter(), this.getSvc().getDirectories().getDefaultDomain());
        }
        return this.calDav;
    }

    protected static class UserInbox
    extends ScheduleResult.ScheduleRecipientResult {
        final BwEvent ev;
        BwPrincipal<?> principal;
        private final List<Participant> atts = new ArrayList<Participant>();
        String inboxPath;
        private HostInfo host;

        public UserInbox(BwEvent ev, String recipient) {
            this.ev = ev;
            this.recipient = recipient;
        }

        public void addAttendee(Participant val) {
            this.atts.add(val);
        }

        public void setAttendeeScheduleStatus(String val) {
            for (Participant att : this.atts) {
                att.setScheduleStatus(val);
            }
        }

        public void setHost(HostInfo val) {
            this.host = val;
        }

        public HostInfo getHost() {
            return this.host;
        }
    }
}

