/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.Participant;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.calfacade.SchedulingOwner;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.OrganizerSchedulingHandler;
import org.bedework.convert.Icalendar;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.misc.Util;

public abstract class AttendeeSchedulingHandler
extends OrganizerSchedulingHandler {
    AttendeeSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    public ScheduleResult requestRefresh(EventInfo ei, String comment) {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        if (ev.getScheduleMethod() != 2) {
            return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.badmethod"));
        }
        Participant att = this.findUserAttendee(ei);
        if (att == null) {
            return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.notattendee"));
        }
        BwEventObj outEv = new BwEventObj();
        EventInfo outEi = new EventInfo((BwEvent)outEv);
        SchedulingInfo outSi = outEv.getSchedulingInfo();
        outEv.setScheduleMethod(6);
        outSi.copyParticipant(att);
        outEv.setOriginator(att.getCalendarAddress());
        outSi.copySchedulingOwner(ev.getSchedulingInfo().getSchedulingOwner());
        SchedulingOwner outSchedOwner = outSi.getSchedulingOwner();
        outEv.addRecipient(outSchedOwner.getCalendarAddress());
        outEv.updateDtstamp();
        outSchedOwner.setSchedulingDtStamp(outEv.getDtstamp());
        outEv.setUid(ev.getUid());
        outEv.setRecurrenceId(ev.getRecurrenceId());
        outEv.setDtstart(ev.getDtstart());
        outEv.setDtend(ev.getDtend());
        outEv.setDuration(ev.getDuration());
        outEv.setNoStart(ev.getNoStart());
        outEv.setRecurring(Boolean.valueOf(false));
        if (comment != null) {
            outEv.addComment(new BwString(null, comment));
        }
        this.scheduleResponse(outEi, sr);
        if (sr.isOk()) {
            outEv.setScheduleState(1);
        }
        return sr;
    }

    public ScheduleResult attendeeRespond(EventInfo ei, int method, ScheduleResult res) {
        ScheduleResult sr = res == null ? new ScheduleResult() : res;
        BwEvent ev = ei.getEvent();
        SchedulingInfo si = ev.getSchedulingInfo();
        Participant att = this.findUserAttendee(ei);
        if (att == null) {
            return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.notattendee"));
        }
        if (ev.getOriginator() == null) {
            return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.noOriginator"));
        }
        EventInfo outEi = this.copyEventInfo(ei, this.getPrincipal());
        BwEvent outEv = outEi.getEvent();
        if (!Util.isEmpty((Collection)outEv.getRecipients())) {
            outEv.getRecipients().clear();
        }
        SchedulingInfo outSi = outEv.getSchedulingInfo();
        outSi.clearParticipants();
        SchedulingOwner sowner = ei.getSchedulingOwner();
        if (sowner == null) {
            throw new BedeworkException("No organizer");
        }
        outEv.addRecipient(sowner.getCalendarAddress());
        outEv.setOriginator(att.getCalendarAddress());
        outEv.updateDtstamp();
        sowner.setSchedulingDtStamp(outEv.getDtstamp());
        String delegate = att.getDelegatedTo();
        if (delegate != null) {
            outEv.setScheduleMethod(3);
            Participant delAtt = si.makeParticipant();
            delAtt.setCalendarAddress(delegate);
            delAtt.setDelegatedFrom(att.getCalendarAddress());
            delAtt.setParticipationStatus("NEEDS-ACTION");
            delAtt.setExpectReply(true);
            delAtt.setParticipationStatus(att.getParticipationStatus());
            EventInfo delegateEi = this.copyEventInfo(ei, this.getPrincipal());
            BwEvent delegateEv = delegateEi.getEvent();
            delegateEv.addRecipient(delegate);
            delegateEv.getSchedulingInfo().copyParticipant(delAtt);
            delegateEv.setScheduleMethod(2);
            att.setParticipationStatus("DELEGATED");
            att.setExpectReply(false);
            att.setDelegatedTo(delegate);
            if (!this.schedule(delegateEi, null, null, false, sr).isOk()) {
                return sr;
            }
        } else if (method == 3) {
            outEv.getSchedulingInfo().setOnlyParticipant(att);
            if (ev.getEntityType() == 7) {
                this.setPollResponse(outEi, ei, att.getCalendarAddress());
            }
            outEv.setScheduleMethod(3);
        } else if (method == 7) {
            outEv.getSchedulingInfo().setOnlyParticipant(att);
            outEv.setScheduleMethod(7);
        } else {
            throw new BedeworkException("Never get here");
        }
        outEv.addRequestStatus(new BwRequestStatus(IcalDefs.requestStatusSuccess.getCode(), IcalDefs.requestStatusSuccess.getDescription()));
        this.scheduleResponse(outEi, sr);
        if (sr.isOk()) {
            outEv.setScheduleState(1);
            sowner.setScheduleStatus("1.2");
        }
        return sr;
    }

    public ScheduleResult scheduleResponse(EventInfo ei, ScheduleResult res) {
        ScheduleResult sr = new ScheduleResult();
        try {
            Response addResp;
            int smethod = ei.getEvent().getScheduleMethod();
            if (!Icalendar.itipReplyMethodType((int)smethod)) {
                return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.badmethod"));
            }
            int outAccess = 12;
            if (ei.getMaxAttendees() > 1) {
                return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.bad.attendees"));
            }
            if (!this.initScheduleEvent(ei, true, false)) {
                return sr;
            }
            BwCalendar outBox = this.getSpecialCalendar(this.getPrincipal(), 6, true, 12);
            this.sendSchedule(sr, ei, null, null, false);
            if (sr.ignored) {
                return sr;
            }
            if (!sr.externalRcs.isEmpty() && !(addResp = this.addToOutBox(ei, outBox, sr.externalRcs)).isOk()) {
                return (ScheduleResult)Response.fromResponse((Response)sr, (Response)addResp);
            }
            return sr;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            return (ScheduleResult)Response.error((Response)sr, (Throwable)t);
        }
    }

    private void setPollResponse(EventInfo outEi, EventInfo ei, String attUri) {
        BwEvent ev = ei.getEvent();
        BwEvent outEv = outEi.getEvent();
        try {
            SchedulingInfo si = ev.getSchedulingInfo();
            Participant v = si.findParticipant(attUri);
            if (v == null) {
                this.warn("No participant element for " + attUri);
                return;
            }
            outEv.getSchedulingInfo().copyParticipant(v);
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }
}

