/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.util.Collection;
import java.util.TreeSet;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calsvc.directory.AbstractDirImpl;

public class GroupsDbImpl
extends AbstractDirImpl {
    public Collection<BwGroup<?>> getGroups(BwPrincipal<?> val) {
        return new TreeSet(this.cb.getGroups(val, false));
    }

    public Collection<BwGroup<?>> getAllGroups(BwPrincipal<?> val) {
        Collection<BwGroup<?>> groups = this.getGroups(val);
        TreeSet allGroups = new TreeSet(groups);
        for (BwGroup<?> grp : groups) {
            Collection<BwGroup<?>> gg = this.getAllGroups((BwPrincipal<?>)grp);
            if (gg.isEmpty()) continue;
            allGroups.addAll(gg);
        }
        return allGroups;
    }

    public boolean getGroupMaintOK() {
        return true;
    }

    public Collection<BwGroup<?>> getAll(boolean populate) {
        Collection gs = this.cb.getAll(false);
        if (!populate) {
            return gs;
        }
        for (BwGroup grp : gs) {
            this.getMembers(grp);
        }
        return gs;
    }

    public void getMembers(BwGroup<?> group) {
        group.setGroupMembers(this.cb.getMembers(group, false));
    }

    public void addGroup(BwGroup<?> group) {
        if (this.findGroup(group.getAccount()) != null) {
            throw new BedeworkException("org.bedework.exception.duplicateadmingroup");
        }
        this.cb.updateGroup(group, false);
    }

    public BwGroup<?> findGroup(String name) {
        return this.cb.findGroup(name, false);
    }

    public void addMember(BwGroup<?> group, BwPrincipal<?> val) {
        BwGroup<?> g = this.findGroup(group.getAccount());
        if (g == null) {
            throw new BedeworkException("Group " + group + " does not exist");
        }
        if (!this.checkPathForSelf(group, val)) {
            throw new BedeworkException("org.bedework.exception.alreadyonagrouppath");
        }
        g.addGroupMember(val);
        this.cb.addMember(group, val, false);
    }

    public void removeMember(BwGroup<?> group, BwPrincipal<?> val) {
        BwGroup<?> g = this.findGroup(group.getAccount());
        if (g == null) {
            throw new BedeworkException("Group " + group + " does not exist");
        }
        g.removeGroupMember(val);
        this.cb.removeMember(group, val, false);
    }

    public void removeGroup(BwGroup<?> group) {
        this.cb.removeGroup(group, false);
    }

    public void updateGroup(BwGroup<?> group) {
        this.cb.updateGroup(group, false);
    }

    public Collection<BwGroup<?>> findGroupParents(BwGroup<?> group) {
        return this.cb.findGroupParents(group, false);
    }

    public String getConfigName() {
        return "dir-config";
    }

    private boolean checkPathForSelf(BwGroup<?> group, BwPrincipal<?> val) {
        if (group.equals(val)) {
            return false;
        }
        for (BwGroup<?> g : this.findGroupParents(group)) {
            if (this.checkPathForSelf(g, val)) continue;
            return false;
        }
        return true;
    }
}

