/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.property.Kind;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.bedework.access.AccessPrincipal;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.DirectoryInfo;
import org.bedework.calfacade.configs.CalAddrPrefixes;
import org.bedework.calfacade.configs.CardDavInfo;
import org.bedework.calfacade.configs.Configurations;
import org.bedework.calfacade.configs.DirConfigProperties;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.util.caching.FlushMap;
import org.bedework.util.dav.DavUtil;
import org.bedework.util.http.HttpUtil;
import org.bedework.util.http.PooledHttpClient;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.BedeworkServerTags;
import org.bedework.util.xml.tagdefs.CaldavTags;
import org.bedework.util.xml.tagdefs.CarddavTags;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.shared.WebdavProperty;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDirImpl
implements Logged,
Directories {
    public static final int SC_MULTI_STATUS = 207;
    private CalAddrPrefixes caPrefixes;
    private CardDavInfo authCdinfo;
    private CardDavInfo unauthCdinfo;
    private DirConfigProperties dirProps;
    private static Collection<CAPrefixInfo> caPrefixInfo;
    private DomainMatcher onlyDomain;
    private boolean anyDomain;
    private String defaultDomain;
    private Collection<DomainMatcher> domains;
    protected Directories.CallBack cb;
    private final HashMap<String, Integer> toWho = new HashMap();
    private final HashMap<Integer, String> fromWho = new HashMap();
    private static final FlushMap<String, String> validPrincipals;
    private static final FlushMap<String, BwPrincipalInfo> principalInfoMap;
    private static final CutypeMap cutypeMap;
    private static final int maxCaMapSize = 3000;
    private static final long maxCaRefreshTime = 300000L;
    protected static Map<String, String> userToCalAddrMap;
    protected static Map<String, BwPrincipal<?>> calAddrToPrincipalMap;
    private final BwLogger logger = new BwLogger();

    public void init(Directories.CallBack cb, Configurations configs) {
        this.cb = cb;
        this.caPrefixes = configs.getDirConfig(this.getConfigName()).getCalAddrPrefixes();
        this.authCdinfo = configs.getCardDavInfo(true);
        this.unauthCdinfo = configs.getCardDavInfo(false);
        this.dirProps = configs.getDirConfig(this.getConfigName());
        this.setDomains();
        this.initWhoMaps("/principals/users/", 1);
        this.initWhoMaps("/principals/groups/", 2);
        this.initWhoMaps("/principals/tickets/", 4);
        this.initWhoMaps("/principals/resources/", 5);
        this.initWhoMaps("/principals/locations/", 6);
        this.initWhoMaps("/principals/hosts/", 3);
    }

    public DirectoryInfo getDirectoryInfo() {
        DirectoryInfo info = new DirectoryInfo();
        info.setPrincipalRoot("/principals/");
        info.setUserPrincipalRoot("/principals/users/");
        info.setGroupPrincipalRoot("/principals/groups/");
        info.setBwadmingroupPrincipalRoot("/principals/groups/bwadmin/");
        info.setTicketPrincipalRoot("/principals/tickets/");
        info.setResourcePrincipalRoot("/principals/resources/");
        info.setVenuePrincipalRoot("/principals/locations/");
        info.setHostPrincipalRoot("/principals/hosts/");
        return info;
    }

    public synchronized boolean validPrincipal(String href) {
        if (href == null) {
            return false;
        }
        if (this.lookupValidPrincipal(href)) {
            return true;
        }
        boolean valid = !href.startsWith("invalid");
        try {
            new URI(href);
        }
        catch (Throwable t) {
            valid = false;
        }
        if (valid) {
            this.addValidPrincipal(href);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BwPrincipalInfo getDirInfo(BwPrincipal<?> p) {
        BwPrincipalInfo pi = (BwPrincipalInfo)principalInfoMap.get((Object)p.getPrincipalRef());
        if (pi != null) {
            return pi;
        }
        CardDavInfo cdi = this.getCardDavInfo(false);
        if (cdi == null || cdi.getUrl() == null) {
            return null;
        }
        PooledHttpClient cdc = null;
        pi = new BwPrincipalInfo();
        try {
            cdc = new PooledHttpClient(new URI(cdi.getUrl()));
            pi.setPropertiesFromVCard(this.getCard(cdc, (AccessPrincipal)p), "text/vcard");
        }
        catch (Throwable t) {
            if (this.getLogger().isDebugEnabled()) {
                this.error(t);
            }
        }
        finally {
            if (cdc != null) {
                cdc.release();
            }
        }
        principalInfoMap.put((Object)p.getPrincipalRef(), (Object)pi);
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directories.FindPrincipalsResult find(List<WebdavProperty> props, List<WebdavProperty> returnProps, String cutype) {
        CardDavInfo cdi = this.getCardDavInfo(false);
        if (cdi == null || cdi.getUrl() == null) {
            return null;
        }
        PooledHttpClient cdc = null;
        String path = this.getCutypePath(cutype, cdi);
        String addrCtype = null;
        for (WebdavProperty wd : returnProps) {
            if (!wd.getTag().equals(CarddavTags.addressData)) continue;
            addrCtype = wd.getAttr("content-type");
            break;
        }
        try {
            try {
                cdc = new PooledHttpClient(new URI(cdi.getUrl()));
            }
            catch (URISyntaxException e) {
                throw new BedeworkException((Throwable)e);
            }
            List<MatchResult> mrs = this.matching(cdc, path, addrCtype, props);
            ArrayList<BwPrincipalInfo> pis = new ArrayList<BwPrincipalInfo>();
            if (mrs == null) {
                Directories.FindPrincipalsResult findPrincipalsResult = new Directories.FindPrincipalsResult(pis, false);
                return findPrincipalsResult;
            }
            for (MatchResult mr : mrs) {
                BwPrincipalInfo pi = new BwPrincipalInfo();
                pi.setPropertiesFromVCard(mr.card, addrCtype);
                pis.add(pi);
            }
            Directories.FindPrincipalsResult findPrincipalsResult = new Directories.FindPrincipalsResult(pis, false);
            return findPrincipalsResult;
        }
        finally {
            if (cdc != null) {
                cdc.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directories.FindPrincipalsResult find(String cua, String cutype, boolean expand) {
        CardDavInfo cdi = this.getCardDavInfo(false);
        if (cdi == null || cdi.getUrl() == null) {
            return null;
        }
        PooledHttpClient cdc = null;
        try {
            try {
                cdc = new PooledHttpClient(new URI(cdi.getUrl()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            List<BwPrincipalInfo> pis = this.find(cdc, cdi, cua, cutype);
            if (!expand) {
                Directories.FindPrincipalsResult findPrincipalsResult = new Directories.FindPrincipalsResult(pis, false);
                return findPrincipalsResult;
            }
            for (BwPrincipalInfo pi : pis) {
                if (!Kind.GROUP.getValue().equalsIgnoreCase(pi.getKind())) continue;
                ArrayList<BwPrincipalInfo> memberPis = new ArrayList<BwPrincipalInfo>();
                VCard card = pi.getCard();
                List members = card.getProperties(Property.Id.MEMBER);
                if (members == null) continue;
                for (Property p : members) {
                    BwPrincipalInfo memberPi = this.fetch(cdc, cdi, p.getValue());
                    if (memberPi == null) continue;
                    memberPis.add(memberPi);
                }
                pi.setMembers(memberPis);
            }
            Directories.FindPrincipalsResult findPrincipalsResult = new Directories.FindPrincipalsResult(pis, false);
            return findPrincipalsResult;
        }
        finally {
            if (cdc != null) {
                cdc.release();
            }
        }
    }

    private BwPrincipalInfo fetch(PooledHttpClient cdc, CardDavInfo cdi, String uri) {
        List<BwPrincipalInfo> pis = this.find(cdc, cdi, uri, CuType.INDIVIDUAL.getValue());
        if (pis == null || pis.size() != 1) {
            return null;
        }
        return pis.get(0);
    }

    private List<BwPrincipalInfo> find(PooledHttpClient cdc, CardDavInfo cdi, String cua, String cutype) {
        ArrayList<WebdavProperty> props = new ArrayList<WebdavProperty>();
        CalAddr ca = new CalAddr(cua);
        if (cutype != null && cutype.equalsIgnoreCase(CuType.GROUP.getValue())) {
            WebdavProperty fnProp = new WebdavProperty(WebdavTags.displayname, ca.getId());
            props.add(fnProp);
        }
        WebdavProperty emailProp = new WebdavProperty(BedeworkServerTags.emailProp, ca.getNoScheme());
        props.add(emailProp);
        ArrayList<BwPrincipalInfo> pis = new ArrayList<BwPrincipalInfo>();
        List<MatchResult> mrs = this.matching(cdc, this.getCutypePath(cutype, cdi), null, props);
        if (mrs == null) {
            return pis;
        }
        for (MatchResult mr : mrs) {
            BwPrincipalInfo pi = new BwPrincipalInfo();
            pi.setPropertiesFromVCard(mr.card, null);
            pis.add(pi);
        }
        return pis;
    }

    private String getCutypePath(String cutype, CardDavInfo cdi) {
        String msg = cutypeMap.init(cdi.getCutypeMapping());
        if (msg.length() > 0) {
            this.warn(msg);
        }
        if (cutype == null) {
            return cutypeMap.getDefaultPath();
        }
        String cutypePath = (String)cutypeMap.get(cutype.toLowerCase());
        if (cutypePath != null) {
            return cutypePath;
        }
        return cutypeMap.getDefaultPath();
    }

    private Set<String> getCutypes(CardDavInfo cdi) {
        cutypeMap.init(cdi.getCutypeMapping());
        return cutypeMap.getCutypes();
    }

    public boolean mergePreferences(BwPreferences prefs, BwPrincipalInfo pinfo) {
        BwPrincipalInfo.IntPrincipalProperty pschedMaxInstances;
        boolean changed = false;
        BwPrincipalInfo.BooleanPrincipalProperty pautoSched = (BwPrincipalInfo.BooleanPrincipalProperty)pinfo.findProperty("auto-schedule");
        if (pautoSched != null && ((Boolean)pautoSched.getVal()).booleanValue() != prefs.getScheduleAutoRespond()) {
            prefs.setScheduleAutoRespond(((Boolean)pautoSched.getVal()).booleanValue());
            if (((Boolean)pautoSched.getVal()).booleanValue()) {
                prefs.setScheduleAutoCancelAction(BwPreferences.scheduleAutoCancelDelete);
            }
            changed = true;
        }
        if ((pschedMaxInstances = (BwPrincipalInfo.IntPrincipalProperty)pinfo.findProperty("max-instances")) != null) {
            int mi = (Integer)pschedMaxInstances.getVal();
            String strMi = String.valueOf(mi);
            BwProperty pmi = prefs.findProperty("userpref:schedule-max-instances");
            if (pmi == null) {
                prefs.addProperty(new BwProperty("userpref:schedule-max-instances", strMi));
            } else if (!pmi.getValue().equals(strMi)) {
                pmi.setValue(strMi);
            }
            changed = true;
        }
        return changed;
    }

    public boolean isPrincipal(String val) {
        return BwPrincipal.isPrincipal((String)val);
    }

    public String accountFromPrincipal(String val) {
        String userProot = this.fromWho.get(1);
        if (!val.startsWith(userProot)) {
            return null;
        }
        String acc = val.substring(userProot.length());
        if (acc.endsWith("/")) {
            acc = acc.substring(0, acc.length() - 1);
        }
        if (acc.indexOf("/") > 0) {
            return null;
        }
        return acc;
    }

    public BwPrincipal<?> getPrincipal(String href) {
        return BwPrincipal.makePrincipal((String)href);
    }

    public String makePrincipalUri(String id, int whoType) {
        if (this.isPrincipal(id)) {
            return id;
        }
        String root = this.fromWho.get(whoType);
        if (root == null) {
            throw new RuntimeException("org.bedework.exception.unknownprincipaltype");
        }
        return Util.buildPath((boolean)false, (String[])new String[]{root, "/", id});
    }

    public Collection<String> getGroups(String rootUrl, String principalUrl) {
        TreeSet<String> urls = new TreeSet<String>();
        if (principalUrl == null) {
            String r = Util.buildPath((boolean)true, (String[])new String[]{rootUrl});
            if (!r.equals("/principals/") && !r.equals("/principals/users/")) {
                return urls;
            }
            urls.add(Util.buildPath((boolean)false, (String[])new String[]{"/principals/users/", "/", this.cb.getCurrentUser().getAccount()}));
        }
        return urls;
    }

    public String uriToCaladdr(String val) {
        if (this.isPrincipal(val)) {
            return this.userToCaladdr(val);
        }
        boolean isAccount = true;
        int colonPos = val.indexOf(":");
        int atPos = val.indexOf("@");
        Object uri = val;
        if (colonPos > 0) {
            if (atPos < colonPos) {
                return null;
            }
            isAccount = false;
        } else if (atPos > 0) {
            uri = "mailto:" + val;
        }
        BwPrincipal<?> possibleAccount = this.caladdrToPrincipal((String)uri);
        if (possibleAccount != null && !this.validPrincipal(possibleAccount.getPrincipalRef())) {
            return null;
        }
        if (isAccount) {
            uri = this.userToCaladdr((String)uri);
        }
        return uri;
    }

    public String principalToCaladdr(AccessPrincipal val) {
        return this.userToCaladdr(val.getAccount());
    }

    public String userToCaladdr(String val) {
        Object ca = userToCalAddrMap.get(val);
        if (ca != null) {
            return ca;
        }
        if (this.isPrincipal(val)) {
            BwPrincipal<?> p = this.getPrincipal(val);
            ca = p.getKind() == 1 ? this.userToCaladdr(p.getAccount()) : val;
            userToCalAddrMap.put(val, (String)ca);
            return ca;
        }
        this.getProps();
        int atPos = val.indexOf("@");
        boolean hasMailto = val.toLowerCase().startsWith("mailto:");
        if (atPos > 0) {
            if (hasMailto) {
                return "mailto:" + val.substring(7);
            }
            ca = "mailto:" + val;
            userToCalAddrMap.put(val, (String)ca);
            return ca;
        }
        StringBuilder sb = new StringBuilder();
        if (!hasMailto) {
            sb.append("mailto:");
        }
        sb.append(val);
        sb.append("@");
        sb.append(this.getDefaultDomain());
        ca = sb.toString();
        userToCalAddrMap.put(val, (String)ca);
        return ca;
    }

    public BwPrincipal<?> caladdrToPrincipal(String caladdr) {
        String acc;
        BwPrincipal<?> p;
        block14: {
            int atPos;
            String ca;
            block13: {
                if (caladdr == null) {
                    throw new RuntimeException("org.bedework.caladdr.null");
                }
                p = calAddrToPrincipalMap.get(caladdr);
                if (p != null) {
                    return p;
                }
                this.getProps();
                if (this.isPrincipal(caladdr)) {
                    p = this.getPrincipal(caladdr);
                    calAddrToPrincipalMap.put(caladdr, p);
                    return p;
                }
                acc = null;
                ca = caladdr;
                atPos = ca.indexOf("@");
                if (atPos > 0) {
                    ca = ca.toLowerCase();
                }
                if (this.onlyDomain == null) break block13;
                if (atPos < 0) {
                    acc = ca;
                }
                if (!this.onlyDomain.matches(ca, atPos)) break block14;
                acc = ca.substring(0, atPos);
                break block14;
            }
            if (atPos < 0) {
                acc = ca;
            } else if (this.anyDomain) {
                acc = ca;
            } else {
                for (DomainMatcher dm : this.domains) {
                    if (!dm.matches(ca, atPos)) continue;
                    acc = ca;
                    break;
                }
            }
        }
        if (acc == null) {
            return null;
        }
        if (acc.toLowerCase().startsWith("mailto:")) {
            acc = acc.substring("mailto:".length());
        }
        int whoType = 1;
        for (CAPrefixInfo c : this.getCaPrefixInfo()) {
            if (!acc.startsWith(c.getPrefix())) continue;
            whoType = c.getType();
            break;
        }
        p = this.getPrincipal(this.makePrincipalUri(acc, whoType));
        calAddrToPrincipalMap.put(caladdr, p);
        return p;
    }

    public String normalizeCua(String val) {
        if (val == null) {
            throw new BedeworkException("org.bedework.caladdr.bad");
        }
        if (val.startsWith("/")) {
            return val;
        }
        int colonPos = val.indexOf(":");
        int atPos = val.indexOf("@");
        if (colonPos > 0) {
            if (atPos < colonPos) {
                throw new BedeworkException("org.bedework.caladdr.bad");
            }
            return "mailto:" + val.substring(colonPos + 1);
        }
        if (atPos > 0) {
            return "mailto:" + val;
        }
        return "mailto:" + val + "@" + this.getDefaultDomain();
    }

    public String getDefaultDomain() {
        if (this.defaultDomain == null) {
            throw new RuntimeException("org.bedework.domains.nodefault");
        }
        return this.defaultDomain;
    }

    public String getAdminGroupsIdPrefix() {
        return null;
    }

    protected synchronized boolean lookupValidPrincipal(String href) {
        return validPrincipals.containsKey((Object)href);
    }

    protected void addValidPrincipal(String href) {
        validPrincipals.put((Object)href, (Object)href);
    }

    protected DirConfigProperties getProps() {
        return this.dirProps;
    }

    protected CalAddrPrefixes getCaPrefixes() {
        return this.caPrefixes;
    }

    protected Collection<CAPrefixInfo> getCaPrefixInfo() {
        if (caPrefixInfo != null) {
            return caPrefixInfo;
        }
        CalAddrPrefixes cap = this.getCaPrefixes();
        ArrayList<CAPrefixInfo> capInfo = new ArrayList<CAPrefixInfo>();
        if (cap != null) {
            this.addCaPrefix(capInfo, cap.getUser(), 1);
            this.addCaPrefix(capInfo, cap.getGroup(), 2);
            this.addCaPrefix(capInfo, cap.getHost(), 3);
            this.addCaPrefix(capInfo, cap.getTicket(), 4);
            this.addCaPrefix(capInfo, cap.getResource(), 5);
            this.addCaPrefix(capInfo, cap.getLocation(), 6);
        }
        caPrefixInfo = Collections.unmodifiableList(capInfo);
        return caPrefixInfo;
    }

    private void addCaPrefix(List<CAPrefixInfo> capInfo, String prefix, int type) {
        if (prefix == null) {
            return;
        }
        capInfo.add(new CAPrefixInfo(prefix, type));
    }

    protected CardDavInfo getCardDavInfo(boolean auth) {
        if (auth) {
            return this.authCdinfo;
        }
        return this.unauthCdinfo;
    }

    private void setDomains() {
        String prDomains = this.dirProps.getDomains();
        if (prDomains.equals("*")) {
            this.anyDomain = true;
        } else if (!prDomains.contains(",") && !prDomains.startsWith("*")) {
            this.onlyDomain = new DomainMatcher(prDomains);
        } else {
            this.domains = new ArrayList<DomainMatcher>();
            for (String domain : this.dirProps.getDomains().split(",")) {
                this.domains.add(new DomainMatcher(domain));
            }
        }
        this.defaultDomain = this.dirProps.getDefaultDomain();
        if (this.defaultDomain == null && this.onlyDomain != null) {
            this.defaultDomain = prDomains;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MatchResult> matching(PooledHttpClient cl, String url, String addrDataCtype, List<WebdavProperty> props) {
        PooledHttpClient.ResponseHolder resp;
        XmlEmit xml = new XmlEmit();
        xml.addNs(new XmlEmit.NameSpace("DAV:", "DAV"), true);
        xml.addNs(new XmlEmit.NameSpace("urn:ietf:params:xml:ns:carddav", "C"), false);
        StringWriter sw = new StringWriter();
        xml.startEmit((Writer)sw);
        xml.openTag(CarddavTags.addressbookQuery);
        xml.openTag(WebdavTags.prop);
        xml.emptyTag(WebdavTags.getetag);
        if (addrDataCtype == null) {
            xml.emptyTag(CarddavTags.addressData);
        } else {
            xml.emptyTag(CarddavTags.addressData, "content-type", addrDataCtype);
        }
        xml.closeTag(WebdavTags.prop);
        xml.openTag(CarddavTags.filter, "test", "anyof");
        for (WebdavProperty wd : props) {
            if (wd.getTag().equals(CaldavTags.calendarUserType)) continue;
            if (wd.getTag().equals(BedeworkServerTags.emailProp)) {
                xml.openTag(CarddavTags.propFilter, "name", "EMAIL");
                xml.startTagSameLine(CarddavTags.textMatch);
                xml.attribute("collation", "i;unicode-casemap");
                xml.attribute("match-type", "contains");
                xml.endOpeningTag();
                xml.value(wd.getPval());
                xml.closeTagSameLine(CarddavTags.textMatch);
                xml.closeTag(CarddavTags.propFilter);
                continue;
            }
            if (!wd.getTag().equals(WebdavTags.displayname)) continue;
            xml.openTag(CarddavTags.propFilter, "name", "FN");
            xml.startTagSameLine(CarddavTags.textMatch);
            xml.attribute("collation", "i;unicode-casemap");
            xml.attribute("match-type", "contains");
            xml.endOpeningTag();
            xml.value(wd.getPval());
            xml.closeTagSameLine(CarddavTags.textMatch);
            xml.closeTag(CarddavTags.propFilter);
        }
        xml.closeTag(CarddavTags.filter);
        xml.closeTag(CarddavTags.addressbookQuery);
        byte[] content = sw.toString().getBytes();
        try {
            resp = cl.report(url, "infinity", new String(content), this::processMatchingResponse);
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
        if (resp.failed) {
            if (this.debug()) {
                this.debug("Got response " + resp.status + " for path " + url);
            }
            List<MatchResult> list = null;
            return list;
        }
        List list = (List)resp.response;
        return list;
        finally {
            try {
                cl.release();
            }
            catch (Throwable throwable) {}
        }
    }

    final PooledHttpClient.ResponseHolder<?> processMatchingResponse(String path, CloseableHttpResponse resp) {
        try {
            int status = HttpUtil.getStatus((HttpResponse)resp);
            if (status != 207) {
                return new PooledHttpClient.ResponseHolder(status, "Failed response from server");
            }
            if (resp.getEntity() == null) {
                return new PooledHttpClient.ResponseHolder(status, "No content in response from server");
            }
            InputStream is = resp.getEntity().getContent();
            DavUtil du = new DavUtil();
            DavUtil.MultiStatusResponse msr = du.getMultiStatusResponse(is);
            ArrayList<MatchResult> mrs = new ArrayList<MatchResult>();
            for (DavUtil.MultiStatusResponseElement msre : msr.responses) {
                MatchResult mr = new MatchResult();
                mrs.add(mr);
                mr.href = msre.href;
                for (DavUtil.PropstatElement pe : msre.propstats) {
                    if (pe.status != 200) continue;
                    for (Element e : pe.props) {
                        if (XmlUtil.nodeMatches((Node)e, (QName)WebdavTags.getetag)) {
                            mr.etag = XmlUtil.getElementContent((Node)e);
                            continue;
                        }
                        if (!XmlUtil.nodeMatches((Node)e, (QName)CarddavTags.addressData)) continue;
                        mr.card = XmlUtil.getElementContent((Node)e);
                    }
                }
            }
            PooledHttpClient.ResponseHolder response = new PooledHttpClient.ResponseHolder(mrs);
            return response;
        }
        catch (Throwable t) {
            return new PooledHttpClient.ResponseHolder(t);
        }
    }

    private String getCard(PooledHttpClient cl, AccessPrincipal p) {
        String string;
        try {
            String content = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<D:propfind xmlns:D=\"DAV:\"\n            xmlns:C=\"urn:ietf:params:xml:ns:carddav\">\n  <D:prop>\n    <C:principal-address/>\n  </D:prop>\n</D:propfind>\n";
            PooledHttpClient.ResponseHolder resp = cl.propfind(p.getPrincipalRef(), "0", "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<D:propfind xmlns:D=\"DAV:\"\n            xmlns:C=\"urn:ietf:params:xml:ns:carddav\">\n  <D:prop>\n    <C:principal-address/>\n  </D:prop>\n</D:propfind>\n", this::processGetCardHrefResponse);
            if (resp.failed) {
                if (this.debug()) {
                    this.debug("Got response " + resp.status + " for path " + p.getPrincipalRef());
                }
                String string2 = null;
                return string2;
            }
            String href = (String)resp.response;
            string = cl.getString(href, "text/vcard");
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
        finally {
            try {
                cl.release();
            }
            catch (Throwable throwable) {}
        }
        return string;
    }

    final PooledHttpClient.ResponseHolder<?> processGetCardHrefResponse(String path, CloseableHttpResponse resp) {
        try {
            int status = HttpUtil.getStatus((HttpResponse)resp);
            if (status != 207) {
                return new PooledHttpClient.ResponseHolder(status, "Failed response from server");
            }
            if (resp.getEntity() == null) {
                return new PooledHttpClient.ResponseHolder(status, "No content in response from server");
            }
            InputStream is = resp.getEntity().getContent();
            DavUtil du = new DavUtil();
            DavUtil.MultiStatusResponse msr = du.getMultiStatusResponse(is);
            if (msr.responses.size() != 1) {
                throw new BedeworkException("Bad response. Expected exactly 1 response element");
            }
            DavUtil.MultiStatusResponseElement msre = (DavUtil.MultiStatusResponseElement)msr.responses.get(0);
            if (msre.propstats.size() != 1) {
                if (this.debug()) {
                    this.debug("Found " + msre.propstats.size() + " propstat elements");
                }
                return new PooledHttpClient.ResponseHolder(406, "Found " + msre.propstats.size() + " propstat elements");
            }
            DavUtil.PropstatElement pse = (DavUtil.PropstatElement)msre.propstats.get(0);
            if (pse.status != 200) {
                if (this.debug()) {
                    this.debug("propstat status was " + pse.status);
                }
                return new PooledHttpClient.ResponseHolder(406, "propstat status was " + pse.status);
            }
            if (pse.props.size() != 1) {
                if (this.debug()) {
                    this.debug("Found " + pse.props.size() + " prop elements");
                }
                return new PooledHttpClient.ResponseHolder(406, "Found " + pse.props.size() + " prop elements");
            }
            Element pr = (Element)pse.props.iterator().next();
            if (!XmlUtil.nodeMatches((Node)pr, (QName)CarddavTags.principalAddress)) {
                if (this.debug()) {
                    this.debug("Expected principal-address - found " + pr);
                }
                return new PooledHttpClient.ResponseHolder(406, "Expected principal-address - found " + pr);
            }
            Element hrefEl = DavUtil.getOnlyChild((Node)pr);
            if (!XmlUtil.nodeMatches((Node)hrefEl, (QName)WebdavTags.href)) {
                if (this.debug()) {
                    this.debug("Expected href element for principal-address - found " + hrefEl);
                }
                return new PooledHttpClient.ResponseHolder(406, "Expected href element for principal-address - found " + hrefEl);
            }
            return new PooledHttpClient.ResponseHolder((Object)URLDecoder.decode(XmlUtil.getElementContent((Node)hrefEl), StandardCharsets.UTF_8));
        }
        catch (Throwable t) {
            return new PooledHttpClient.ResponseHolder(t);
        }
    }

    private void initWhoMaps(String prefix, int whoType) {
        this.toWho.put(prefix, whoType);
        this.fromWho.put(whoType, prefix);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    static {
        validPrincipals = new FlushMap(300000L, 0);
        principalInfoMap = new FlushMap(300000L, 0);
        cutypeMap = new CutypeMap();
        userToCalAddrMap = new FlushMap(300000L, 3000);
        calAddrToPrincipalMap = new FlushMap(300000L, 3000);
    }

    private static class MatchResult {
        String href;
        String etag;
        String card;

        private MatchResult() {
        }
    }

    private static class CalAddr {
        private String scheme;
        private String id;
        private String domain;

        CalAddr(String val) {
            int atPos = val.indexOf("@");
            if (atPos > 0) {
                this.domain = val.substring(atPos + 1).toLowerCase();
                this.id = val.substring(0, atPos);
            } else {
                this.id = val;
            }
            int colonPos = this.id.indexOf(":");
            if (colonPos > 0) {
                this.scheme = this.id.substring(0, colonPos);
                this.id = this.id.substring(colonPos + 1);
            }
        }

        String getScheme() {
            return this.scheme;
        }

        String getId() {
            return this.id;
        }

        String getDomain() {
            return this.domain;
        }

        String getNoScheme() {
            if (this.domain == null) {
                return this.id;
            }
            return this.id + "@" + this.domain;
        }
    }

    private static class CutypeMap
    extends HashMap<String, String> {
        String configValue;
        String defaultPath;

        private CutypeMap() {
        }

        String init(String configValue) {
            if (configValue == null) {
                this.clear();
                this.defaultPath = "/directory/";
                return "No cutype mapping in carddav info";
            }
            if (configValue.equals(this.configValue)) {
                return "";
            }
            this.configValue = configValue;
            String[] split = configValue.split(",");
            Object err = "";
            for (String s : split) {
                String[] keyVal = s.split(":");
                if (keyVal.length != 2) {
                    err = (String)err + "\nBad value in cutype mapping: " + s;
                    continue;
                }
                if (keyVal[0].equals("*")) {
                    if (this.defaultPath != null) {
                        err = (String)err + "\nMore than one default path in cutype mapping";
                        continue;
                    }
                    this.defaultPath = keyVal[1];
                    continue;
                }
                this.put(keyVal[0], keyVal[1]);
            }
            if (this.defaultPath == null) {
                err = (String)err + "\nNo default path in cutype mapping";
                this.defaultPath = "/directory/";
            }
            return err;
        }

        String getDefaultPath() {
            return this.defaultPath;
        }

        Set<String> getCutypes() {
            return this.keySet();
        }
    }

    private static class DomainMatcher
    implements Serializable {
        String pattern;
        boolean exact;

        DomainMatcher(String pattern) {
            this.pattern = pattern;
            if (!pattern.startsWith("*")) {
                this.pattern = pattern;
                this.exact = true;
            } else {
                this.pattern = pattern.substring(1);
            }
        }

        boolean matches(String val, int atPos) {
            if (atPos < 0) {
                return false;
            }
            int start = atPos + 1;
            int domainLen = val.length() - start;
            if (this.exact ? domainLen != this.pattern.length() : domainLen < this.pattern.length()) {
                return false;
            }
            return val.endsWith(this.pattern);
        }

        boolean matches(String domain) {
            int domainLen = domain.length();
            if (this.exact ? domainLen != this.pattern.length() : domainLen < this.pattern.length()) {
                return false;
            }
            return domain.endsWith(this.pattern);
        }
    }

    public static class CAPrefixInfo {
        private final String prefix;
        private final int type;

        CAPrefixInfo(String prefix, int type) {
            this.prefix = prefix;
            this.type = type;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getType() {
            return this.type;
        }
    }
}

