/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import java.util.TreeSet;
import org.bedework.base.exc.BedeworkAccessException;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calcorei.CoreEventInfo;
import org.bedework.calcorei.CoreEventsI;
import org.bedework.caldav.util.sharing.AccessType;
import org.bedework.caldav.util.sharing.InviteType;
import org.bedework.caldav.util.sharing.UserType;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.BwSystem;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.RestoreIntf;
import org.bedework.util.logging.Logged;
import org.bedework.util.xml.tagdefs.AppleServerTags;

class RestoreImpl
extends CalSvcDb
implements RestoreIntf {
    private Logged log;
    protected int currentMode = 1;
    private boolean transactionStarted;
    private int curBatchSize;
    private int batchSize;

    RestoreImpl(CalSvc svci) {
        super(svci);
    }

    public void setLogger(Logged val) {
        this.log = val;
    }

    public void setBatchSize(int val) {
        this.batchSize = val;
    }

    public void endTransactionNow() {
        if (this.transactionStarted) {
            this.getSvc().endTransaction();
            this.getSvc().close();
        }
        this.transactionStarted = false;
        this.curBatchSize = 0;
    }

    public void endTransaction() {
        if (this.batchSize > 0 && this.curBatchSize < this.batchSize) {
            return;
        }
        this.endTransactionNow();
    }

    public void checkEmptySystem() {
        try {
            this.startTransaction();
            if (this.getSvc().getSysparsHandler().present()) {
                throw new BedeworkException("System is not empty - restore terminated");
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreSyspars(BwSystem o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restorePrincipal(BwPrincipal<?> o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().addRestoredEntity(o);
        }
        catch (Throwable t) {
            this.handleException(t, "Exception restoring user " + o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreAdminGroup(BwAdminGroup o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
            if (this.debug()) {
                this.log.debug("Saved admin group " + o);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void addAdminGroupMember(BwAdminGroup o, BwPrincipal<?> pr) {
        try {
            this.startTransaction();
            this.getCal().addMember((BwGroup)o, pr, true);
        }
        finally {
            this.endTransaction();
        }
    }

    public BwAdminGroup getAdminGroup(String account) {
        this.startTransaction();
        return (BwAdminGroup)this.getCal().findGroup(account, true);
    }

    public void restoreAuthUser(BwAuthUser o) {
        try {
            this.startTransaction();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreEvent(EventInfo ei) {
        try {
            this.startTransaction();
            CoreEventsI.UpdateEventResult uer = this.getCal().addEvent(ei, false, false);
            if (!uer.addedUpdated) {
                throw new BedeworkException(uer.errorCode);
            }
            if (uer.failedOverrides != null) {
                this.error("Following overrides failed for event ");
                this.error(ei.getEvent().toString());
                for (BwEventProxy proxy : uer.failedOverrides) {
                    this.error(proxy.toString());
                }
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public BwEvent getEvent(BwPrincipal<?> owner, String colPath, String recurrenceId, String uid) {
        this.startTransaction();
        Collection ceis = this.getCal().getEvent(colPath, uid);
        if (ceis.size() != 1) {
            this.error("Expected one event for {" + colPath + ", " + recurrenceId + ", " + uid + "} found " + ceis.size());
            return null;
        }
        CoreEventInfo ei = (CoreEventInfo)ceis.iterator().next();
        BwEvent ev = null;
        if (recurrenceId == null) {
            ev = ei.getEvent();
        } else {
            for (CoreEventInfo cei : ei.getOverrides()) {
                if (!cei.getEvent().getRecurrenceId().equals(recurrenceId)) continue;
                ev = cei.getEvent();
                break;
            }
        }
        if (ev == null) {
            return null;
        }
        if (ev instanceof BwEventAnnotation) {
            ev = new BwEventProxy((BwEventAnnotation)ev);
        }
        return ev;
    }

    public void restoreCategory(BwCategory o) {
        try {
            this.startTransaction();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreCalSuite(BwCalSuite o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().add(o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreLocation(BwLocation o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreContact(BwContact o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreFilter(BwFilterDef o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreResource(BwResource o) {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().add(o);
            BwResourceContent rc = o.getContent();
            rc.markUnsaved();
            rc.setByteValue(rc.getByteValue());
            this.getCal().addContent(o, rc);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreUserPrefs(BwPreferences o) {
        try {
            this.startTransaction();
            BwPreferences p = this.getSvc().getPreferences(o.getOwnerHref());
            if (p != null) {
                this.warn("Found instance of preferences for " + o.getOwnerHref());
                o.setId(p.getId());
                o.setSeq(p.getSeq());
                this.getCal().update(o);
            } else {
                Collection v = o.getViews();
                if (v != null) {
                    for (BwView view : v) {
                        view.markUnsaved();
                    }
                }
                o.markUnsaved();
                this.getCal().add(o);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public BwCalendar getCalendar(String path) {
        this.startTransaction();
        return this.getCols().get(path);
    }

    public BwCategory getCategory(String uid) {
        this.startTransaction();
        return (BwCategory)this.getSvc().getCategoriesHandler().getPersistent(uid);
    }

    public BwContact getContact(String uid) {
        this.startTransaction();
        return (BwContact)this.getSvc().getContactsHandler().getPersistent(uid);
    }

    public BwLocation getLocation(String uid) {
        this.startTransaction();
        return (BwLocation)this.getSvc().getLocationsHandler().getPersistent(uid);
    }

    public BwPrincipal<?> getPrincipal(String href) {
        this.startTransaction();
        return this.getSvc().getUsersHandler().getPrincipal(href);
    }

    public void saveRootCalendar(BwCalendar val) {
        val.markUnsaved();
        try {
            this.startTransaction();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)val);
        }
        finally {
            this.endTransaction();
        }
    }

    public void addCalendar(BwCalendar o) {
        o.markUnsaved();
        try {
            this.startTransaction();
            this.getCal().addRestoredEntity((BwUnversionedDbentity)o);
            ++this.curBatchSize;
        }
        finally {
            this.endTransaction();
        }
    }

    public RestoreIntf.FixAliasResult fixSharee(BwCalendar col, String shareeHref, AccessType a) {
        String shareeCua;
        InviteType invite;
        UserType uentry;
        TreeSet<String> paths = new TreeSet<String>();
        BwCalendar curCol = col;
        while (curCol.getInternalAlias()) {
            if (paths.contains(curCol.getPath())) {
                return RestoreIntf.FixAliasResult.circular;
            }
            paths.add(curCol.getPath());
            try {
                curCol = this.getCols().resolveAliasIdx(curCol, false, false);
            }
            catch (BedeworkAccessException ignored) {
                break;
            }
            if (curCol != null) continue;
            return RestoreIntf.FixAliasResult.broken;
        }
        if ((uentry = (invite = this.getSvc().getSharingHandler().getInviteStatus(col)).finduser(shareeCua = this.getSvc().getDirectories().userToCaladdr(shareeHref))) != null) {
            return RestoreIntf.FixAliasResult.ok;
        }
        uentry = new UserType();
        uentry.setHref(shareeCua);
        uentry.setInviteStatus(AppleServerTags.inviteAccepted);
        uentry.setAccess(a);
        invite.getUsers().add(uentry);
        try {
            col.setQproperty(AppleServerTags.invite, invite.toXml());
            this.getCols().update(col);
        }
        catch (BedeworkException be) {
            throw be;
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
        return RestoreIntf.FixAliasResult.reshared;
    }

    private void startTransaction() {
        if (this.transactionStarted) {
            return;
        }
        this.getSvc().open();
        this.getSvc().beginTransaction();
        this.transactionStarted = true;
    }

    private void handleException(Throwable t, String msg) {
        if (this.log == null) {
            return;
        }
        this.log.error(msg, t);
    }

    public void info(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.info(msg);
    }

    public void warn(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.warn(msg);
    }

    public void error(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.error(msg);
    }
}

