/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.bedework.base.exc.BedeworkException;
import org.bedework.caldav.util.notifications.NotificationType;
import org.bedework.caldav.util.notifications.parse.Parser;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.notifications.NotificationClient;
import org.bedework.calsvci.NotificationsI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.util.misc.Util;

class Notifications
extends CalSvcDb
implements NotificationsI {
    private static NotificationClient notifyClient;

    Notifications(CalSvc svci) {
        super(svci);
    }

    public boolean send(BwPrincipal pr, NotificationType val) {
        try {
            this.getSvc().pushPrincipal(pr);
            boolean bl = this.add(val);
            return bl;
        }
        catch (BedeworkException be) {
            throw be;
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
        finally {
            this.getSvc().popPrincipal();
        }
    }

    public boolean add(NotificationType val) {
        if (val == null || val.getNotification() == null || val.getNotification().getElementName() == null) {
            return false;
        }
        BwCalendar ncol = this.getCols().getSpecial(10, true);
        if (ncol == null) {
            return false;
        }
        BwResource noteRsrc = new BwResource();
        noteRsrc.setName(val.getName());
        noteRsrc.setColPath(ncol.getPath());
        noteRsrc.setEncoding(val.getNotification().getEncoding());
        BwResourceContent rc = new BwResourceContent();
        noteRsrc.setContent(rc);
        try {
            String xml = val.toXml(true);
            if (xml == null) {
                return false;
            }
            byte[] xmlData = xml.getBytes();
            rc.setByteValue(xmlData);
            noteRsrc.setContentLength((long)xmlData.length);
            noteRsrc.setContentType(val.getContentType());
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
        for (int i = 0; i <= 100; ++i) {
            if (this.getRess().saveNotification(noteRsrc)) {
                this.getNoteClient().informNotifier(this.getPrincipalHref(), noteRsrc.getName());
                return true;
            }
            noteRsrc.setName(val.getName() + "-" + i);
        }
        throw new BedeworkException("org.bedework.exception.duplicate.resource", val.getName());
    }

    public boolean update(NotificationType val) {
        if (val == null || val.getNotification() == null || val.getNotification().getElementName() == null) {
            return false;
        }
        try {
            String xml = val.toXml(true);
            if (xml == null) {
                return false;
            }
            BwCalendar ncol = this.getCols().getSpecial(10, true);
            if (ncol == null) {
                return false;
            }
            BwResource noteRsrc = this.getSvc().getResourcesHandler().get(Util.buildPath((boolean)false, (String[])new String[]{ncol.getPath(), "/", val.getName()}));
            if (noteRsrc == null) {
                return false;
            }
            BwResourceContent rc = noteRsrc.getContent();
            if (rc == null) {
                rc = new BwResourceContent();
                noteRsrc.setContent(rc);
            }
            byte[] xmlData = xml.getBytes();
            rc.setByteValue(xmlData);
            noteRsrc.setContentLength((long)xmlData.length);
            noteRsrc.setContentType(val.getContentType());
            this.getSvc().getResourcesHandler().update(noteRsrc, true);
            this.getNoteClient().informNotifier(this.getPrincipalHref(), noteRsrc.getName());
            return true;
        }
        catch (BedeworkException be) {
            throw be;
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }

    public NotificationType find(String name) {
        BwCalendar ncol = this.getCols().getSpecial(10, true);
        if (ncol == null) {
            return null;
        }
        BwResource noteRsrc = this.getSvc().getResourcesHandler().get(Util.buildPath((boolean)false, (String[])new String[]{ncol.getPath(), "/", name}));
        if (noteRsrc == null) {
            return null;
        }
        return this.makeNotification(noteRsrc);
    }

    public NotificationType find(String principalHref, String name) {
        BwCalendar ncol = this.getCols().getSpecial(principalHref, 10, true);
        if (ncol == null) {
            return null;
        }
        BwResource noteRsrc = this.getSvc().getResourcesHandler().get(Util.buildPath((boolean)false, (String[])new String[]{ncol.getPath(), "/", name}));
        if (noteRsrc == null) {
            return null;
        }
        return this.makeNotification(noteRsrc);
    }

    public void remove(NotificationType val) {
        if (val == null || val.getNotification() == null || val.getNotification().getElementName() == null) {
            return;
        }
        BwCalendar ncol = this.getCols().getSpecial(10, true);
        if (ncol == null) {
            return;
        }
        String path = Util.buildPath((boolean)false, (String[])new String[]{ncol.getPath(), "/", val.getName()});
        this.getSvc().getResourcesHandler().delete(path);
    }

    public void remove(String principalHref, String name) {
        if (name == null) {
            return;
        }
        BwCalendar ncol = this.getCols().getSpecial(principalHref, 10, true);
        if (ncol == null) {
            return;
        }
        String path = Util.buildPath((boolean)false, (String[])new String[]{ncol.getPath(), "/", name});
        this.getSvc().getResourcesHandler().delete(path);
    }

    public void remove(String principalHref, NotificationType val) {
        if (val == null || val.getNotification() == null || val.getNotification().getElementName() == null) {
            return;
        }
        BwCalendar ncol = this.getCols().getSpecial(principalHref, 10, true);
        if (ncol == null) {
            return;
        }
        String path = Util.buildPath((boolean)false, (String[])new String[]{ncol.getPath(), "/", val.getName()});
        this.getSvc().getResourcesHandler().delete(path);
    }

    public void removeAll(String principalHref) {
        if (principalHref == null) {
            return;
        }
        BwCalendar ncol = this.getCols().getSpecial(principalHref, 10, true);
        if (ncol == null) {
            return;
        }
        ResourcesI resI = this.getSvc().getResourcesHandler();
        List rs = resI.getAll(ncol.getPath());
        if (!Util.isEmpty((Collection)rs)) {
            for (BwResource r : rs) {
                resI.delete(Util.buildPath((boolean)false, (String[])new String[]{r.getColPath(), "/", r.getName()}));
            }
        }
    }

    public List<NotificationType> getAll() {
        return this.getMatching(null);
    }

    public List<NotificationType> getMatching(QName type) {
        ArrayList<NotificationType> res = new ArrayList<NotificationType>();
        BwCalendar ncol = this.getCols().getSpecial(10, true);
        if (ncol == null) {
            return res;
        }
        List rsrc = this.getSvc().getResourcesHandler().getAll(ncol.getPath());
        if (Util.isEmpty((Collection)rsrc)) {
            return res;
        }
        if (rsrc.size() > 100) {
            this.warn("Large resource collection for " + ncol.getPath());
        }
        for (BwResource r : rsrc) {
            NotificationType nt;
            NotificationType.NotificationInfo ni;
            if (type != null && ((ni = NotificationType.fromContentType((String)r.getContentType())) == null || !type.equals(ni.type)) || (nt = this.makeNotification(r)) == null) continue;
            res.add(nt);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationType> getMatching(BwPrincipal pr, QName type) {
        try {
            this.getSvc().pushPrincipal(pr);
            List<NotificationType> list = this.getMatching(type);
            return list;
        }
        finally {
            this.getSvc().popPrincipal();
        }
    }

    public List<NotificationType> getMatching(String href, QName type) {
        BwPrincipal pr = this.getSvc().getDirectories().caladdrToPrincipal(href);
        if (pr == null) {
            return null;
        }
        return this.getMatching(pr, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String principalHref, List<String> emails) {
        try {
            this.getSvc().pushPrincipalOrFail(principalHref);
            BwPreferences prefs = this.getPrefs();
            prefs.setNotificationToken(UUID.randomUUID().toString());
            this.getSvc().getPrefsHandler().update(prefs);
            this.getNoteClient().subscribe(principalHref, emails, prefs.getNotificationToken());
        }
        finally {
            this.getSvc().popPrincipal();
        }
    }

    public void subscribe(BwPrincipal principal, List<String> emails) {
        BwPreferences prefs = this.getPrefs(principal);
        prefs.setNotificationToken(UUID.randomUUID().toString());
        this.getSvc().getPrefsHandler().update(prefs);
        this.getNoteClient().subscribe(principal.getPrincipalRef(), emails, prefs.getNotificationToken());
    }

    public void unsubscribe(String principalHref, List<String> emails) {
        try {
            this.getSvc().pushPrincipalOrFail(principalHref);
            this.getNoteClient().unsubscribe(principalHref, emails);
        }
        finally {
            this.getSvc().popPrincipal();
        }
    }

    void remove(BwPrincipal pr, NotificationType val) {
        try {
            this.getSvc().pushPrincipal(pr);
            this.remove(val);
        }
        finally {
            this.getSvc().popPrincipal();
        }
    }

    private NotificationType makeNotification(BwResource rsrc) {
        this.getSvc().getResourcesHandler().getContent(rsrc);
        BwResourceContent bwrc = rsrc.getContent();
        if (bwrc == null) {
            return null;
        }
        InputStream is = bwrc.getBinaryStream();
        if (is == null) {
            return null;
        }
        try {
            NotificationType note = Parser.fromXml((InputStream)is);
            if (note != null) {
                note.setName(rsrc.getName());
                note.getNotification().setEncoding(rsrc.getEncoding());
            }
            return note;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            this.error("Unable to parse notification " + rsrc.getColPath() + " " + rsrc.getName());
            return null;
        }
    }

    private synchronized NotificationClient getNoteClient() {
        if (notifyClient != null) {
            return notifyClient;
        }
        notifyClient = new NotificationClient(this.getSvc().getNotificationProperties());
        return notifyClient;
    }
}

