/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.bedework.access.AccessException;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.PrivilegeSet;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwUser;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.PrincipalInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.DumpIntf;
import org.bedework.util.misc.Util;

public class DumpImpl
extends CalSvcDb
implements DumpIntf {
    DumpImpl(CalSvc svci) {
        super(svci);
    }

    public Iterator<BwAdminGroup> getAdminGroups() {
        Collection c = this.getCal().getAdminGroups();
        for (BwGroup grp : c) {
            this.getAdminMembers(grp);
        }
        return c.iterator();
    }

    public Iterator<BwAuthUser> getAuthUsers() {
        return this.getObjects(BwAuthUser.class);
    }

    public Iterator<BwCalendar> getCalendars() {
        ArrayList<BwCalendar> cols = new ArrayList<BwCalendar>();
        cols.add(this.getCal().getCalendar(BasicSystemProperties.publicCalendarRootPath, 25, false));
        cols.add(this.getCal().getCalendar(BasicSystemProperties.userCalendarRootPath, 25, false));
        return cols.iterator();
    }

    public Collection<BwCalendar> getChildren(BwCalendar val) {
        return this.getCal().getCalendars(val, null);
    }

    public Iterator<BwCalSuite> getCalSuites() {
        return this.getObjects(BwCalSuite.class);
    }

    public Iterator<BwCategory> getCategories() {
        return this.getObjects(BwCategory.class);
    }

    public Iterator<BwEvent> getEvents() {
        return new EventIterator(this.getCal().getObjectIterator(BwEventObj.class));
    }

    public Iterable<EventInfo> getEventInfos(String colPath) {
        return new IterableImpl<EventInfo>(new EventInfoIterator(this.getCal().getObjectIterator(BwEventObj.class, colPath)));
    }

    public Iterable<BwResource> getResources(String colPath) {
        return new IterableImpl<BwResource>(new ResourceIterator(this.getCal().getObjectIterator(BwResource.class, colPath)));
    }

    public Iterator<String> getEventHrefs(int start) {
        return this.getCal().getEventHrefs(start);
    }

    public Iterator<BwEventAnnotation> getEventAnnotations() {
        return this.getCal().getEventAnnotations();
    }

    public Iterator<BwFilterDef> getFilters() {
        return this.getObjects(BwFilterDef.class);
    }

    public Iterator<BwLocation> getLocations() {
        return this.getObjects(BwLocation.class);
    }

    public Iterator<BwPreferences> getPreferences() {
        return this.getObjects(BwPreferences.class);
    }

    public Iterator<BwContact> getContacts() {
        return this.getObjects(BwContact.class);
    }

    public Iterator<BwPrincipal<?>> getAllPrincipals() {
        return this.getObjects(BwUser.class);
    }

    public Iterator<BwResource> getResources() {
        return this.getObjects(BwResource.class);
    }

    public void getResourceContent(BwResource res) {
        try {
            this.getCal().getResourceContent(res);
        }
        catch (BedeworkException be) {
            if (be.getMessage().equals("org.bedework.exception.missing.resource.content")) {
                return;
            }
            throw be;
        }
    }

    public Iterator<BwView> getViews() {
        return this.getObjects(BwView.class);
    }

    public void startPrincipal(BwPrincipal val) {
        this.getSvc().pushPrincipal(val);
    }

    public void endPrincipal(BwPrincipal val) {
        this.getSvc().popPrincipal();
    }

    private <T> Iterator<T> getObjects(Class<?> cl) {
        return this.getCal().getObjectIterator(cl);
    }

    private void getAdminMembers(BwGroup group) {
        group.setGroupMembers(this.getCal().getMembers(group, true));
    }

    private void getMembers(BwGroup group) {
        group.setGroupMembers(this.getCal().getMembers(group, false));
    }

    private Collection<BwEventAnnotation> getOverrides(BwEvent ev) {
        return this.getCal().getEventOverrides(ev);
    }

    private class EventIterator
    implements Iterator<BwEvent> {
        private final Iterator<BwEventObj> it;

        private EventIterator(Iterator<BwEventObj> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public BwEvent next() {
            try {
                BwEvent ev = (BwEvent)this.it.next();
                if (ev.testRecurring()) {
                    ev.setOverrides(DumpImpl.this.getOverrides(ev));
                }
                return ev;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Forbidden");
        }
    }

    static class IterableImpl<T>
    implements Iterable<T> {
        private final Iterator<T> it;

        IterableImpl(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public Iterator<T> iterator() {
            return this.it;
        }
    }

    private class EventInfoIterator
    implements Iterator<EventInfo> {
        private final Iterator<BwEventObj> it;

        private EventInfoIterator(Iterator<BwEventObj> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public EventInfo next() {
            try {
                EventInfo evi;
                BwEvent ev = (BwEvent)this.it.next();
                if (ev.testRecurring()) {
                    TreeSet<EventInfo> overrides = new TreeSet<EventInfo>();
                    Collection<BwEventAnnotation> ovevs = DumpImpl.this.getOverrides(ev);
                    if (!Util.isEmpty(ovevs)) {
                        for (BwEventAnnotation ovev : ovevs) {
                            overrides.add(new EventInfo((BwEvent)new BwEventProxy(ovev)));
                        }
                    }
                    evi = new EventInfo(ev, overrides);
                } else {
                    evi = new EventInfo(ev);
                }
                return evi;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Forbidden");
        }
    }

    private class ResourceIterator
    implements Iterator<BwResource> {
        private final Iterator<BwResource> it;

        private ResourceIterator(Iterator<BwResource> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public BwResource next() {
            try {
                BwResource res = this.it.next();
                DumpImpl.this.getResourceContent(res);
                return res;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Forbidden");
        }
    }

    private static final class DumpPrincipalInfo
    extends PrincipalInfo {
        private final DumpImpl dump;
        private final Map<String, BwPrincipal> principals = new HashMap<String, BwPrincipal>();
        private final Deque<StackedState> stack = new ArrayDeque<StackedState>();

        DumpPrincipalInfo(DumpImpl dump, BwPrincipal principal, BwPrincipal authPrincipal, PrivilegeSet maxAllowedPrivs) {
            super(principal, authPrincipal, maxAllowedPrivs, false);
            this.dump = dump;
        }

        public AccessPrincipal getPrincipal(String href) {
            BwPrincipal p = this.principals.get(href);
            if (p == null) {
                p = this.dump.getCal().getPrincipal(href);
            }
            if (p != null) {
                this.principals.put(href, p);
            }
            return p;
        }

        void setPrincipal(BwPrincipal principal) {
            this.principal = principal;
            this.calendarHomePath = null;
        }

        public String makeHref(String id, int whoType) throws AccessException {
            return BwPrincipal.makePrincipalHref((String)id, (int)whoType);
        }

        private static class StackedState {
            BwPrincipal principal;

            private StackedState() {
            }
        }
    }
}

