/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.james.jdkim.api.JDKIM;
import org.bedework.access.Access;
import org.bedework.access.Ace;
import org.bedework.access.AceWho;
import org.bedework.access.CurrentAccess;
import org.bedework.access.PrivilegeSet;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.exc.persist.BedeworkConstraintViolationException;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calcorei.Calintf;
import org.bedework.calcorei.CalintfFactory;
import org.bedework.caldav.util.notifications.admin.AdminNoteParsers;
import org.bedework.caldav.util.notifications.eventreg.EventregParsers;
import org.bedework.caldav.util.notifications.suggest.SuggestParsers;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwStats;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.base.OwnedEntity;
import org.bedework.calfacade.base.ShareableEntity;
import org.bedework.calfacade.base.UpdateFromTimeZonesInfo;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.configs.Configurations;
import org.bedework.calfacade.configs.NotificationProperties;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.ifs.IfInfo;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.mail.MailerIntf;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calfacade.svc.CalSvcIPars;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.PrincipalInfo;
import org.bedework.calfacade.svc.UserAuth;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calfacade.wrappers.CalendarWrapper;
import org.bedework.calsvc.Admin;
import org.bedework.calsvc.CalSuites;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Calendars;
import org.bedework.calsvc.CategoriesImpl;
import org.bedework.calsvc.ContactsImpl;
import org.bedework.calsvc.DumpImpl;
import org.bedework.calsvc.Events;
import org.bedework.calsvc.Filters;
import org.bedework.calsvc.GroupsCallBack;
import org.bedework.calsvc.LocationsImpl;
import org.bedework.calsvc.Notifications;
import org.bedework.calsvc.Preferences;
import org.bedework.calsvc.ResourcesImpl;
import org.bedework.calsvc.RestoreImpl;
import org.bedework.calsvc.Sharing;
import org.bedework.calsvc.SvciPrincipalInfo;
import org.bedework.calsvc.Synch;
import org.bedework.calsvc.Syspars;
import org.bedework.calsvc.TimeZonesStoreImpl;
import org.bedework.calsvc.UserAuthCallBack;
import org.bedework.calsvc.Users;
import org.bedework.calsvc.Views;
import org.bedework.calsvc.scheduling.Scheduling;
import org.bedework.calsvc.scheduling.SchedulingIntf;
import org.bedework.calsvc.scheduling.hosts.BwHosts;
import org.bedework.calsvci.AdminI;
import org.bedework.calsvci.CalSuitesI;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.Categories;
import org.bedework.calsvci.Contacts;
import org.bedework.calsvci.DumpIntf;
import org.bedework.calsvci.EventsI;
import org.bedework.calsvci.FiltersI;
import org.bedework.calsvci.Locations;
import org.bedework.calsvci.NotificationsI;
import org.bedework.calsvci.PreferencesI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.calsvci.RestoreIntf;
import org.bedework.calsvci.SchedulingI;
import org.bedework.calsvci.SharingI;
import org.bedework.calsvci.SynchI;
import org.bedework.calsvci.SynchReport;
import org.bedework.calsvci.SynchReportItem;
import org.bedework.calsvci.SysparsI;
import org.bedework.calsvci.TimeZonesStoreI;
import org.bedework.calsvci.UsersI;
import org.bedework.calsvci.ViewsI;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.caching.FlushMap;
import org.bedework.util.jmx.MBeanUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.security.PwEncryptionIntf;
import org.bedework.util.security.keys.GenKeysMBean;
import org.bedework.util.timezones.Timezones;

public class CalSvc
implements CalSvcI,
Logged,
Calintf.FilterParserFetcher {
    private CalSvcIPars pars;
    private static Configurations configs;
    private boolean open;
    private boolean creating;
    private boolean authenticated;
    private PrincipalInfo principalInfo;
    private PreferencesI prefsHandler;
    private AdminI adminHandler;
    private EventsI eventsHandler;
    private FiltersI filtersHandler;
    private CalendarsI calendarsHandler;
    private SysparsI sysparsHandler;
    private CalSuitesI calSuitesHandler;
    private NotificationsI notificationsHandler;
    private ResourcesI resourcesHandler;
    private SchedulingIntf sched;
    private SharingI sharingHandler;
    private SynchI synch;
    private UsersI usersHandler;
    private ViewsI viewsHandler;
    private Categories categoriesHandler;
    private Locations locationsHandler;
    private Contacts contactsHandler;
    private final Collection<CalSvcDb> handlers = new ArrayList<CalSvcDb>();
    private transient Calintf cali;
    private transient PwEncryptionIntf pwEncrypt;
    private Timezones timezones;
    private TimeZonesStoreI tzstore;
    private static String tzserverUri;
    private UserAuth userAuth;
    private transient UserAuth.CallBack uacb;
    private transient Directories.CallBack gcb;
    private Directories userGroups;
    private Directories adminGroups;
    private IcalCallback icalcb;
    private static final Map<String, BwPrincipal<?>> authUsers;
    private static final Map<String, BwPrincipal<?>> unauthUsers;
    private final BwLogger logger = new BwLogger();
    private static final BwLogger authLogger;

    public void init(CalSvcIPars parsParam) {
        this.init(parsParam, parsParam.getForRestore());
    }

    private void init(CalSvcIPars parsParam, boolean creating) {
        this.pars = (CalSvcIPars)parsParam.clone();
        this.creating = creating;
        long start = System.currentTimeMillis();
        this.fixUsers();
        try {
            if (configs == null) {
                configs = CalSvcFactoryDefault.getSystemConfig();
            }
            this.open();
            if (this.trace()) {
                this.trace(String.format("svc after open %s", System.currentTimeMillis() - start));
            }
            if (this.userGroups != null) {
                this.userGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
            }
            if (this.adminGroups != null) {
                this.adminGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
            }
            SystemProperties sp = this.getSystemProperties();
            if (tzserverUri == null) {
                tzserverUri = sp.getTzServeruri();
                if (tzserverUri == null) {
                    throw new BedeworkException("No timezones server URI defined");
                }
                Timezones.initTimezones((String)tzserverUri);
                Timezones.setSystemDefaultTzid((String)sp.getTzid());
            }
            this.tzstore = new TimeZonesStoreImpl(this);
            System.setProperty("net.fortuna.ical4j.timezone.registry", "org.bedework.util.timezones.TimeZoneRegistryFactoryImpl");
            System.setProperty("net.fortuna.ical4j.timezone.cache.impl", "net.fortuna.ical4j.util.MapTimeZoneCache");
            if (!creating) {
                String tzid = this.getPrefsHandler().get().getDefaultTzid();
                if (tzid != null) {
                    Timezones.setThreadDefaultTzid((String)tzid);
                }
                if (!this.pars.isGuest()) {
                    // empty if block
                }
            }
            if (this.trace()) {
                this.trace(String.format("svc after tzs %s", System.currentTimeMillis() - start));
            }
            if ((this.pars.getPublicAdmin() || this.pars.getAllowSuperUser()) && this.pars.getAuthUser() != null) {
                ((SvciPrincipalInfo)this.principalInfo).setSuperUser(this.getSysparsHandler().isRootUser(this.principalInfo.getAuthPrincipal()));
            }
            this.postNotification((SysEventBase)SysEvent.makePrincipalEvent((SysEventBase.SysCode)SysEventBase.SysCode.USER_SVCINIT, (String)this.getPrincipal().getPrincipalRef(), (long)(System.currentTimeMillis() - start)));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException && t.getMessage().equals("Upgrade to read/write")) {
                throw (RuntimeException)t;
            }
            t.printStackTrace();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            try {
                this.close();
            }
            catch (Throwable sp) {}
        }
        if (this.trace()) {
            this.trace(String.format("svc about to exit %s", System.currentTimeMillis() - start));
        }
    }

    public AuthProperties getAuthProperties() {
        if (!this.authenticated) {
            return configs.getUnauthenticatedAuthProperties();
        }
        return configs.getAuthenticatedAuthProperties();
    }

    public SystemProperties getSystemProperties() {
        return configs.getSystemProperties();
    }

    public JDKIM getJDKIM() {
        return BwHosts.getJDKIM();
    }

    public NotificationProperties getNotificationProperties() {
        return configs.getNotificationProps();
    }

    public void setCalSuite(String name) {
        BwCalSuiteWrapper cs = this.getCalSuitesHandler().get(name);
        if (cs == null) {
            this.error("******************************************************");
            this.error("Unable to fetch calendar suite " + name);
            this.error("Is the database correctly initialised?");
            this.error("******************************************************");
            throw new BedeworkException("org.bedework.svci.unknown.calsuite", name);
        }
        this.getCalSuitesHandler().set(cs);
    }

    public PrincipalInfo getPrincipalInfo() {
        return this.principalInfo;
    }

    public boolean getSuperUser() {
        return this.principalInfo.getSuperUser();
    }

    public byte[] getPublicKey(String domain, String service) {
        try {
            return this.getEncrypter().getPublicKey();
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }

    public BwStats getStats() {
        BwStats stats = this.getCal().getStats();
        if (this.timezones != null) {
            BwStats.CacheStats cs = stats.getDateCacheStats();
            cs.setHits(this.timezones.getDateCacheHits());
            cs.setMisses(this.timezones.getDateCacheMisses());
            cs.setCached(this.timezones.getDatesCached());
        }
        stats.setAccessStats(Access.getStatistics());
        return stats;
    }

    public void setDbStatsEnabled(boolean enable) {
        this.getCal().setDbStatsEnabled(enable);
    }

    public boolean getDbStatsEnabled() {
        return this.getCal().getDbStatsEnabled();
    }

    public void dumpDbStats() {
        this.trace(this.getStats().toString());
        this.getCal().dumpDbStats();
    }

    public Collection<BwStats.StatsEntry> getDbStats() {
        return this.getCal().getDbStats();
    }

    public void logStats() {
        this.info(this.getStats().toString());
    }

    public List<IfInfo> getActiveIfInfos() {
        ArrayList<IfInfo> ifs = new ArrayList<IfInfo>();
        for (Calintf ci : this.getCal().active()) {
            ifs.add(ci.getIfInfo());
        }
        return ifs;
    }

    public void kill(IfInfo ifInfo) {
        try {
            for (Calintf ci : this.getCal().active()) {
                IfInfo calIfInfo = ci.getIfInfo();
                if (!calIfInfo.getId().equals(ifInfo.getId())) continue;
                this.warn("Stopping interface with id " + ifInfo.getId());
                ci.kill();
                break;
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    public void setState(String val) {
        this.getCal().setState(val);
    }

    public void postNotification(SysEventBase ev) {
        this.getCal().postNotification(ev);
    }

    public void flushAll() {
        this.getCal().flush();
    }

    public void open() {
        if (this.open) {
            return;
        }
        this.open = true;
        long start = System.currentTimeMillis();
        this.getCal().open((Calintf.FilterParserFetcher)this, this.pars.getLogId(), configs, this.pars.getForRestore(), this.pars.getIndexRebuild(), this.pars.getPublicAdmin(), this.pars.getPublicAuth(), this.pars.getPublicSubmission(), this.authenticated, this.pars.getSessionsless(), this.pars.getDontKill());
        if (this.trace()) {
            this.trace(String.format("svc.open after getCal() %s", System.currentTimeMillis() - start));
        }
        for (CalSvcDb handler : this.handlers) {
            if (this.trace()) {
                this.trace(String.format("svc.open about to open %s after %s", handler.getClass(), System.currentTimeMillis() - start));
            }
            handler.open();
        }
        if (this.trace()) {
            this.trace(String.format("svc.open after open handlers %s", System.currentTimeMillis() - start));
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isRolledback() {
        return this.open && this.getCal().isRolledback();
    }

    public void close() {
        this.open = false;
        this.getCal().close();
        for (CalSvcDb handler : this.handlers) {
            handler.close();
        }
    }

    public void beginTransaction() {
        this.getCal().beginTransaction();
    }

    public void endTransaction() {
        this.getCal().endTransaction();
    }

    public void rollbackTransaction() {
        this.getCal().rollbackTransaction();
    }

    public Timestamp getCurrentTimestamp() {
        return this.getCal().getCurrentTimestamp();
    }

    public BwUnversionedDbentity<?> merge(BwUnversionedDbentity<?> val) {
        if (val instanceof CalendarWrapper) {
            CalendarWrapper w = (CalendarWrapper)val;
            w.putEntity((BwCalendar)this.getCal().merge((BwUnversionedDbentity)w.fetchEntity()));
            return w;
        }
        return this.getCal().merge(val);
    }

    public IcalCallback getIcalCallback() {
        if (this.icalcb == null) {
            this.icalcb = new IcalCallbackcb(null);
        }
        return this.icalcb;
    }

    public IcalCallback getIcalCallback(Boolean timezonesByReference) {
        if (this.icalcb == null) {
            this.icalcb = new IcalCallbackcb(timezonesByReference);
        }
        return this.icalcb;
    }

    public DumpIntf getDumpHandler() {
        return new DumpImpl(this);
    }

    public RestoreIntf getRestoreHandler() {
        return new RestoreImpl(this);
    }

    public SimpleFilterParser getFilterParser() {
        return new SvcSimpleFilterParser();
    }

    public SysparsI getSysparsHandler() {
        if (this.sysparsHandler == null) {
            this.sysparsHandler = new Syspars(this);
            this.handlers.add((CalSvcDb)this.sysparsHandler);
        }
        return this.sysparsHandler;
    }

    public MailerIntf getMailer() {
        MailerIntf mailer = (MailerIntf)Util.getObject((ClassLoader)this.getClass().getClassLoader(), (String)this.getSystemProperties().getMailerClass(), MailerIntf.class);
        mailer.init(configs.getMailConfigProperties());
        return mailer;
    }

    public PreferencesI getPrefsHandler() {
        if (this.prefsHandler == null) {
            this.prefsHandler = new Preferences(this);
            this.handlers.add((CalSvcDb)this.prefsHandler);
        }
        return this.prefsHandler;
    }

    public AdminI getAdminHandler() {
        if (!this.isPublicAdmin()) {
            throw new RuntimeException("Attempt to get admin handler when not public admin");
        }
        if (this.adminHandler == null) {
            this.adminHandler = new Admin(this);
            this.handlers.add((CalSvcDb)this.adminHandler);
        }
        return this.adminHandler;
    }

    public EventsI getEventsHandler() {
        if (this.eventsHandler == null) {
            this.eventsHandler = new Events(this);
            this.handlers.add((CalSvcDb)this.eventsHandler);
        }
        return this.eventsHandler;
    }

    public FiltersI getFiltersHandler() {
        if (this.filtersHandler == null) {
            this.filtersHandler = new Filters(this);
            this.handlers.add((CalSvcDb)this.filtersHandler);
        }
        return this.filtersHandler;
    }

    public CalendarsI getCalendarsHandler() {
        if (this.calendarsHandler == null) {
            this.calendarsHandler = new Calendars(this);
            this.handlers.add((CalSvcDb)this.calendarsHandler);
        }
        return this.calendarsHandler;
    }

    public CalSuitesI getCalSuitesHandler() {
        if (this.calSuitesHandler == null) {
            this.calSuitesHandler = new CalSuites(this);
            this.handlers.add((CalSvcDb)this.calSuitesHandler);
        }
        return this.calSuitesHandler;
    }

    public BwIndexer getIndexer(String docType) {
        return this.getCal().getIndexer(docType);
    }

    public BwIndexer getIndexer(boolean publick, String docType) {
        return this.getCal().getIndexer(publick, docType);
    }

    public BwIndexer getIndexer(BwOwnedDbentity<?> entity) {
        return this.getCal().getIndexer(entity);
    }

    public BwIndexer getIndexer(String principal, String docType) {
        String prHref = principal == null ? this.getPrincipal().getPrincipalRef() : principal;
        return this.getCal().getIndexer(prHref, docType);
    }

    public BwIndexer getIndexerForReindex(String principal, String docType, String indexName) {
        String prHref = principal == null ? this.getPrincipal().getPrincipalRef() : principal;
        return this.getCal().getIndexerForReindex(prHref, docType, indexName);
    }

    public NotificationsI getNotificationsHandler() {
        if (this.notificationsHandler == null) {
            this.notificationsHandler = new Notifications(this);
            this.handlers.add((CalSvcDb)this.notificationsHandler);
        }
        return this.notificationsHandler;
    }

    public ResourcesI getResourcesHandler() {
        if (this.resourcesHandler == null) {
            this.resourcesHandler = new ResourcesImpl(this);
            this.handlers.add((CalSvcDb)this.resourcesHandler);
        }
        return this.resourcesHandler;
    }

    public SchedulingI getScheduler() {
        if (this.sched == null) {
            this.sched = new Scheduling(this);
            this.handlers.add((CalSvcDb)((Object)this.sched));
        }
        return this.sched;
    }

    public SharingI getSharingHandler() {
        if (this.sharingHandler == null) {
            this.sharingHandler = new Sharing(this);
            this.handlers.add((CalSvcDb)this.sharingHandler);
        }
        return this.sharingHandler;
    }

    public SynchI getSynch() {
        if (this.synch == null) {
            this.synch = new Synch(this, configs.getSynchConfig());
            this.handlers.add((CalSvcDb)this.synch);
        }
        return this.synch;
    }

    public UsersI getUsersHandler() {
        if (this.usersHandler == null) {
            this.usersHandler = new Users(this);
            this.handlers.add((CalSvcDb)this.usersHandler);
        }
        return this.usersHandler;
    }

    public ViewsI getViewsHandler() {
        if (this.viewsHandler == null) {
            this.viewsHandler = new Views(this);
            this.handlers.add((CalSvcDb)this.viewsHandler);
        }
        return this.viewsHandler;
    }

    public Directories getDirectories() {
        if (this.isPublicAdmin() || this.isPublicAuth()) {
            return this.getAdminDirectories();
        }
        return this.getUserDirectories();
    }

    public Directories getUserDirectories() {
        if (this.userGroups != null) {
            return this.userGroups;
        }
        try {
            this.userGroups = (Directories)Util.getObject((ClassLoader)this.getClass().getClassLoader(), (String)this.getSystemProperties().getUsergroupsClass(), Directories.class);
            this.userGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return this.userGroups;
    }

    public Directories getAdminDirectories() {
        if (this.adminGroups != null) {
            return this.adminGroups;
        }
        try {
            this.adminGroups = (Directories)Util.getObject((ClassLoader)this.getClass().getClassLoader(), (String)this.getSystemProperties().getAdmingroupsClass(), Directories.class);
            this.adminGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return this.adminGroups;
    }

    public Categories getCategoriesHandler() {
        if (this.categoriesHandler == null) {
            this.categoriesHandler = new CategoriesImpl(this);
            this.categoriesHandler.init(this.pars.getAdminCanEditAllPublicCategories());
            this.handlers.add((CalSvcDb)this.categoriesHandler);
        }
        return this.categoriesHandler;
    }

    public Locations getLocationsHandler() {
        if (this.locationsHandler == null) {
            this.locationsHandler = new LocationsImpl(this);
            this.locationsHandler.init(this.pars.getAdminCanEditAllPublicLocations());
            this.handlers.add((CalSvcDb)this.locationsHandler);
        }
        return this.locationsHandler;
    }

    public Contacts getContactsHandler() {
        if (this.contactsHandler == null) {
            this.contactsHandler = new ContactsImpl(this);
            this.contactsHandler.init(this.pars.getAdminCanEditAllPublicContacts());
            this.handlers.add((CalSvcDb)this.contactsHandler);
        }
        return this.contactsHandler;
    }

    public <T> Iterator<T> getObjectIterator(Class<T> cl) {
        return this.getCal().getObjectIterator(cl);
    }

    public <T> Iterator<T> getPrincipalObjectIterator(Class<T> cl) {
        return this.getCal().getPrincipalObjectIterator(cl);
    }

    public <T> Iterator<T> getPublicObjectIterator(Class<T> cl) {
        return this.getCal().getPublicObjectIterator(cl);
    }

    public BwPrincipal<?> getPrincipal() {
        return this.principalInfo.getPrincipal();
    }

    public BwPrincipal<?> getPrincipal(String href) {
        return this.getCal().getPrincipal(href);
    }

    public UserAuth getUserAuth() {
        if (this.userAuth != null) {
            return this.userAuth;
        }
        this.userAuth = (UserAuth)Util.getObject((ClassLoader)this.getClass().getClassLoader(), (String)this.getSystemProperties().getUserauthClass(), UserAuth.class);
        this.userAuth.initialise((UserAuth.CallBack)this.getUserAuthCallBack());
        return this.userAuth;
    }

    public long getUserMaxEntitySize() {
        long max = this.getPrefsHandler().get().getMaxEntitySize();
        if (max != 0L) {
            return max;
        }
        return this.getAuthProperties().getMaxUserEntitySize().intValue();
    }

    public BwPreferences getPreferences(String principalHref) {
        return this.getCal().getPreferences(principalHref);
    }

    public void removeFromAllPrefs(BwShareableDbentity<?> val) {
        this.getCal().removeFromAllPrefs(val);
    }

    public BwGroup<?> findGroup(String account, boolean admin) {
        return this.getCal().findGroup(account, admin);
    }

    public void changeAccess(ShareableEntity ent, Collection<Ace> aces, boolean replaceAll) {
        if (ent instanceof BwCalSuiteWrapper) {
            ent = ((BwCalSuiteWrapper)ent).fetchEntity();
        }
        this.getCal().changeAccess(ent, aces, replaceAll);
        if (ent instanceof BwCalendar) {
            BwCalendar col = (BwCalendar)ent;
            if (col.getCalType() == 5) {
                BwCalendar pendingInbox = this.getCalendarsHandler().getSpecial(13, true);
                if (pendingInbox == null) {
                    this.warn("Unable to update pending inbox access");
                } else {
                    this.getCal().changeAccess(pendingInbox, aces, replaceAll);
                }
            }
            ((Preferences)this.getPrefsHandler()).updateAdminPrefs(false, col, null, null, null);
        } else if (ent instanceof BwEventProperty) {
            ((Preferences)this.getPrefsHandler()).updateAdminPrefs(false, (BwEventProperty)ent);
        }
    }

    public void defaultAccess(ShareableEntity ent, AceWho who) {
        if (ent instanceof BwCalSuiteWrapper) {
            ent = ((BwCalSuiteWrapper)ent).fetchEntity();
        }
        this.getCal().defaultAccess(ent, who);
    }

    public CurrentAccess checkAccess(ShareableEntity ent, int desiredAccess, boolean returnResult) {
        return this.getCal().checkAccess(ent, desiredAccess, returnResult);
    }

    public SynchReport getSynchReport(String path, String token, int limit, boolean recurse) {
        BwCalendar col = this.getCalendarsHandler().get(path);
        if (col == null) {
            return null;
        }
        TreeSet<Object> items = new TreeSet<SynchReportItem>();
        Object resToken = this.getSynchItems(col, path, token, items, recurse);
        boolean tokenValid = token == null || resToken != null;
        SynchReport res = new SynchReport(items, (String)resToken, tokenValid);
        if (!tokenValid) {
            return res;
        }
        if (limit > 0 && res.size() >= limit) {
            if (res.size() == limit) {
                return res;
            }
            items = new TreeSet();
            resToken = "";
            for (SynchReportItem item : res.getItems()) {
                if (item.getToken().compareTo((String)resToken) > 0) {
                    resToken = item.getToken();
                }
                items.add(item);
                if (items.size() != limit) continue;
                break;
            }
        }
        if (resToken == null || ((String)resToken).isEmpty()) {
            resToken = Util.icalUTCTimestamp() + "-0000";
        }
        return new SynchReport(items, (String)resToken, true);
    }

    private boolean canSync(BwCalendar col) {
        return col.getCalType() != 8;
    }

    public UpdateFromTimeZonesInfo updateFromTimeZones(String colHref, int limit, boolean checkOnly, UpdateFromTimeZonesInfo info) {
        return this.tzstore.updateFromTimeZones(colHref, limit, checkOnly, info);
    }

    Calintf getCal(BwCalendar cal) {
        return this.getCal();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Calintf getCal() {
        block68: {
            block67: {
                if (this.cali != null) {
                    return this.cali;
                }
                start = System.currentTimeMillis();
                try {
                    beforeGetIntf = System.currentTimeMillis() - start;
                    if (this.trace()) {
                        this.trace(String.format("getCal: beforeGetIntf=%s", new Object[]{beforeGetIntf}));
                    }
                    authenticatedUser = this.pars.getAuthUser();
                    this.authenticated = this.pars.getForRestore() != false || authenticatedUser != null;
                    this.cali = CalintfFactory.getIntf((ClassLoader)this.getClass().getClassLoader(), (boolean)(this.authenticated == false || this.pars.getReadonly() != false));
                    afterGetIntf = System.currentTimeMillis() - start;
                    if (this.trace()) {
                        this.trace(String.format("getCal: afterGetIntf=%s", new Object[]{afterGetIntf}));
                    }
                    this.cali.open((Calintf.FilterParserFetcher)this, this.pars.getLogId(), CalSvc.configs, this.pars.getForRestore(), this.pars.getIndexRebuild(), this.pars.getPublicAdmin(), this.pars.getPublicAuth(), this.pars.getPublicSubmission(), this.authenticated, this.pars.getSessionsless(), this.pars.getDontKill());
                    this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: about to obtain calintf", (long)beforeGetIntf));
                    this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: calintf obtained", (long)afterGetIntf));
                    this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: intf opened", (long)(System.currentTimeMillis() - start)));
                    if (this.trace()) {
                        this.trace(String.format("getCal: intf opened=%s", new Object[]{System.currentTimeMillis() - start}));
                    }
                    this.cali.beginTransaction();
                    this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: transaction started", (long)(System.currentTimeMillis() - start)));
                    if (this.trace()) {
                        this.trace(String.format("getCal: transaction started=%s", new Object[]{System.currentTimeMillis() - start}));
                    }
                    runAsUser = this.pars.getUser();
                    if (this.pars.getCalSuite() != null) {
                        cs = this.cali.getCalSuite(this.pars.getCalSuite());
                        if (cs == null) {
                            this.error("******************************************************");
                            this.error("Unable to fetch calendar suite " + this.pars.getCalSuite());
                            this.error("Is the database correctly initialised?");
                            this.error("******************************************************");
                            throw new BedeworkException("org.bedework.svci.unknown.calsuite", this.pars.getCalSuite());
                        }
                        this.getCalSuitesHandler().set(new BwCalSuiteWrapper(cs));
                        if (!this.pars.getPublicAdmin() && !this.pars.getPublicAuth()) {
                            runAsUser = cs.getGroup().getOwnerHref();
                        }
                    }
                    this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: before get dirs", (long)(System.currentTimeMillis() - start)));
                    if (this.trace()) {
                        this.trace(String.format("getCal: before get dirs=%s", new Object[]{System.currentTimeMillis() - start}));
                    }
                    dir = this.getDirectories();
                    if (authenticatedUser == null) ** GOTO lbl85
                    sv = authenticatedUser;
                    if (dir.isPrincipal(authenticatedUser)) {
                        authenticatedUser = dir.accountFromPrincipal(authenticatedUser);
                    }
                    if (authenticatedUser == null) {
                        this.error("Failed with Authenticated user " + sv);
                        var11_10 = null;
                        if (this.cali == null) break block67;
                    }
                    ** GOTO lbl-1000
                }
                catch (RuntimeException t) {
                    try {
                        if (!t.getMessage().equals("Upgrade to read/write")) {
                            this.error(t);
                        }
                        throw t;
                        catch (Throwable t) {
                            this.error(t);
                            throw new RuntimeException(t);
                        }
                    }
                    catch (Throwable var21_23) {
                        if (this.cali != null) {
                            try {
                                this.cali.endTransaction();
                                if (this.trace()) {
                                    this.trace(String.format("getCal: after endTransaction %s", new Object[]{System.currentTimeMillis() - start}));
                                }
                            }
                            catch (Throwable var22_24) {
                                // empty catch block
                            }
                            this.cali.close();
                            if (this.trace()) {
                                this.trace(String.format("getCal: after close %s", new Object[]{System.currentTimeMillis() - start}));
                            }
                        }
                        throw var21_23;
                    }
                }
                try {
                    this.cali.endTransaction();
                    if (this.trace()) {
                        this.trace(String.format("getCal: after endTransaction %s", new Object[]{System.currentTimeMillis() - start}));
                    }
                }
                catch (Throwable var12_12) {
                    // empty catch block
                }
                this.cali.close();
                if (this.trace()) {
                    this.trace(String.format("getCal: after close %s", new Object[]{System.currentTimeMillis() - start}));
                }
            }
            return var11_10;
lbl-1000:
            // 1 sources

            {
                if (authenticatedUser.endsWith("/")) {
                    this.getLogger().warn("Authenticated user " + authenticatedUser + " ends with \"/\"");
                }
lbl85:
                // 4 sources

                this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: before user fetch", (long)(System.currentTimeMillis() - start)));
                if (this.trace()) {
                    this.trace(String.format("getCal: before user fetch=%s", new Object[]{System.currentTimeMillis() - start}));
                }
                users = (Users)this.getUsersHandler();
                if (runAsUser == null) {
                    runAsUser = authenticatedUser;
                }
                maxAllowedPrivs = null;
                subscriptionsOnly = this.getSystemProperties().getUserSubscriptionsOnly();
                userMapHit = false;
                addingUser = false;
                addingRunAsUser = false;
                if (this.pars.getForRestore()) {
                    authPrincipal = currentPrincipal = dir.caladdrToPrincipal(this.pars.getAuthUser());
                    subscriptionsOnly = false;
                } else if (authenticatedUser == null) {
                    currentPrincipal = CalSvc.unauthUsers.get(runAsUser);
                    if (currentPrincipal == null) {
                        currentPrincipal = users.getUser(runAsUser);
                    } else {
                        userMapHit = true;
                    }
                    if (currentPrincipal == null) {
                        currentPrincipal = BwPrincipal.makeUserPrincipal();
                    }
                    currentPrincipal.setUnauthenticated(true);
                    if (!userMapHit) {
                        CalSvc.unauthUsers.put(runAsUser, currentPrincipal);
                    }
                    authPrincipal = currentPrincipal;
                    maxAllowedPrivs = PrivilegeSet.readOnlyPrivileges;
                } else {
                    currentPrincipal = CalSvc.unauthUsers.get(authenticatedUser);
                    if (currentPrincipal == null) {
                        currentPrincipal = users.getUser(authenticatedUser);
                    } else {
                        userMapHit = true;
                    }
                    if (currentPrincipal == null) {
                        if (this.pars.getReadonly()) {
                            throw new RuntimeException("Upgrade to read/write");
                        }
                        this.getLogger().debug("Add new user " + authenticatedUser);
                        currentPrincipal = this.getFakeUser(authenticatedUser);
                        addingUser = true;
                    }
                    authPrincipal = currentPrincipal;
                    if (authenticatedUser.equals(runAsUser)) {
                        this.audit(String.format("Authenticated user %s logged on - logid %s - admin %b", new Object[]{authenticatedUser, this.pars.getLogId(), this.pars.getPublicAdmin()}));
                    } else {
                        currentPrincipal = CalSvc.unauthUsers.get(runAsUser);
                        if (currentPrincipal == null) {
                            currentPrincipal = users.getUser(runAsUser);
                        } else {
                            userMapHit = true;
                        }
                        if (currentPrincipal == null) {
                            this.debug("Add new run-as-user " + runAsUser);
                            currentPrincipal = this.getFakeUser(runAsUser);
                            addingRunAsUser = true;
                        }
                        this.audit(String.format("Authenticated user %s logged on -  - running as %s logid %s - admin %b", new Object[]{authenticatedUser, runAsUser, this.pars.getLogId(), this.pars.getPublicAdmin()}));
                    }
                    if (!userMapHit && currentPrincipal != null) {
                        currentPrincipal.setGroups(dir.getAllGroups(currentPrincipal));
                        CalSvc.authUsers.put(currentPrincipal.getAccount(), currentPrincipal);
                    }
                    this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: after get Groups", (long)(System.currentTimeMillis() - start)));
                    if (this.trace()) {
                        this.trace(String.format("getCal: after get groups=%s", new Object[]{System.currentTimeMillis() - start}));
                    }
                    if (this.pars.getService()) {
                        subscriptionsOnly = false;
                    } else {
                        bwpi = dir.getDirInfo(currentPrincipal);
                        currentPrincipal.setPrincipalInfo(bwpi);
                        if (this.pars.getPublicAdmin() || bwpi != null && bwpi.getHasFullAccess()) {
                            subscriptionsOnly = false;
                        }
                        this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: got Dirinfo", (long)(System.currentTimeMillis() - start)));
                        if (this.trace()) {
                            this.trace(String.format("getCal: got dirinfo=%s", new Object[]{System.currentTimeMillis() - start}));
                        }
                    }
                }
                this.principalInfo = new SvciPrincipalInfo(this, (BwPrincipal)currentPrincipal, (BwPrincipal)authPrincipal, maxAllowedPrivs, subscriptionsOnly);
                this.cali.initPinfo(this.principalInfo);
                if (addingUser) {
                    this.addUser(authenticatedUser);
                }
                if (addingRunAsUser) {
                    this.addUser(runAsUser);
                }
                if (!currentPrincipal.getUnauthenticated()) {
                    if (this.pars.getService()) {
                        this.postNotification((SysEventBase)SysEvent.makePrincipalEvent((SysEventBase.SysCode)SysEventBase.SysCode.SERVICE_USER_LOGIN, (String)currentPrincipal.getPrincipalRef(), (long)(System.currentTimeMillis() - start)));
                    } else if (!this.creating) {
                        users.logon(currentPrincipal);
                        this.postNotification((SysEventBase)SysEvent.makePrincipalEvent((SysEventBase.SysCode)SysEventBase.SysCode.USER_LOGIN, (String)currentPrincipal.getPrincipalRef(), (long)(System.currentTimeMillis() - start)));
                    }
                    if (this.debug() && !Util.isEmpty((Collection)(groups = currentPrincipal.getGroups()))) {
                        for (BwGroup group : groups) {
                            this.debug("Group: " + group.getAccount());
                        }
                    }
                }
                if ((this.pars.getPublicAdmin() || this.pars.isGuest()) && this.debug()) {
                    this.debug("PublicAdmin: " + this.pars.getPublicAdmin() + " user: " + runAsUser);
                }
                if (this.trace()) {
                    this.trace(String.format("getCal: return %s", new Object[]{System.currentTimeMillis() - start}));
                }
                var18_19 = this.cali;
                if (this.cali == null) break block68;
            }
            try {
                this.cali.endTransaction();
                if (this.trace()) {
                    this.trace(String.format("getCal: after endTransaction %s", new Object[]{System.currentTimeMillis() - start}));
                }
            }
            catch (Throwable var19_21) {
                // empty catch block
            }
            this.cali.close();
            if (this.trace()) {
                this.trace(String.format("getCal: after close %s", new Object[]{System.currentTimeMillis() - start}));
            }
        }
        return var18_19;
    }

    void initPrincipal(BwPrincipal<?> p) {
        this.getCal().addNewCalendars(p);
    }

    void setupSharableEntity(ShareableEntity entity, String ownerHref) {
        if (entity.getCreatorHref() == null) {
            entity.setCreatorHref(ownerHref);
        }
        this.setupOwnedEntity((OwnedEntity)entity, ownerHref);
    }

    void setupOwnedEntity(OwnedEntity entity, String ownerHref) {
        entity.setPublick(Boolean.valueOf(this.isPublicAdmin()));
        if (entity.getOwnerHref() == null) {
            if (entity.getPublick().booleanValue()) {
                entity.setOwnerHref(this.getUsersHandler().getPublicUser().getPrincipalRef());
            } else {
                entity.setOwnerHref(ownerHref);
            }
        }
    }

    BwPrincipal<?> getEntityOwner() {
        if (this.isPublicAdmin() || this.pars.isGuest()) {
            return this.getUsersHandler().getPublicUser();
        }
        return this.getPrincipal();
    }

    void pushPrincipal(BwPrincipal<?> principal) {
        BwPrincipal<?> pr = this.getUsersHandler().getUser(principal.getPrincipalRef());
        if (pr == null) {
            pr = this.addUser(principal.getPrincipalRef());
        }
        ((SvciPrincipalInfo)this.principalInfo).pushPrincipal(pr);
        this.getCal().principalChanged();
    }

    void pushPrincipalOrFail(String principalHref) {
        BwPrincipal pr = this.getDirectories().caladdrToPrincipal(principalHref);
        if (pr == null) {
            throw new RuntimeException("Unknown Principal " + principalHref);
        }
        ((SvciPrincipalInfo)this.principalInfo).pushPrincipal(pr);
        this.getCal().principalChanged();
    }

    void popPrincipal() {
        ((SvciPrincipalInfo)this.principalInfo).popPrincipal();
        this.getCal().principalChanged();
    }

    BwPrincipal<?> getFakeUser(String account) {
        Users users = (Users)this.getUsersHandler();
        return users.initUserObject(account);
    }

    BwPrincipal<?> addUser(String val) {
        Users users = (Users)this.getUsersHandler();
        this.getCal().flush();
        try {
            users.createUser(val);
        }
        catch (BedeworkException be) {
            if (be instanceof BedeworkConstraintViolationException) {
                this.warn("ConstraintViolationException trying to create " + val);
            }
            this.rollbackTransaction();
            if (this.debug()) {
                this.error(be);
            }
            throw be;
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            if (this.debug()) {
                this.error(t);
            }
            throw new BedeworkException(t);
        }
        BwPrincipal<?> principal = users.getUser(val);
        if (principal == null) {
            return null;
        }
        String caladdr = this.getDirectories().userToCaladdr(principal.getPrincipalRef());
        if (caladdr != null) {
            List<String> emails = Collections.singletonList(caladdr.substring("mailto:".length()));
            Notifications notify = (Notifications)this.getNotificationsHandler();
            notify.subscribe(principal, emails);
        }
        return principal;
    }

    private UserAuthCallBack getUserAuthCallBack() {
        if (this.uacb == null) {
            this.uacb = new UserAuthCallBack(this);
        }
        return (UserAuthCallBack)this.uacb;
    }

    private GroupsCallBack getGroupsCallBack() {
        if (this.gcb == null) {
            this.gcb = new GroupsCallBack(this);
        }
        return (GroupsCallBack)this.gcb;
    }

    private void fixUsers() {
        String auser;
        for (auser = this.pars.getAuthUser(); auser != null && auser.endsWith("/"); auser = auser.substring(0, auser.length() - 1)) {
        }
        this.pars.setAuthUser(auser);
    }

    private String getSynchItems(BwCalendar col, String vpath, String tokenPar, Set<SynchReportItem> items, boolean recurse) {
        SynchReportItem sri;
        String token;
        Events eventsH = (Events)this.getEventsHandler();
        ResourcesImpl resourcesH = (ResourcesImpl)this.getResourcesHandler();
        Calendars colsH = (Calendars)this.getCalendarsHandler();
        String path = col.getPath();
        String newToken = "";
        if (this.debug()) {
            this.debug("sync token: " + tokenPar + " col: " + col.getPath());
        }
        if (col.getTombstoned()) {
            return tokenPar;
        }
        BwCalendar resolvedCol = col.getInternalAlias() ? this.getCalendarsHandler().resolveAlias(col, true, false) : col;
        if (resolvedCol.getTombstoned()) {
            return tokenPar;
        }
        if (tokenPar == null) {
            token = null;
        } else if (colsH.getSyncTokenIsValid(tokenPar, path)) {
            token = tokenPar;
        } else {
            return null;
        }
        boolean eventsOnly = resolvedCol.getCollectionInfo().onlyCalEntities;
        Set<EventInfo> evs = eventsH.getSynchEvents(resolvedCol.getPath(), token);
        for (EventInfo eventInfo : evs) {
            if (!eventInfo.getEvent().getTombstoned().booleanValue() && !eventsH.isVisible(col, eventInfo.getEvent().getName())) continue;
            SynchReportItem sri2 = new SynchReportItem(vpath, eventInfo);
            items.add(sri2);
            if (sri2.getToken().compareTo(newToken) <= 0) continue;
            newToken = sri2.getToken();
        }
        if (!eventsOnly) {
            List<BwResource> ress = resourcesH.getSynchResources(resolvedCol.getPath(), token);
            for (BwResource r : ress) {
                SynchReportItem sri3 = new SynchReportItem(vpath, r);
                items.add(sri3);
                if (sri3.getToken().compareTo(newToken) <= 0) continue;
                newToken = sri3.getToken();
            }
        }
        TreeSet<SynchReportItem> colItems = new TreeSet<SynchReportItem>();
        Set<BwCalendar> set = colsH.getSynchCols(resolvedCol.getPath(), token);
        ArrayList<BwCalendar> aliases = new ArrayList<BwCalendar>();
        for (BwCalendar c : set) {
            int calType = c.getCalType();
            if (calType == 13) continue;
            if (token != null && calType == 7) {
                aliases.add(c);
                continue;
            }
            sri = new SynchReportItem(vpath, c, this.canSync(c));
            colItems.add(sri);
            items.add(sri);
            if (sri.getToken().compareTo(newToken) > 0) {
                newToken = sri.getToken();
            }
            if (!this.debug()) continue;
            this.debug("     token=" + sri.getToken() + " for " + c.getPath());
        }
        if (!Util.isEmpty(aliases)) {
            for (BwCalendar c : aliases) {
                BwCalendar resolved = this.getCalendarsHandler().resolveAlias(c, true, false);
                if (resolved == null || c.getTombstoned() && !this.getCal().testSynchCol(c, token) || !this.getCal().testSynchCol(resolved, token)) continue;
                sri = new SynchReportItem(vpath, c, this.canSync(c), resolved.getLastmod().getTagValue());
                colItems.add(sri);
                items.add(sri);
                if (sri.getToken().compareTo(newToken) <= 0) continue;
                newToken = sri.getToken();
            }
        }
        if (!recurse) {
            return newToken;
        }
        if (Util.isEmpty(colItems)) {
            return newToken;
        }
        for (SynchReportItem sri4 : colItems) {
            if (!sri4.getCanSync()) continue;
            BwCalendar sricol = sri4.getCol();
            String t = this.getSynchItems(sricol, Util.buildPath((boolean)true, (String[])new String[]{vpath, "/", sricol.getName()}), token, items, true);
            if (t == null || !colsH.getSyncTokenIsValid(t, null) || t.compareTo(newToken) <= 0) continue;
            newToken = t;
        }
        return newToken;
    }

    void touchCalendar(String href) {
        this.getCal().touchCalendar(href);
    }

    void touchCalendar(BwCalendar col) {
        this.getCal().touchCalendar(col);
    }

    PwEncryptionIntf getEncrypter() {
        if (this.pwEncrypt != null) {
            return this.pwEncrypt;
        }
        try {
            String pwEncryptClass = "org.bedework.util.security.PwEncryptionDefault";
            this.pwEncrypt = (PwEncryptionIntf)Util.getObject((ClassLoader)this.getClass().getClassLoader(), (String)"org.bedework.util.security.PwEncryptionDefault", PwEncryptionIntf.class);
            String privKeys = null;
            String pubKeys = null;
            GenKeysMBean gk = (GenKeysMBean)MBeanUtil.getMBean(GenKeysMBean.class, (String)"org.bedework.util:service=BwGenKeys");
            if (gk != null) {
                privKeys = gk.getPrivKeyFileName();
                pubKeys = gk.getPublicKeyFileName();
            }
            if (privKeys == null) {
                throw new BedeworkException("Unable to get keyfile locations. Is genkeys service installed?");
            }
            this.pwEncrypt.init(privKeys, pubKeys);
            return this.pwEncrypt;
        }
        catch (Throwable t) {
            this.error(t);
            throw new BedeworkException(t);
        }
    }

    CalSvcIPars getPars() {
        return this.pars;
    }

    private boolean isPublicAdmin() {
        return this.pars.getPublicAdmin();
    }

    private boolean isPublicAuth() {
        return this.pars.getPublicAuth();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
            this.logger.enableAuditLogger();
        }
        return this.logger;
    }

    static {
        try {
            configs = CalSvcFactoryDefault.getSystemConfig();
            new SuggestParsers();
            new EventregParsers();
            new AdminNoteParsers();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        tzserverUri = null;
        authUsers = new HashMap();
        unauthUsers = new HashMap();
        authLogger = new BwLogger();
        authLogger.setLoggedName("org.bedework.authentication");
    }

    private class IcalCallbackcb
    implements IcalCallback {
        private int strictness = 0;
        private final Boolean timezonesByReference;

        IcalCallbackcb(Boolean timezonesByReference) {
            this.timezonesByReference = timezonesByReference;
        }

        public void setStrictness(int val) {
            this.strictness = val;
        }

        public int getStrictness() {
            return this.strictness;
        }

        public BwPrincipal<?> getPrincipal() {
            return CalSvc.this.getPrincipal();
        }

        public BwPrincipal<?> getOwner() {
            if (CalSvc.this.isPublicAdmin()) {
                return CalSvc.this.getUsersHandler().getPublicUser();
            }
            return CalSvc.this.getPrincipal();
        }

        public String getCaladdr(String val) {
            return CalSvc.this.getDirectories().userToCaladdr(val);
        }

        public GetEntityResponse<BwCategory> findCategory(BwString val) {
            return CalSvc.this.getCategoriesHandler().findPersistent(val);
        }

        public void addCategory(BwCategory val) {
            CalSvc.this.getCategoriesHandler().add((BwEventProperty)val);
        }

        public GetEntityResponse<BwContact> getContact(String uid) {
            return CalSvc.this.getContactsHandler().getByUid(uid);
        }

        public GetEntityResponse<BwContact> findContact(BwString val) {
            return CalSvc.this.getContactsHandler().findPersistent(val);
        }

        public void addContact(BwContact val) {
            CalSvc.this.getContactsHandler().add((BwEventProperty)val);
        }

        public GetEntityResponse<BwLocation> getLocation(String uid) {
            return CalSvc.this.getLocationsHandler().getByUid(uid);
        }

        public GetEntityResponse<BwLocation> fetchLocationByKey(String name, String val) {
            return CalSvc.this.getLocationsHandler().fetchLocationByKey(name, val);
        }

        public GetEntityResponse<BwLocation> findLocation(BwString address) {
            return CalSvc.this.getLocationsHandler().findPersistent(address);
        }

        public GetEntityResponse<BwLocation> fetchLocationByCombined(String val, boolean persisted) {
            return CalSvc.this.getLocationsHandler().fetchLocationByCombined(val, persisted);
        }

        public void addLocation(BwLocation val) {
            CalSvc.this.getLocationsHandler().add((BwEventProperty)val);
        }

        public GetEntitiesResponse<EventInfo> getEvent(String colPath, String guid) {
            GetEntitiesResponse resp = new GetEntitiesResponse();
            try {
                Collection ents = CalSvc.this.getEventsHandler().getByUid(colPath, guid, null, RecurringRetrievalMode.overrides);
                if (Util.isEmpty((Collection)ents)) {
                    resp.setStatus(Response.Status.notFound);
                } else {
                    resp.setEntities(ents);
                }
                return resp;
            }
            catch (Throwable t) {
                return (GetEntitiesResponse)Response.error((Response)resp, (Throwable)t);
            }
        }

        public boolean getTimezonesByReference() {
            if (this.timezonesByReference != null) {
                return this.timezonesByReference;
            }
            return CalSvc.this.getSystemProperties().getTimezonesByReference();
        }
    }

    class SvcSimpleFilterParser
    extends SimpleFilterParser {
        final FlushMap<String, BwCalendar> cols = new FlushMap(20, 60000L, 100);

        SvcSimpleFilterParser() {
        }

        public BwCalendar getCollection(String path) {
            BwCalendar col = (BwCalendar)this.cols.get((Object)path);
            if (col != null) {
                return col;
            }
            col = CalSvc.this.getCalendarsHandler().get(path);
            this.cols.put((Object)path, (Object)col);
            return col;
        }

        public BwCalendar resolveAlias(BwCalendar val, boolean resolveSubAlias) {
            return CalSvc.this.getCalendarsHandler().resolveAlias(val, resolveSubAlias, false);
        }

        public Collection<BwCalendar> getChildren(BwCalendar col) {
            String path = col.getPath();
            BwCalendar cachedCol = (BwCalendar)this.cols.get((Object)path);
            if (cachedCol != null && cachedCol.getChildren() != null) {
                return col.getChildren();
            }
            Collection children = CalSvc.this.getCalendarsHandler().getChildren(col);
            if (cachedCol == null) {
                cachedCol = col;
            }
            cachedCol.setChildren(children);
            this.cols.put((Object)path, (Object)cachedCol);
            return children;
        }

        public BwCategory getCategoryByName(String name) {
            return (BwCategory)CalSvc.this.getCategoriesHandler().find(new BwString(null, name));
        }

        public GetEntityResponse<BwCategory> getCategoryByUid(String uid) {
            return CalSvc.this.getCategoriesHandler().getByUid(uid);
        }

        public BwView getView(String path) {
            return CalSvc.this.getViewsHandler().find(path);
        }

        public Collection<BwCalendar> decomposeVirtualPath(String vpath) {
            return CalSvc.this.getCalendarsHandler().decomposeVirtualPath(vpath);
        }

        public SimpleFilterParser getParser() {
            return new SvcSimpleFilterParser();
        }
    }
}

