/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webdav.servlet.common;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.common.Headers;
import org.bedework.webdav.servlet.common.SecureXml;
import org.bedework.webdav.servlet.shared.WebdavBadRequest;
import org.bedework.webdav.servlet.shared.WebdavNsIntf;
import org.bedework.webdav.servlet.shared.WebdavNsNode;
import org.bedework.webdav.servlet.shared.WebdavProperty;
import org.bedework.webdav.servlet.shared.WebdavStatusCode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MethodBase
implements Logged,
SecureXml {
    protected boolean dumpContent;
    protected boolean hasBriefHeader;
    protected WebdavNsIntf nsIntf;
    private String resourceUri;
    protected XmlEmit xml;
    private final SimpleDateFormat httpDateFormatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss ");
    private final BwLogger logger = new BwLogger();

    public abstract void init();

    public abstract void doMethod(HttpServletRequest var1, HttpServletResponse var2);

    public void init(WebdavNsIntf nsIntf, boolean dumpContent) {
        this.nsIntf = nsIntf;
        this.dumpContent = dumpContent;
        this.xml = nsIntf.getXmlEmit();
        this.resourceUri = null;
        this.init();
    }

    public WebdavNsIntf getNsIntf() {
        return this.nsIntf;
    }

    public String getResourceUri(HttpServletRequest req) {
        if (this.resourceUri != null) {
            return this.resourceUri;
        }
        this.resourceUri = this.getNsIntf().getResourceUri(req);
        if (this.debug()) {
            this.debug("resourceUri: " + this.resourceUri);
        }
        return this.resourceUri;
    }

    protected int defaultDepth(int depth, int def) {
        if (depth < 0) {
            return def;
        }
        return depth;
    }

    protected void checkDepth(int depth, int val) {
        if (depth != val) {
            throw new WebdavBadRequest();
        }
    }

    protected String getStatus(int status, String message) {
        if (message == null) {
            message = WebdavStatusCode.getMessage(status);
        }
        return "HTTP/1.1 " + status + " " + message;
    }

    protected void addStatus(int status, String message) {
        if (message == null) {
            message = WebdavStatusCode.getMessage(status);
        }
        this.property(WebdavTags.status, "HTTP/1.1 " + status + " " + message);
    }

    protected void addHeaders(HttpServletRequest req, HttpServletResponse resp, WebdavNsNode node) {
        this.addDavHeader(resp, node);
        resp.addHeader("MS-Author-Via", "DAV");
        StringBuilder methods = new StringBuilder();
        for (String name : this.getNsIntf().getMethodNames()) {
            if (!methods.isEmpty()) {
                methods.append(", ");
            }
            methods.append(name);
        }
        resp.addHeader("Allow", methods.toString());
    }

    public void checkServerInfo(HttpServletRequest req, HttpServletResponse resp) {
        String curToken = this.getNsIntf().getServerInfo().getToken();
        String method = req.getMethod();
        boolean sendServerInfoUrl = false;
        String theirToken = req.getHeader("server-info-token");
        if (theirToken == null) {
            sendServerInfoUrl = method.equalsIgnoreCase("options");
        } else if (!theirToken.equals(curToken)) {
            sendServerInfoUrl = true;
        }
        if (sendServerInfoUrl) {
            resp.addHeader("Link", "<" + this.getNsIntf().makeServerInfoUrl(req) + ">; rel=\"server-info\"; token=\"" + curToken + "\"");
        }
    }

    protected void addDavHeader(HttpServletResponse resp, WebdavNsNode node) {
        resp.addHeader("DAV", this.getNsIntf().getDavHeader(node));
    }

    protected Document parseContent(HttpServletRequest req, HttpServletResponse resp) {
        this.hasBriefHeader = Headers.brief(req);
        return this.parseContent(req.getContentLength(), this.getNsIntf().getReader(req));
    }

    protected Document parseContent(int contentLength, Reader reader) {
        Document doc = this.parseXmlSafely(contentLength, reader);
        if (doc == null) {
            this.debug("No document");
        } else {
            this.debug(doc.toString());
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPropFind(WebdavNsNode node, Collection<WebdavProperty> props) {
        WebdavNsIntf intf = this.getNsIntf();
        ArrayList<WebdavProperty> unknowns = new ArrayList<WebdavProperty>();
        Holder openFlag = new Holder((Object)Boolean.FALSE);
        XmlNotifier notifier = new XmlNotifier((Holder<Boolean>)openFlag);
        try {
            this.xml.setNotifier((XmlEmit.Notifier)notifier);
            for (WebdavProperty pr : props) {
                if (!intf.knownProperty(node, pr)) {
                    unknowns.add(pr);
                    continue;
                }
                this.addNs(pr.getTag().getNamespaceURI());
                if (intf.generatePropValue(node, pr, false)) continue;
                unknowns.add(pr);
            }
            if (((Boolean)openFlag.value).booleanValue()) {
                this.closeTag(WebdavTags.prop);
                this.addStatus(node.getStatus(), null);
                this.closeTag(WebdavTags.propstat);
            }
            this.xml.setNotifier(null);
            if (!this.hasBriefHeader && !unknowns.isEmpty()) {
                this.openTag(WebdavTags.propstat);
                this.openTag(WebdavTags.prop);
                for (WebdavProperty prop : unknowns) {
                    this.xml.emptyTag(prop.getTag());
                }
                this.closeTag(WebdavTags.prop);
                this.addStatus(404, null);
                this.closeTag(WebdavTags.propstat);
            }
        }
        finally {
            this.xml.setNotifier(null);
        }
    }

    protected Collection<Element> getChildren(Node nd) {
        return XmlUtil.getElements((Node)nd);
    }

    protected Element[] getChildrenArray(Node nd) {
        return XmlUtil.getElementsArray((Node)nd);
    }

    protected GetEntityResponse<Element> getOnlyChild(Node nd) {
        GetEntityResponse resp = new GetEntityResponse();
        try {
            resp.setEntity((Object)XmlUtil.getOnlyElement((Node)nd));
            return resp;
        }
        catch (Throwable t) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)t);
        }
    }

    protected String getElementContent(Element el) {
        return XmlUtil.getElementContent((Node)el);
    }

    protected boolean isEmpty(Element el) {
        return XmlUtil.isEmpty((Element)el);
    }

    protected void startEmit(HttpServletResponse resp) {
        try {
            this.xml.startEmit((Writer)resp.getWriter());
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    public void addNs(String val) {
        if (this.xml.getNameSpace(val) == null) {
            this.xml.addNs(new XmlEmit.NameSpace(val, null), false);
        }
    }

    public String getNsAbbrev(String ns) {
        return this.xml.getNsAbbrev(ns);
    }

    protected void openTag(QName tag) {
        this.xml.openTag(tag);
    }

    protected void openTagNoNewline(QName tag) {
        this.xml.openTagNoNewline(tag);
    }

    protected void closeTag(QName tag) {
        this.xml.closeTag(tag);
    }

    public void emptyTag(QName tag) {
        this.xml.emptyTag(tag);
    }

    public void emptyTag(Node nd) {
        String ns = nd.getNamespaceURI();
        String ln = nd.getLocalName();
        this.emptyTag(new QName(ns, ln));
    }

    public void property(QName tag, String val) {
        this.xml.property(tag, val);
    }

    public void cdataProperty(QName tag, String attrName, String attrVal, String val) {
        if (attrName == null) {
            this.xml.cdataProperty(tag, val);
        } else {
            this.xml.openTagSameLine(tag, attrName, attrVal);
            this.xml.cdataValue(val);
            this.xml.closeTagSameLine(tag);
        }
    }

    public void property(QName tag, Reader val) {
        this.xml.property(tag, val);
    }

    public void propertyTagVal(QName tag, QName tagVal) {
        this.xml.propertyTagVal(tag, tagVal);
    }

    protected void flush() {
        this.xml.flush();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    private class XmlNotifier
    extends XmlEmit.Notifier {
        private boolean enabled;
        private final Holder<Boolean> openFlag;

        XmlNotifier(Holder<Boolean> openFlag) {
            this.openFlag = openFlag;
            this.enabled = true;
        }

        public void doNotification() {
            this.enabled = false;
            if (!((Boolean)this.openFlag.value).booleanValue()) {
                this.openFlag.value = true;
                MethodBase.this.openTag(WebdavTags.propstat);
                MethodBase.this.openTag(WebdavTags.prop);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class MethodInfo {
        private final Class<?> methodClass;
        private final boolean requiresAuth;

        public MethodInfo(Class<?> methodClass, boolean requiresAuth) {
            this.methodClass = methodClass;
            this.requiresAuth = requiresAuth;
        }

        public Class<?> getMethodClass() {
            return this.methodClass;
        }

        public boolean getRequiresAuth() {
            return this.requiresAuth;
        }
    }
}

