/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webdav.servlet.common;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.common.Headers;
import org.bedework.webdav.servlet.common.PropPatchMethod;
import org.bedework.webdav.servlet.shared.WebdavException;
import org.bedework.webdav.servlet.shared.WebdavNsIntf;
import org.bedework.webdav.servlet.shared.WebdavNsNode;
import org.w3c.dom.Document;

public class MkcolMethod
extends PropPatchMethod {
    @Override
    public void init() {
    }

    @Override
    public void doMethod(HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        if (this.debug) {
            this.debug("MkcolMethod: doMethod");
        }
        WebdavNsIntf intf = this.getNsIntf();
        Headers.IfHeaders ifHeaders = Headers.processIfHeaders(req);
        if (ifHeaders.ifHeader != null && !intf.syncTokenMatch(ifHeaders.ifHeader)) {
            intf.rollback();
            throw new WebdavException(412);
        }
        Document doc = this.parseContent(req, resp);
        String resourceUri = this.getResourceUri(req);
        WebdavNsNode node = intf.getNode(resourceUri, 0, 0, false);
        node.setDefaults(WebdavTags.mkcol);
        if (doc != null) {
            this.processDoc(req, resp, doc, node, WebdavTags.mkcol, true);
        }
        intf.makeCollection(req, resp, node);
    }
}

