/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;

public class StoredPublicKeyRecordRetriever
implements PublicKeyRecordRetriever {
    private static Map<String, Map<String, String>> pkeys = new HashMap<String, Map<String, String>>();

    public static void clearKeys() {
        pkeys.clear();
    }

    public static void addKey(String domain, String selector, String key) {
        Map<String, String> domainKeys = pkeys.get(domain);
        if (domainKeys == null) {
            domainKeys = new HashMap<String, String>();
            pkeys.put(domain, domainKeys);
        }
        domainKeys.put(selector, key);
    }

    @Override
    public List<String> getRecords(CharSequence methodAndOptions, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
        String key;
        if (!"private-exchange".equals(methodAndOptions)) {
            throw new PermFailException("Only private-exchange is supported: " + methodAndOptions + " options unsupported.");
        }
        ArrayList<String> records = new ArrayList<String>();
        Map<String, String> domainKeys = pkeys.get(token);
        if (domainKeys != null && (key = domainKeys.get(selector)) != null) {
            records.add(key);
        }
        return records;
    }
}

