/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.MessageBuilder;
import org.apache.james.mime4j.dom.MessageServiceFactory;
import org.apache.james.mime4j.dom.MessageWriter;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.io.EOLConvertingInputStream;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;

public class Message
implements Headers {
    private org.apache.james.mime4j.dom.Message message;

    public Message(InputStream is) throws IOException, MimeException {
        org.apache.james.mime4j.dom.Message mImpl;
        MessageBuilder mb = this.newMessageBuilder().newMessageBuilder();
        this.message = mImpl = mb.parseMessage((InputStream)new EOLConvertingInputStream(is));
    }

    private MessageServiceFactory newMessageBuilder() throws MimeException {
        MimeConfig mec = new MimeConfig();
        mec.setMaxLineLen(10000);
        mec.setMaxHeaderLen(30000);
        MessageServiceFactory mbf = MessageServiceFactory.newInstance();
        mbf.setAttribute("MimeEntityConfig", (Object)mec);
        mbf.setAttribute("FlatMode", (Object)true);
        mbf.setAttribute("ContentDecoding", (Object)false);
        return mbf;
    }

    public InputStream getBodyInputStream() {
        try {
            return ((SingleBody)this.message.getBody()).getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<String> getFields() {
        List res = this.message.getHeader().getFields();
        return this.convertFields(res);
    }

    private List<String> convertFields(List<Field> res) {
        MessageWriter mw;
        LinkedList<String> res2 = new LinkedList<String>();
        try {
            mw = this.newMessageBuilder().newMessageWriter();
        }
        catch (MimeException e1) {
            return res2;
        }
        for (Field f : res) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            String field = null;
            try {
                mw.writeField(f, (OutputStream)bos);
                byte[] fieldbytes = bos.toByteArray();
                field = new String(fieldbytes, 0, fieldbytes.length - 2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            res2.add(field);
        }
        return res2;
    }

    @Override
    public List<String> getFields(String name) {
        return this.convertFields(this.message.getHeader().getFields(name));
    }

    public String toString() {
        return this.message.toString();
    }

    public void dispose() {
        this.message.dispose();
    }
}

